/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.particle;

import com.hollingsworth.arsnouveau.api.particle.PropertyParticleOptions;
import com.hollingsworth.arsnouveau.client.gui.Color;
import com.hollingsworth.arsnouveau.client.particle.ColorGradientInterpolator;
import com.hollingsworth.arsnouveau.client.particle.ColorPoint;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;

public class ANSmokeParticle
extends TextureSheetParticle {
    public SpriteSet spriteSet;
    public static List<ColorPoint> gradients = new ArrayList<ColorPoint>(){
        {
            this.add(new ColorPoint(0.0, new Color(215, 193, 47)));
            this.add(new ColorPoint(0.19, new Color(178, 88, 36)));
            this.add(new ColorPoint(0.38, new Color(90, 34, 10)));
            this.add(new ColorPoint(0.68, new Color(35, 7, 7)));
            this.add(new ColorPoint(1.0, new Color(31, 31, 31)));
        }
    };
    ColorGradientInterpolator gradient;

    protected ANSmokeParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SpriteSet spriteSet) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.spriteSet = spriteSet;
        this.setSpriteFromAge(spriteSet);
        this.gradient = new ColorGradientInterpolator(() -> (double)this.age / (double)this.lifetime, gradients);
        this.lifetime = this.random.nextInt(40) + 20;
        this.gravity = 3.0E-6f;
        this.xd = xSpeed;
        this.yd = ySpeed + (double)(this.random.nextFloat() / 500.0f);
        this.zd = zSpeed;
        Color currentColor = this.gradient.getCurrentColor();
        this.setColor(currentColor.getRedAsFloat(), currentColor.getGreenAsFloat(), currentColor.getBlueAsFloat());
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ < this.lifetime && !(this.alpha <= 0.0f)) {
            this.xd += (double)(this.random.nextFloat() / 5000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.zd += (double)(this.random.nextFloat() / 5000.0f * (float)(this.random.nextBoolean() ? 1 : -1));
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.age >= this.lifetime - 60 && this.alpha > 0.01f) {
                this.alpha -= 0.015f;
            }
        } else {
            this.remove();
        }
        this.setSpriteFromAge(this.spriteSet);
        Color currentColor = this.gradient.getCurrentColor();
        this.setColor(currentColor.getRedAsFloat(), currentColor.getGreenAsFloat(), currentColor.getBlueAsFloat());
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public static class Provider
    implements ParticleProvider<PropertyParticleOptions> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(PropertyParticleOptions pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            ANSmokeParticle bubblecolumnupparticle = new ANSmokeParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, this.sprite);
            bubblecolumnupparticle.pickSprite(this.sprite);
            return bubblecolumnupparticle;
        }
    }
}

