/*
 * Decompiled with CFR 0.152.
 */
package com.hollingsworth.arsnouveau.client.emi;

import com.google.common.collect.ImmutableList;
import com.hollingsworth.arsnouveau.client.emi.EmiArsNouveauPlugin;
import com.hollingsworth.arsnouveau.client.emi.EmiEnchantingApparatusRecipe;
import com.hollingsworth.arsnouveau.client.emi.EmiMultiInputRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ApparatusRecipeInput;
import com.hollingsworth.arsnouveau.common.crafting.recipes.EnchantmentRecipe;
import com.hollingsworth.arsnouveau.common.crafting.recipes.ReactiveEnchantmentRecipe;
import com.hollingsworth.arsnouveau.common.util.HolderHelper;
import com.hollingsworth.arsnouveau.setup.registry.EnchantmentRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.render.EmiTooltipComponents;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.Level;

public class EmiApparatusEnchantingRecipe
extends EmiEnchantingApparatusRecipe<EnchantmentRecipe> {
    private final int uniq = ThreadLocalRandom.current().nextInt();
    protected List<ItemStack> enchantableCache = null;
    protected static List<ItemStack> reactiveEnchantableCache = null;

    public EmiApparatusEnchantingRecipe(ResourceLocation id, EnchantmentRecipe recipe) {
        super(id, recipe);
    }

    public boolean supportsRecipeTree() {
        return false;
    }

    @Override
    public EmiRecipeCategory getCategory() {
        return EmiArsNouveauPlugin.APPARATUS_ENCHANTING_CATEGORY;
    }

    @Override
    public void addWidgets(WidgetHolder widgets) {
        this.reset();
        double angleBetweenEach = 360.0 / (double)((EnchantmentRecipe)this.recipe).pedestalItems().size();
        EmiMultiInputRecipe.MultiProvider provider = this.multiProvider;
        ClientLevel level = Minecraft.getInstance().level;
        ItemStack dummy = ((EnchantmentRecipe)this.getRecipe()).enchantLevel > 1 ? this.createEnchantedBook(((EnchantmentRecipe)this.recipe).enchantLevel - 1) : Items.BOOK.getDefaultInstance();
        MutableComponent message = ((EnchantmentRecipe)this.getRecipe()).enchantLevel == 1 ? Component.literal((String)"Any compatible item") : Component.literal((String)"Needs lower level enchantment");
        dummy.set(DataComponents.CUSTOM_NAME, (Object)message);
        List<ItemStack> enchantable = this.getEnchantable();
        if (enchantable.isEmpty()) {
            enchantable.add(dummy);
        }
        widgets.addGeneratedSlot(r -> EmiStack.of((ItemStack)this.getStack((Random)r, enchantable, dummy)), this.uniq, (int)this.center.x, (int)this.center.y).appendTooltip(() -> EmiTooltipComponents.getIngredientTooltipComponent(enchantable.stream().map(EmiStack::of).toList()));
        for (EmiIngredient input : provider.getEmiInputs()) {
            widgets.addSlot(input, (int)this.point.x, (int)this.point.y);
            this.point = EmiApparatusEnchantingRecipe.rotatePointAbout(this.point, this.center, angleBetweenEach);
        }
        widgets.addGeneratedSlot(arg_0 -> this.lambda$addWidgets$2(enchantable, dummy, (Level)level, arg_0), this.uniq, 100, 3).recipeContext((EmiRecipe)this);
        this.addSourceWidget(widgets);
    }

    private void addName(ItemStack stack) {
        MutableComponent message = ((EnchantmentRecipe)this.getRecipe()).enchantLevel == 1 ? Component.literal((String)"Any compatible item") : Component.literal((String)"Needs lower level enchantment");
        stack.set(DataComponents.CUSTOM_NAME, (Object)message);
    }

    @Override
    protected List<EmiIngredient> generateInputs() {
        List<EmiIngredient> inputs = super.generateInputs();
        if (!inputs.isEmpty()) {
            inputs.set(0, EmiIngredient.of(this.getEnchantable().stream().map(EmiStack::of).toList()));
        }
        return inputs;
    }

    public ItemStack createEnchantedBook(int level) {
        return EnchantedBookItem.createForEnchantment((EnchantmentInstance)new EnchantmentInstance(HolderHelper.unwrap((Level)Minecraft.getInstance().level, ((EnchantmentRecipe)this.recipe).enchantmentKey), level));
    }

    public ItemStack createEnchantedBook() {
        return this.createEnchantedBook(((EnchantmentRecipe)this.recipe).enchantLevel);
    }

    @Override
    public List<EmiStack> getOutputs() {
        return List.of(EmiStack.of((ItemStack)this.createEnchantedBook()));
    }

    private List<ItemStack> getEnchantable() {
        ImmutableList.Builder builder;
        if (this.recipe instanceof ReactiveEnchantmentRecipe || ((EnchantmentRecipe)this.recipe).enchantmentKey == EnchantmentRegistry.REACTIVE_ENCHANTMENT) {
            if (reactiveEnchantableCache == null) {
                builder = ImmutableList.builder();
                for (Item item : BuiltInRegistries.ITEM) {
                    if (item == Items.AIR) continue;
                    ItemStack stack = item.getDefaultInstance();
                    this.addName(stack);
                    builder.add((Object)stack);
                }
                reactiveEnchantableCache = builder.build();
            }
            this.enchantableCache = reactiveEnchantableCache;
        }
        if (this.enchantableCache == null) {
            builder = ImmutableList.builder();
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null && level.holder(((EnchantmentRecipe)this.recipe).enchantmentKey).isPresent()) {
                Holder<Enchantment> enchantment = HolderHelper.unwrap((Level)level, ((EnchantmentRecipe)this.recipe).enchantmentKey);
                for (Item item : BuiltInRegistries.ITEM) {
                    ItemStack stack = item.getDefaultInstance();
                    this.addName(stack);
                    if (stack.is(Items.ENCHANTED_BOOK)) {
                        stack = this.createEnchantedBook(((EnchantmentRecipe)this.recipe).enchantLevel - 1);
                    } else {
                        stack.enchant(enchantment, ((EnchantmentRecipe)this.recipe).enchantLevel - 1);
                    }
                    ApparatusRecipeInput apparatus = new ApparatusRecipeInput(stack, List.of(), null);
                    try {
                        if (!((EnchantmentRecipe)this.recipe).doesReagentMatch(apparatus, (Level)level, null)) continue;
                        builder.add((Object)stack);
                    }
                    catch (Exception exception) {}
                }
            }
            this.enchantableCache = builder.build();
        }
        return this.enchantableCache;
    }

    private ItemStack getStack(Random r, List<ItemStack> of, ItemStack def) {
        return of.isEmpty() ? def : of.get(r.nextInt(of.size()));
    }

    private /* synthetic */ EmiIngredient lambda$addWidgets$2(List enchantable, ItemStack dummy, Level level, Random r) {
        ItemStack stack = this.getStack(r, enchantable, dummy).copy();
        stack.remove(DataComponents.CUSTOM_NAME);
        if (stack.is(Items.ENCHANTED_BOOK)) {
            stack = this.createEnchantedBook();
        } else if (level != null) {
            stack.enchant(HolderHelper.unwrap(level, ((EnchantmentRecipe)this.recipe).enchantmentKey), ((EnchantmentRecipe)this.recipe).enchantLevel);
        }
        return EmiStack.of((ItemStack)stack);
    }
}

