/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsbuilder.modules.shield.blocks;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.api.container.DefaultContainerProvider;
import mcjty.lib.api.container.ItemInventory;
import mcjty.lib.api.information.IPowerInformation;
import mcjty.lib.api.infusable.DefaultInfusable;
import mcjty.lib.api.infusable.IInfusable;
import mcjty.lib.api.infusable.ItemInfusable;
import mcjty.lib.api.power.ItemEnergy;
import mcjty.lib.api.smartwrench.ISmartWrenchSelector;
import mcjty.lib.bindings.GuiValue;
import mcjty.lib.bindings.Value;
import mcjty.lib.blockcommands.Command;
import mcjty.lib.blockcommands.ListCommand;
import mcjty.lib.blockcommands.ServerCommand;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericItemHandler;
import mcjty.lib.container.SlotDefinition;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.Cap;
import mcjty.lib.tileentity.CapType;
import mcjty.lib.tileentity.GenericEnergyStorage;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tileentity.TickingTileEntity;
import mcjty.lib.typed.Key;
import mcjty.lib.typed.Type;
import mcjty.lib.varia.DamageTools;
import mcjty.lib.varia.FakePlayerGetter;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.OrientationTools;
import mcjty.lib.varia.Tools;
import mcjty.rftoolsbase.modules.various.VariousModule;
import mcjty.rftoolsbuilder.modules.builder.items.ShapeCardItem;
import mcjty.rftoolsbuilder.modules.shield.DamageTypeMode;
import mcjty.rftoolsbuilder.modules.shield.RelCoordinateShield;
import mcjty.rftoolsbuilder.modules.shield.ShieldConfiguration;
import mcjty.rftoolsbuilder.modules.shield.ShieldModule;
import mcjty.rftoolsbuilder.modules.shield.ShieldRenderingMode;
import mcjty.rftoolsbuilder.modules.shield.ShieldTexture;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldTemplateBlock;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldingBlock;
import mcjty.rftoolsbuilder.modules.shield.blocks.ShieldingTileEntity;
import mcjty.rftoolsbuilder.modules.shield.client.GuiShield;
import mcjty.rftoolsbuilder.modules.shield.client.ShieldRenderData;
import mcjty.rftoolsbuilder.modules.shield.data.ShieldData;
import mcjty.rftoolsbuilder.modules.shield.filters.AbstractShieldFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.PlayerFilter;
import mcjty.rftoolsbuilder.modules.shield.filters.ShieldFilter;
import mcjty.rftoolsbuilder.modules.shield.network.PacketNotifyServerClientReady;
import mcjty.rftoolsbuilder.setup.RFToolsBuilderMessages;
import mcjty.rftoolsbuilder.shapes.Shape;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.Lazy;

public class ShieldProjectorTileEntity
extends TickingTileEntity
implements ISmartWrenchSelector {
    public static final String COMPONENT_NAME = "shield_projector";
    @GuiValue
    public static final Value<?, Integer> VALUE_SHIELDVISMODE = Value.create((String)"shieldVisMode", (Type)Type.INTEGER, te -> te.getShieldRenderingMode().ordinal(), (te, v) -> te.setShieldRenderingMode(ShieldRenderingMode.values()[v]));
    @GuiValue
    public static final Value<?, Integer> VALUE_SHIELDTEXTURE = Value.create((String)"shieldTexture", (Type)Type.INTEGER, te -> te.getShieldTexture().ordinal(), (te, v) -> te.setShieldTexture(ShieldTexture.values()[v]));
    @GuiValue
    public static final Value<?, Integer> VALUE_DAMAGEMODE = Value.create((String)"damageMode", (Type)Type.INTEGER, te -> te.getDamageMode().ordinal(), (te, v) -> te.setDamageMode(DamageTypeMode.values()[v]));
    @GuiValue
    public static final Value<?, Integer> VALUE_COLOR = Value.create((String)"color", (Type)Type.INTEGER, ShieldProjectorTileEntity::getShieldColor, ShieldProjectorTileEntity::setShieldColor);
    @GuiValue
    public static final Value<?, Boolean> VALUE_LIGHT = Value.create((String)"light", (Type)Type.BOOLEAN, ShieldProjectorTileEntity::isBlockLight, ShieldProjectorTileEntity::setBlockLight);
    private ShieldRenderData renderData;
    private boolean shieldComposed = false;
    private BlockState templateState = Blocks.AIR.defaultBlockState();
    private boolean shieldActive = false;
    private int powerTimeout = 0;
    private int updateTimeout = 0;
    private int supportedBlocks;
    private float damageFactor = 1.0f;
    private float costFactor = 1.0f;
    private final List<RelCoordinateShield> shieldBlocks = new ArrayList<RelCoordinateShield>();
    private final List<BlockState> blockStateTable = new ArrayList<BlockState>();
    private final FakePlayerGetter fakePlayer = new FakePlayerGetter((GenericTileEntity)this, "rftools_shield");
    public static final int SLOT_BUFFER = 0;
    public static final int SLOT_SHAPE = 1;
    public static final int SLOT_SHARD = 2;
    public static final int BUFFER_SIZE = 3;
    public static final Lazy<ContainerFactory> CONTAINER_FACTORY = Lazy.of(() -> new ContainerFactory(3).slot(SlotDefinition.generic().in(), 0, 26, 142).slot(SlotDefinition.specific(s -> s.getItem() instanceof ShapeCardItem).in().out(), 1, 26, 200).slot(SlotDefinition.specific(s -> s.getItem() == VariousModule.DIMENSIONALSHARD.get()).in().out(), 2, 229, 118).playerSlots(85, 142));
    private final GenericItemHandler items = GenericItemHandler.create((GenericTileEntity)this, CONTAINER_FACTORY).itemValid((slot, stack) -> {
        if (slot == 1) {
            return stack.getItem() instanceof ShapeCardItem;
        }
        if (slot == 2) {
            return stack.getItem() == VariousModule.DIMENSIONALSHARD.get();
        }
        return true;
    }).onUpdate((index, stack) -> {
        if (index == 1 && !stack.isEmpty()) {
            this.decomposeShield();
        }
    }).build();
    @Cap(type=CapType.ITEMS_AUTOMATION)
    private static final Function<ShieldProjectorTileEntity, GenericItemHandler> ITEM_CAP = te -> te.items;
    private final GenericEnergyStorage energyStorage;
    @Cap(type=CapType.ENERGY)
    private static final Function<ShieldProjectorTileEntity, GenericEnergyStorage> ENERGY_CAP = te -> te.energyStorage;
    @Cap(type=CapType.CONTAINER)
    private static final Function<ShieldProjectorTileEntity, MenuProvider> SCREEN_CAP = tile -> new DefaultContainerProvider("Shield").containerSupplier(DefaultContainerProvider.container(ShieldModule.CONTAINER_SHIELD, CONTAINER_FACTORY, (GenericTileEntity)tile)).energyHandler(() -> tile.getEnergyStorage()).itemHandler(() -> tile.items).data(ShieldModule.SHIELD_DATA, ShieldData.STREAM_CODEC, ShieldData.CODEC).setupSync((GenericTileEntity)tile);
    private final DefaultInfusable infusable = new DefaultInfusable((BlockEntity)this);
    @Cap(type=CapType.INFUSABLE)
    private static final Function<ShieldProjectorTileEntity, IInfusable> INFUSABLE_CAP = te -> te.infusable;
    private final IPowerInformation powerInfoHandler = this.createPowerInfo();
    @Cap(type=CapType.POWER_INFO)
    private static final Function<ShieldProjectorTileEntity, IPowerInformation> POWER_INFO_CAP = te -> te.powerInfoHandler;
    private final int maxEnergy;
    private final int rfPerTick;
    private ItemStack lootingSword = ItemStack.EMPTY;
    public static final Key<Integer> PARAM_ACTION = new Key("action", Type.INTEGER);
    public static final Key<String> PARAM_TYPE = new Key("type", Type.STRING);
    public static final Key<String> PARAM_PLAYER = new Key("player", Type.STRING);
    public static final Key<Integer> PARAM_SELECTED = new Key("selected", Type.INTEGER);
    @ServerCommand
    public static final Command<?> CMD_ADDFILTER = Command.create((String)"shield.addFilter", (te, player, params) -> te.addFilter((Integer)params.get(PARAM_ACTION), (String)params.get(PARAM_TYPE), (String)params.get(PARAM_PLAYER), (Integer)params.get(PARAM_SELECTED)));
    @ServerCommand
    public static final Command<?> CMD_DELFILTER = Command.create((String)"shield.delFilter", (te, player, params) -> te.delFilter((Integer)params.get(PARAM_SELECTED)));
    @ServerCommand
    public static final Command<?> CMD_UPFILTER = Command.create((String)"shield.upFilter", (te, player, params) -> te.upFilter((Integer)params.get(PARAM_SELECTED)));
    @ServerCommand
    public static final Command<?> CMD_DOWNFILTER = Command.create((String)"shield.downFilter", (te, player, params) -> te.downFilter((Integer)params.get(PARAM_SELECTED)));
    @ServerCommand(type=ShieldFilter.class, serializer=ShieldFilter.Serializer.class)
    public static final ListCommand<?, ?> CMD_GETFILTERS = ListCommand.create((String)"rftoolsbuilder.shield.getFilters", (te, player, params) -> te.getFilters(), (te, player, params, list) -> GuiShield.storeFiltersForClient(list));

    public ShieldProjectorTileEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int supportedBlocks, int maxEnergy, int rfPerTick) {
        super(type, pos, state);
        this.supportedBlocks = supportedBlocks;
        this.maxEnergy = maxEnergy;
        this.rfPerTick = rfPerTick;
        this.energyStorage = new GenericEnergyStorage((GenericTileEntity)this, true, (long)this.getConfigMaxEnergy(), (long)this.getConfigRfPerTick());
    }

    @Nonnull
    public GenericEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    private int getConfigMaxEnergy() {
        return this.maxEnergy;
    }

    private int getConfigRfPerTick() {
        return this.rfPerTick;
    }

    protected boolean needsRedstoneMode() {
        return true;
    }

    public ShieldProjectorTileEntity setDamageFactor(float factor) {
        this.damageFactor = factor;
        return this;
    }

    public ShieldProjectorTileEntity setCostFactor(float factor) {
        this.costFactor = factor;
        return this;
    }

    public ShieldRenderData getRenderData() {
        if (this.renderData == null) {
            int shieldColor = this.getShieldColor();
            float r = (float)(shieldColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(shieldColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(shieldColor & 0xFF) / 255.0f;
            this.renderData = new ShieldRenderData(r, g, b, 1.0f, this.getShieldTexture());
        }
        return this.renderData;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet, HolderLookup.Provider provider) {
        int shieldColor;
        int oldColor = shieldColor = this.getShieldColor();
        ShieldTexture oldTexture = this.getShieldTexture();
        super.onDataPacket(net, packet, provider);
        if (oldColor != shieldColor || oldTexture != this.getShieldTexture()) {
            this.renderData = null;
            BlockState state = this.level.getBlockState(this.worldPosition);
            this.level.sendBlockUpdated(this.worldPosition, state, state, 3);
        }
    }

    public boolean isPowered() {
        return this.powerLevel > 0;
    }

    public List<ShieldFilter<?>> getFilters() {
        return ((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)).filters();
    }

    public boolean isBlockLight() {
        return ((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)).blockLight();
    }

    public void setBlockLight(boolean blockLight) {
        ShieldData data = ((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)).withBlockLight(blockLight);
        this.setData((Supplier)ShieldModule.SHIELD_DATA, data);
        this.updateTimeout = 10;
    }

    public int getShieldColor() {
        return ((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)).shieldColor();
    }

    public void setShieldColor(int shieldColor) {
        ShieldData data = ((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)).withShieldColor(shieldColor);
        this.setData((Supplier)ShieldModule.SHIELD_DATA, data);
        this.updateTimeout = 10;
    }

    private void delFilter(int selected) {
        ShieldData data = ((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)).removeFilter(selected);
        this.setData((Supplier)ShieldModule.SHIELD_DATA, data);
        this.updateTimeout = 10;
    }

    private void upFilter(int selected) {
        ShieldData data = ((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)).moveSelectedFilterUp(selected);
        this.setData((Supplier)ShieldModule.SHIELD_DATA, data);
    }

    private void downFilter(int selected) {
        ShieldData data = ((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)).moveSelectedFilterDown(selected);
        this.setData((Supplier)ShieldModule.SHIELD_DATA, data);
    }

    private void addFilter(int action, String type, String player, int selected) {
        ShieldFilter<?> filter = AbstractShieldFilter.createFilter(type);
        filter.setAction(action);
        if (filter instanceof PlayerFilter) {
            ((PlayerFilter)filter).setName(player);
        }
        ShieldData data = (ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA);
        data = selected == -1 ? data.addFilter(filter) : data.addFilter(filter, selected);
        this.setData((Supplier)ShieldModule.SHIELD_DATA, data);
        this.updateTimeout = 10;
    }

    public DamageTypeMode getDamageMode() {
        return ((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)).damageMode();
    }

    public void setDamageMode(DamageTypeMode damageMode) {
        ShieldData data = ((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)).withDamageMode(damageMode);
        this.setData((Supplier)ShieldModule.SHIELD_DATA, data);
    }

    public ShieldRenderingMode getShieldRenderingMode() {
        return ((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)).renderMode();
    }

    public void setShieldRenderingMode(ShieldRenderingMode shieldRenderingMode) {
        ShieldData data = ((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)).withRenderMode(shieldRenderingMode);
        this.setData((Supplier)ShieldModule.SHIELD_DATA, data);
        this.updateTimeout = 10;
    }

    public ShieldTexture getShieldTexture() {
        return ((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)).shieldTexture();
    }

    public void setShieldTexture(ShieldTexture shieldTexture) {
        ShieldData data = ((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)).withShieldTexture(shieldTexture);
        this.setData((Supplier)ShieldModule.SHIELD_DATA, data);
        this.updateTimeout = 10;
    }

    @Nonnull
    private BlockState getStateFromItem(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            ServerPlayer player = this.fakePlayer.get();
            player.setItemInHand(InteractionHand.MAIN_HAND, stack);
            BlockHitResult result = new BlockHitResult(new Vec3(0.5, 0.0, 0.5), Direction.UP, this.worldPosition, false);
            BlockPlaceContext context = new BlockPlaceContext(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, result));
            BlockState stateForPlacement = blockItem.getBlock().getStateForPlacement(context);
            return stateForPlacement == null ? blockItem.getBlock().defaultBlockState() : stateForPlacement;
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Nullable
    private BlockState calculateMimic() {
        if (!ShieldRenderingMode.MIMIC.equals((Object)this.getShieldRenderingMode())) {
            return null;
        }
        ItemStack stackInSlot = this.items.getStackInSlot(0);
        if (stackInSlot.isEmpty()) {
            return null;
        }
        return this.getStateFromItem(stackInSlot);
    }

    private BlockState calculateShieldBlock(BlockState mimic, boolean blockLight) {
        if (!this.shieldActive || this.powerTimeout > 0) {
            return Blocks.AIR.defaultBlockState();
        }
        ShieldRenderingMode render = this.getShieldRenderingMode();
        if (!((Boolean)ShieldConfiguration.allowInvisibleShield.get()).booleanValue() && ShieldRenderingMode.INVISIBLE.equals((Object)render)) {
            render = ShieldRenderingMode.SOLID;
        }
        if (mimic != null) {
            render = ShieldRenderingMode.MIMIC;
        }
        BlockState shielding = this.getShieldingBlock(render, mimic).defaultBlockState();
        shielding = (BlockState)shielding.setValue((Property)ShieldingBlock.FLAG_OPAQUE, (Comparable)Boolean.valueOf(!blockLight));
        shielding = (BlockState)shielding.setValue(ShieldingBlock.RENDER_MODE, (Comparable)((Object)render));
        shielding = this.calculateShieldCollisionData(shielding);
        shielding = this.calculateDamageBits(shielding);
        return shielding;
    }

    private Block getShieldingBlock(ShieldRenderingMode render, BlockState mimic) {
        if (mimic == null) {
            if (render.isTranslucent()) {
                return (Block)ShieldModule.SHIELDING_TRANSLUCENT.get();
            }
            return (Block)ShieldModule.SHIELDING_SOLID.get();
        }
        return (Block)ShieldModule.SHIELDING_SOLID.get();
    }

    private BlockState calculateDamageBits(BlockState shielding) {
        for (ShieldFilter<?> filter : this.getFilters()) {
            if ((filter.getAction() & 2) == 0) continue;
            if ("item".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.setValue((Property)ShieldingBlock.DAMAGE_ITEMS, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("animal".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.setValue((Property)ShieldingBlock.DAMAGE_PASSIVE, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("hostile".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.setValue((Property)ShieldingBlock.DAMAGE_HOSTILE, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("player".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.setValue((Property)ShieldingBlock.DAMAGE_PLAYERS, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (!"default".equals(filter.getFilterName())) continue;
            shielding = (BlockState)((BlockState)((BlockState)((BlockState)shielding.setValue((Property)ShieldingBlock.DAMAGE_ITEMS, (Comparable)Boolean.valueOf(true))).setValue((Property)ShieldingBlock.DAMAGE_PASSIVE, (Comparable)Boolean.valueOf(true))).setValue((Property)ShieldingBlock.DAMAGE_HOSTILE, (Comparable)Boolean.valueOf(true))).setValue((Property)ShieldingBlock.DAMAGE_PLAYERS, (Comparable)Boolean.valueOf(true));
        }
        return shielding;
    }

    private BlockState calculateShieldCollisionData(BlockState shielding) {
        for (ShieldFilter<?> filter : this.getFilters()) {
            if ((filter.getAction() & 1) == 0) continue;
            if ("item".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.setValue((Property)ShieldingBlock.BLOCKED_ITEMS, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("animal".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.setValue((Property)ShieldingBlock.BLOCKED_PASSIVE, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("hostile".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.setValue((Property)ShieldingBlock.BLOCKED_HOSTILE, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if ("player".equals(filter.getFilterName())) {
                shielding = (BlockState)shielding.setValue((Property)ShieldingBlock.BLOCKED_PLAYERS, (Comparable)Boolean.valueOf(true));
                continue;
            }
            if (!"default".equals(filter.getFilterName())) continue;
            shielding = (BlockState)((BlockState)((BlockState)((BlockState)shielding.setValue((Property)ShieldingBlock.BLOCKED_ITEMS, (Comparable)Boolean.valueOf(true))).setValue((Property)ShieldingBlock.BLOCKED_PASSIVE, (Comparable)Boolean.valueOf(true))).setValue((Property)ShieldingBlock.BLOCKED_HOSTILE, (Comparable)Boolean.valueOf(true))).setValue((Property)ShieldingBlock.BLOCKED_PLAYERS, (Comparable)Boolean.valueOf(true));
        }
        return shielding;
    }

    private int calculateRfPerTick() {
        if (!this.shieldActive) {
            return 0;
        }
        int s = this.shieldBlocks.size() - 50;
        if (s < 10) {
            s = 10;
        }
        int rf = (Integer)ShieldConfiguration.rfBase.get() * s / 10;
        if (ShieldRenderingMode.SHIELD.equals((Object)this.getShieldRenderingMode())) {
            rf += (Integer)ShieldConfiguration.rfShield.get() * s / 10;
        } else if (ShieldRenderingMode.MIMIC.equals((Object)this.getShieldRenderingMode())) {
            rf += (Integer)ShieldConfiguration.rfCamo.get() * s / 10;
        }
        return rf;
    }

    public boolean isShieldComposed() {
        return this.shieldComposed;
    }

    public boolean isShieldActive() {
        return this.shieldActive;
    }

    public void applyDamageToEntity(Entity entity) {
        DamageSource source;
        int rf;
        if (DamageTypeMode.DAMAGETYPE_GENERIC.equals((Object)this.getDamageMode())) {
            rf = (Integer)ShieldConfiguration.rfDamage.get();
            source = DamageTools.getGenericDamageSource((Entity)entity);
        } else {
            rf = (Integer)ShieldConfiguration.rfDamagePlayer.get();
            ServerPlayer killer = this.fakePlayer.get();
            killer.setPos((double)this.worldPosition.getX(), (double)this.worldPosition.getY(), (double)this.worldPosition.getZ());
            ItemStack shards = this.items.getStackInSlot(2);
            if (!shards.isEmpty() && shards.getCount() >= (Integer)ShieldConfiguration.shardsPerLootingKill.get()) {
                this.items.extractItem(2, ((Integer)ShieldConfiguration.shardsPerLootingKill.get()).intValue(), false);
                if (this.lootingSword.isEmpty()) {
                    this.lootingSword = ShieldProjectorTileEntity.createEnchantedItem(entity.level(), Items.DIAMOND_SWORD, (ResourceKey<Enchantment>)Enchantments.LOOTING, (Integer)ShieldConfiguration.lootingKillBonus.get());
                }
                this.lootingSword.setDamageValue(0);
                killer.setItemInHand(InteractionHand.MAIN_HAND, this.lootingSword);
            } else {
                killer.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
            }
            source = DamageTools.getPlayerAttackDamageSource((Entity)killer, (Player)killer);
        }
        float factor = this.infusable.getInfusedFactor();
        rf = (int)((float)rf * this.costFactor * (4.0f - factor) / 4.0f);
        if (this.energyStorage.getEnergyStored() < rf) {
            return;
        }
        this.energyStorage.consumeEnergy((long)rf);
        float damage = (float)((Double)ShieldConfiguration.damage.get()).doubleValue();
        damage *= this.damageFactor;
        entity.hurt(source, damage *= 1.0f + factor / 2.0f);
    }

    public static ItemStack createEnchantedItem(Level level, Item item, ResourceKey<Enchantment> effectId, int amount) {
        ItemStack stack = new ItemStack((ItemLike)item);
        ItemEnchantments.Mutable enchant = new ItemEnchantments.Mutable(ItemEnchantments.EMPTY);
        Optional holder = level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolder(effectId);
        enchant.set((Holder)holder.get(), amount);
        EnchantmentHelper.setEnchantments((ItemStack)stack, (ItemEnchantments)enchant.toImmutable());
        return stack;
    }

    protected void tickServer() {
        boolean newShieldActive;
        if (this.level == null) {
            return;
        }
        if (!this.shieldComposed) {
            return;
        }
        if (this.updateTimeout > 0) {
            --this.updateTimeout;
            if (this.updateTimeout <= 0) {
                this.updateShield();
            }
        }
        boolean checkPower = false;
        if (this.powerTimeout > 0) {
            --this.powerTimeout;
            this.setChanged();
            if (this.powerTimeout > 0) {
                return;
            }
            checkPower = true;
        }
        boolean needsUpdate = false;
        int rf = this.getRfPerTick();
        if (rf > 0) {
            if (this.energyStorage.getEnergyStored() < rf) {
                this.powerTimeout = 100;
                needsUpdate = true;
            } else {
                if (checkPower) {
                    needsUpdate = true;
                }
                this.energyStorage.consumeEnergy((long)rf);
            }
        }
        if ((newShieldActive = this.isMachineEnabled()) != this.shieldActive) {
            needsUpdate = true;
            this.shieldActive = newShieldActive;
        }
        if (needsUpdate) {
            this.updateShield();
            this.markDirtyClient();
        }
    }

    public void clientIsReady() {
        this.updateShield();
    }

    private int getRfPerTick() {
        int rf = this.calculateRfPerTick();
        float factor = this.infusable.getInfusedFactor();
        rf = (int)((float)rf * (2.0f - factor) / 2.0f);
        return rf;
    }

    public void composeDecomposeShield(boolean ctrl) {
        if (this.shieldComposed) {
            this.decomposeShield();
        } else {
            this.composeShield(ctrl);
        }
    }

    public void composeShield(boolean ctrl) {
        HashMap<BlockPos, BlockState> coordinates;
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        if (this.isShapedShield()) {
            this.templateState = Blocks.AIR.defaultBlockState();
            ItemStack shapeItem = this.items.getStackInSlot(1);
            Shape shape = ShapeCardItem.getShape(shapeItem);
            boolean solid = ShapeCardItem.isSolid(shapeItem);
            BlockPos dimension = ShapeCardItem.getClampedDimension(shapeItem, (Integer)ShieldConfiguration.maxShieldDimension.get());
            BlockPos offset = ShapeCardItem.getClampedOffset(shapeItem, (Integer)ShieldConfiguration.maxShieldOffset.get());
            HashMap<BlockPos, BlockState> col = new HashMap<BlockPos, BlockState>();
            ShapeCardItem.composeFormula(shapeItem, shape.getFormulaFactory().get(), this.getLevel(), this.getBlockPos(), dimension, offset, col, this.supportedBlocks, solid, false, null);
            coordinates = col;
        } else {
            if (!this.findTemplateState()) {
                return;
            }
            HashMap<BlockPos, BlockState> col = new HashMap<BlockPos, BlockState>();
            this.findTemplateBlocks(col, this.templateState, ctrl, this.getBlockPos());
            coordinates = col;
        }
        int xCoord = this.getBlockPos().getX();
        int yCoord = this.getBlockPos().getY();
        int zCoord = this.getBlockPos().getZ();
        for (Map.Entry entry : coordinates.entrySet()) {
            BlockPos c = (BlockPos)entry.getKey();
            BlockState state = (BlockState)entry.getValue();
            int st = -1;
            if (state != null) {
                for (int i = 0; i < this.blockStateTable.size(); ++i) {
                    if (!state.equals(this.blockStateTable.get(i))) continue;
                    st = i;
                    break;
                }
                if (st == -1) {
                    st = this.blockStateTable.size();
                    this.blockStateTable.add(state);
                }
            }
            this.shieldBlocks.add(new RelCoordinateShield(c.getX() - xCoord, c.getY() - yCoord, c.getZ() - zCoord, st));
            this.getLevel().setBlockAndUpdate(c, Blocks.AIR.defaultBlockState());
        }
        this.shieldComposed = true;
        this.updateShield();
    }

    private boolean isShapedShield() {
        return !this.items.getStackInSlot(1).isEmpty();
    }

    private boolean findTemplateState() {
        for (Direction dir : OrientationTools.DIRECTION_VALUES) {
            BlockState state;
            BlockPos p = this.getBlockPos().relative(dir);
            if (p.getY() < this.level.getMinBuildHeight() || p.getY() >= this.level.getMaxBuildHeight() || !((state = this.getLevel().getBlockState(p)).getBlock() instanceof ShieldTemplateBlock)) continue;
            this.templateState = state;
            return true;
        }
        return false;
    }

    public void selectBlock(Player player, BlockPos pos) {
        if (!this.shieldComposed) {
            Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.YELLOW) + "Shield is not composed. Nothing happens!"));
            return;
        }
        float squaredDistance = (float)this.getBlockPos().distSqr((Vec3i)pos);
        if (squaredDistance > (float)((Integer)ShieldConfiguration.maxDisjointShieldDistance.get() * (Integer)ShieldConfiguration.maxDisjointShieldDistance.get())) {
            Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.YELLOW) + "This template is too far to connect to the shield!"));
            return;
        }
        int xCoord = this.getBlockPos().getX();
        int yCoord = this.getBlockPos().getY();
        int zCoord = this.getBlockPos().getZ();
        Block origBlock = this.getLevel().getBlockState(pos).getBlock();
        if (origBlock instanceof ShieldTemplateBlock) {
            if (this.isShapedShield()) {
                Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.YELLOW) + "You cannot add template blocks to a shaped shield (using a shape card)!"));
                return;
            }
            HashMap<BlockPos, BlockState> templateBlocks = new HashMap<BlockPos, BlockState>();
            BlockState state = this.getLevel().getBlockState(pos);
            templateBlocks.put(pos, null);
            this.findTemplateBlocks(templateBlocks, state, false, pos);
            BlockState mimic = this.calculateMimic();
            BlockState shielding = this.calculateShieldBlock(mimic, this.isBlockLight());
            for (Map.Entry entry : templateBlocks.entrySet()) {
                BlockPos templateBlock = (BlockPos)entry.getKey();
                RelCoordinateShield relc = new RelCoordinateShield(templateBlock.getX() - xCoord, templateBlock.getY() - yCoord, templateBlock.getZ() - zCoord, -1);
                this.shieldBlocks.add(relc);
                this.updateShieldBlock(mimic, shielding, relc);
            }
        } else if (origBlock instanceof ShieldingBlock) {
            int dx = pos.getX() - xCoord;
            int dy = pos.getY() - yCoord;
            int dz = pos.getZ() - zCoord;
            int idx = IntStream.range(0, this.shieldBlocks.size()).filter(i -> this.shieldBlocks.get(i).matches(dx, dy, dz)).findFirst().orElse(-1);
            if (idx != -1) {
                this.shieldBlocks.remove(idx);
            }
            this.getLevel().setBlock(pos, this.templateState, 2);
        } else {
            Logging.message((Player)player, (String)(String.valueOf(ChatFormatting.YELLOW) + "The selected shield can't do anything with this block!"));
            return;
        }
        this.setChanged();
    }

    private void updateShield() {
        BlockState mimic = this.calculateMimic();
        BlockState shielding = this.calculateShieldBlock(mimic, this.isBlockLight());
        int xCoord = this.getBlockPos().getX();
        int yCoord = this.getBlockPos().getY();
        int zCoord = this.getBlockPos().getZ();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (RelCoordinateShield c : this.shieldBlocks) {
            if (Blocks.AIR.equals(shielding.getBlock())) {
                pos.set(xCoord + c.dx(), yCoord + c.dy(), zCoord + c.dz());
                BlockState oldState = this.getLevel().getBlockState((BlockPos)pos);
                if (!(oldState.getBlock() instanceof ShieldingBlock)) continue;
                this.getLevel().setBlockAndUpdate((BlockPos)pos, Blocks.AIR.defaultBlockState());
                continue;
            }
            this.updateShieldBlock(mimic, shielding, c);
        }
        this.setChanged();
    }

    private void updateShieldBlock(BlockState mimic, BlockState shielding, RelCoordinateShield c) {
        int xCoord = this.getBlockPos().getX();
        int yCoord = this.getBlockPos().getY();
        int zCoord = this.getBlockPos().getZ();
        BlockPos pp = new BlockPos(xCoord + c.dx(), yCoord + c.dy(), zCoord + c.dz());
        BlockState oldState = this.getLevel().getBlockState(pp);
        if (!(oldState.getBlock() instanceof ShieldingBlock || oldState.canBeReplaced() || oldState.getBlock() instanceof ShieldTemplateBlock)) {
            return;
        }
        this.level.setBlockAndUpdate(pp, Blocks.AIR.defaultBlockState());
        this.level.setBlock(pp, shielding, 1);
        BlockEntity te = this.getLevel().getBlockEntity(pp);
        if (te instanceof ShieldingTileEntity) {
            ShieldingTileEntity shieldingTE = (ShieldingTileEntity)te;
            if (c.state() != -1) {
                BlockState state = this.blockStateTable.get(c.state());
                shieldingTE.setMimic(state);
            } else {
                shieldingTE.setMimic(mimic);
            }
            shieldingTE.setShieldProjector(this.worldPosition);
        }
    }

    public void decomposeShield() {
        int xCoord = this.getBlockPos().getX();
        int yCoord = this.getBlockPos().getY();
        int zCoord = this.getBlockPos().getZ();
        BlockPos.MutableBlockPos pp = new BlockPos.MutableBlockPos();
        for (RelCoordinateShield c : this.shieldBlocks) {
            int cx = xCoord + c.dx();
            int cy = yCoord + c.dy();
            int cz = zCoord + c.dz();
            pp.set(cx, cy, cz);
            Block block = this.getLevel().getBlockState((BlockPos)pp).getBlock();
            if (this.getLevel().isEmptyBlock((BlockPos)pp) || block instanceof ShieldingBlock) {
                this.getLevel().setBlock(new BlockPos((Vec3i)pp), this.templateState, 2);
                continue;
            }
            if (this.templateState.isAir() || this.isShapedShield()) continue;
            Containers.dropItemStack((Level)this.getLevel(), (double)cx, (double)cy, (double)cz, (ItemStack)this.templateState.getBlock().getCloneItemStack((LevelReader)this.getLevel(), new BlockPos(cx, cy, cz), this.templateState));
        }
        this.shieldComposed = false;
        this.shieldActive = false;
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        this.setChanged();
    }

    private void findTemplateBlocks(Map<BlockPos, BlockState> coordinateSet, BlockState templateState, boolean ctrl, BlockPos start) {
        ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
        if (ctrl) {
            this.addToTodoCornered(coordinateSet, todo, start, templateState);
            while (!todo.isEmpty() && coordinateSet.size() < this.supportedBlocks) {
                BlockPos coordinate = (BlockPos)todo.pollFirst();
                coordinateSet.put(coordinate, null);
                this.addToTodoCornered(coordinateSet, todo, coordinate, templateState);
            }
        } else {
            this.addToTodoStraight(coordinateSet, todo, start, templateState);
            while (!todo.isEmpty() && coordinateSet.size() < this.supportedBlocks) {
                BlockPos coordinate = (BlockPos)todo.pollFirst();
                coordinateSet.put(coordinate, null);
                this.addToTodoStraight(coordinateSet, todo, coordinate, templateState);
            }
        }
    }

    private void addToTodoStraight(Map<BlockPos, BlockState> coordinateSet, Deque<BlockPos> todo, BlockPos coordinate, BlockState templateState) {
        for (Direction dir : OrientationTools.DIRECTION_VALUES) {
            BlockState state;
            BlockPos pp = coordinate.relative(dir);
            if (pp.getY() < this.level.getMinBuildHeight() || pp.getY() >= this.level.getMaxBuildHeight() || coordinateSet.containsKey(pp) || (state = this.getLevel().getBlockState(pp)) != templateState || todo.contains(pp)) continue;
            todo.addLast(pp);
        }
    }

    private void addToTodoCornered(Map<BlockPos, BlockState> coordinateSet, Deque<BlockPos> todo, BlockPos coordinate, BlockState templateState) {
        int x = coordinate.getX();
        int y = coordinate.getY();
        int z = coordinate.getZ();
        BlockPos.MutableBlockPos c = new BlockPos.MutableBlockPos();
        for (int xx = x - 1; xx <= x + 1; ++xx) {
            for (int yy = y - 1; yy <= y + 1; ++yy) {
                for (int zz = z - 1; zz <= z + 1; ++zz) {
                    BlockState state;
                    if (xx == x && yy == y && zz == z || yy < this.getLevel().getMinBuildHeight() || yy >= this.getLevel().getMaxBuildHeight()) continue;
                    c.set(xx, yy, zz);
                    if (coordinateSet.containsKey(c) || (state = this.getLevel().getBlockState((BlockPos)c)) != templateState || todo.contains(c)) continue;
                    todo.addLast(c.immutable());
                }
            }
        }
    }

    private static short bytesToShort(byte b1, byte b2) {
        short s1 = (short)(b1 & 0xFF);
        short s2 = (short)(b2 & 0xFF);
        return (short)(s1 * 256 + s2);
    }

    private static byte shortToByte1(short s) {
        return (byte)((s & 0xFF00) >> 8);
    }

    private static byte shortToByte2(short s) {
        return (byte)(s & 0xFF);
    }

    public void loadClientDataFromNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        this.powerLevel = tagCompound.getByte("powered");
        this.shieldComposed = tagCompound.getBoolean("composed");
        this.shieldActive = tagCompound.getBoolean("active");
        this.powerTimeout = tagCompound.getInt("powerTimeout");
        if (tagCompound.contains("templateColor")) {
            int templateColor = tagCompound.getInt("templateColor");
            ShieldTemplateBlock.TemplateColor color = ShieldTemplateBlock.TemplateColor.values()[templateColor];
            switch (color) {
                case BLUE: {
                    this.templateState = ((ShieldTemplateBlock)((Object)ShieldModule.TEMPLATE_BLUE.get())).defaultBlockState();
                    break;
                }
                case RED: {
                    this.templateState = ((ShieldTemplateBlock)((Object)ShieldModule.TEMPLATE_RED.get())).defaultBlockState();
                    break;
                }
                case GREEN: {
                    this.templateState = ((ShieldTemplateBlock)((Object)ShieldModule.TEMPLATE_GREEN.get())).defaultBlockState();
                    break;
                }
                case YELLOW: {
                    this.templateState = ((ShieldTemplateBlock)((Object)ShieldModule.TEMPLATE_YELLOW.get())).defaultBlockState();
                }
            }
        } else {
            this.templateState = Blocks.AIR.defaultBlockState();
        }
        ShieldData.CODEC.decode((DynamicOps)NbtOps.INSTANCE, (Object)tagCompound.get("data")).result().ifPresent(data -> this.setData((Supplier)ShieldModule.SHIELD_DATA, (ShieldData)data.getFirst()));
        this.renderData = null;
        RFToolsBuilderMessages.sendToServer(PacketNotifyServerClientReady.create(this.worldPosition));
    }

    public void saveClientDataToNBT(CompoundTag tagCompound, HolderLookup.Provider provider) {
        tagCompound.putByte("powered", this.powerLevel);
        tagCompound.putBoolean("composed", this.shieldComposed);
        tagCompound.putBoolean("active", this.shieldActive);
        tagCompound.putInt("powerTimeout", this.powerTimeout);
        if (!this.templateState.isAir()) {
            tagCompound.putInt("templateColor", ((ShieldTemplateBlock)this.templateState.getBlock()).getColor().ordinal());
        }
        ShieldData.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA))).result().ifPresent(data -> tagCompound.put("data", data));
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        this.energyStorage.load(tag, "energy", provider);
        this.items.load(tag, "items", provider);
        this.infusable.load(tag, "infusable");
        this.shieldComposed = tag.getBoolean("composed");
        this.shieldActive = tag.getBoolean("active");
        this.powerTimeout = tag.getInt("powerTimeout");
        if (!this.isShapedShield()) {
            if (tag.contains("templateColor")) {
                int templateColor = tag.getInt("templateColor");
                ShieldTemplateBlock.TemplateColor color = ShieldTemplateBlock.TemplateColor.values()[templateColor];
                switch (color) {
                    case BLUE: {
                        this.templateState = ((ShieldTemplateBlock)((Object)ShieldModule.TEMPLATE_BLUE.get())).defaultBlockState();
                        break;
                    }
                    case RED: {
                        this.templateState = ((ShieldTemplateBlock)((Object)ShieldModule.TEMPLATE_RED.get())).defaultBlockState();
                        break;
                    }
                    case GREEN: {
                        this.templateState = ((ShieldTemplateBlock)((Object)ShieldModule.TEMPLATE_GREEN.get())).defaultBlockState();
                        break;
                    }
                    case YELLOW: {
                        this.templateState = ((ShieldTemplateBlock)((Object)ShieldModule.TEMPLATE_YELLOW.get())).defaultBlockState();
                    }
                }
            } else {
                this.templateState = Blocks.AIR.defaultBlockState();
            }
        } else {
            this.templateState = Blocks.AIR.defaultBlockState();
        }
        this.shieldBlocks.clear();
        this.blockStateTable.clear();
        if (tag.contains("relcoordsNew")) {
            byte[] byteArray = tag.getByteArray("relcoordsNew");
            int j = 0;
            for (int i = 0; i < byteArray.length / 8; ++i) {
                short dx = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 0], byteArray[j + 1]);
                short dy = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 2], byteArray[j + 3]);
                short dz = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 4], byteArray[j + 5]);
                short st = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 6], byteArray[j + 7]);
                j += 8;
                this.shieldBlocks.add(new RelCoordinateShield(dx, dy, dz, st));
            }
            ListTag list = tag.getList("gstates", 10);
            for (Tag inbt : list) {
                CompoundTag tc = (CompoundTag)inbt;
                String b = tc.getString("b");
                int m = tc.getInt("m");
                Block block = Tools.getBlock((ResourceLocation)ResourceLocation.parse((String)b));
                if (block == null) {
                    block = Blocks.STONE;
                    m = 0;
                }
                BlockState state = block.defaultBlockState();
                this.blockStateTable.add(state);
            }
        } else {
            byte[] byteArray = tag.getByteArray("relcoords");
            int j = 0;
            for (int i = 0; i < byteArray.length / 6; ++i) {
                short dx = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 0], byteArray[j + 1]);
                short dy = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 2], byteArray[j + 3]);
                short dz = ShieldProjectorTileEntity.bytesToShort(byteArray[j + 4], byteArray[j + 5]);
                j += 6;
                this.shieldBlocks.add(new RelCoordinateShield(dx, dy, dz, -1));
            }
        }
    }

    protected void applyImplicitComponents(BlockEntity.DataComponentInput input) {
        super.applyImplicitComponents(input);
        this.energyStorage.applyImplicitComponents((ItemEnergy)input.get((Supplier)Registration.ITEM_ENERGY));
        this.items.applyImplicitComponents((ItemInventory)input.get((Supplier)Registration.ITEM_INVENTORY));
        this.infusable.applyImplicitComponents((ItemInfusable)input.get((Supplier)Registration.ITEM_INFUSABLE));
        ShieldData shieldData = (ShieldData)input.get(ShieldModule.ITEM_SHIELD_DATA);
        if (shieldData != null) {
            this.setData((Supplier)ShieldModule.SHIELD_DATA, shieldData);
        }
    }

    protected void collectImplicitComponents(DataComponentMap.Builder builder) {
        super.collectImplicitComponents(builder);
        this.energyStorage.collectImplicitComponents(builder);
        this.items.collectImplicitComponents(builder);
        this.infusable.collectImplicitComponents(builder);
        builder.set(ShieldModule.ITEM_SHIELD_DATA, (Object)((ShieldData)this.getData((Supplier)ShieldModule.SHIELD_DATA)));
    }

    public void saveAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.energyStorage.save(tag, "energy", provider);
        this.items.save(tag, "items", provider);
        this.infusable.save(tag, "infusable");
        tag.putBoolean("composed", this.shieldComposed);
        tag.putBoolean("active", this.shieldActive);
        tag.putInt("powerTimeout", this.powerTimeout);
        if (!this.templateState.isAir()) {
            tag.putInt("templateColor", ((ShieldTemplateBlock)this.templateState.getBlock()).getColor().ordinal());
        }
        byte[] blocks = new byte[this.shieldBlocks.size() * 8];
        int j = 0;
        for (RelCoordinateShield c : this.shieldBlocks) {
            blocks[j + 0] = ShieldProjectorTileEntity.shortToByte1((short)c.dx());
            blocks[j + 1] = ShieldProjectorTileEntity.shortToByte2((short)c.dx());
            blocks[j + 2] = ShieldProjectorTileEntity.shortToByte1((short)c.dy());
            blocks[j + 3] = ShieldProjectorTileEntity.shortToByte2((short)c.dy());
            blocks[j + 4] = ShieldProjectorTileEntity.shortToByte1((short)c.dz());
            blocks[j + 5] = ShieldProjectorTileEntity.shortToByte2((short)c.dz());
            blocks[j + 6] = ShieldProjectorTileEntity.shortToByte1((short)c.state());
            blocks[j + 7] = ShieldProjectorTileEntity.shortToByte2((short)c.state());
            j += 8;
        }
        tag.putByteArray("relcoordsNew", blocks);
        ListTag list = new ListTag();
        for (BlockState state : this.blockStateTable) {
            CompoundTag tc = new CompoundTag();
            tc.putString("b", Tools.getId((BlockState)state).toString());
            list.add((Object)tc);
        }
        tag.put("gstates", (Tag)list);
    }

    @Nonnull
    private IPowerInformation createPowerInfo() {
        return new IPowerInformation(){

            public long getEnergyDiffPerTick() {
                return ShieldProjectorTileEntity.this.shieldActive ? (long)ShieldProjectorTileEntity.this.getRfPerTick() : 0L;
            }

            public String getEnergyUnitName() {
                return "RF";
            }

            public boolean isMachineActive() {
                return ShieldProjectorTileEntity.this.shieldActive;
            }

            public boolean isMachineRunning() {
                return ShieldProjectorTileEntity.this.shieldActive;
            }

            public String getMachineStatus() {
                return ShieldProjectorTileEntity.this.shieldActive ? "active" : "idle";
            }
        };
    }
}

