/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuardianBeamParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    private GuardianBeamParticle(ClientLevel world, double x, double y, double z, double power, double my, double mz, SpriteSet animatedSprite) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.sprites = animatedSprite;
        this.xd = 0.0;
        this.yd = 0.0;
        this.zd = 0.0;
        float secondary = Math.max(0.0f, (float)power - 1.0f);
        this.rCol = 1.0f;
        this.gCol = 0.0f;
        this.bCol = 0.0f;
        if (secondary > 0.0f) {
            this.rCol = 1.0f - secondary;
            this.gCol = secondary;
            this.bCol = secondary;
        }
        this.lifetime = 2 + world.random.nextInt(2);
        this.hasPhysics = false;
        this.setSpriteFromAge(animatedSprite);
        this.scale((float)Math.min(power, 1.0) * 4.0f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }

    public float getQuadSize(float partialTicks) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + partialTicks) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.age++ >= this.lifetime) {
            this.remove();
        } else {
            double d0;
            this.setSpriteFromAge(this.sprites);
            this.move(this.xd, this.yd, this.zd);
            this.xd *= (double)0.96f;
            this.yd *= (double)0.96f;
            this.zd *= (double)0.96f;
            Player playerentity = this.level.getNearestPlayer(this.x, this.y, this.z, 2.0, false);
            if (playerentity != null && this.y > (d0 = playerentity.getY())) {
                this.y += (d0 - this.y) * 0.2;
                this.yd += (playerentity.getDeltaMovement().y - this.yd) * 0.2;
                this.setPos(this.x, this.y, this.z);
            }
            if (this.onGround) {
                this.xd *= (double)0.7f;
                this.zd *= (double)0.7f;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Factory(SpriteSet p_i50630_1_) {
            this.sprites = p_i50630_1_;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel world, double x, double y, double z, double power, double p_199234_11_, double p_199234_13_) {
            return new GuardianBeamParticle(world, x, y, z, power, p_199234_11_, p_199234_13_, this.sprites);
        }
    }
}

