/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.vec.Matrix4;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.draconicevolution.client.render.item.ToolRenderBase;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class RenderModularHoe
extends ToolRenderBase {
    private final ToolRenderBase.ToolPart basePart;
    private final ToolRenderBase.ToolPart materialPart;
    private final ToolRenderBase.ToolPart gemPart;
    private final ToolRenderBase.ToolPart tracePart;

    public RenderModularHoe(TechLevel techLevel) {
        super(techLevel, "hoe");
        Map model = new OBJParser(ResourceLocation.fromNamespaceAndPath((String)"draconicevolution", (String)"models/item/equipment/hoe.obj")).ignoreMtl().parse();
        this.basePart = this.basePart(((CCModel)model.get("handle")).backfacedCopy());
        this.materialPart = this.materialPart(((CCModel)model.get("head")).backfacedCopy());
        this.gemPart = this.gemPart(((CCModel)model.get("gem")).backfacedCopy());
        this.tracePart = this.tracePart(((CCModel)model.get("trace")).backfacedCopy());
    }

    @Override
    public void renderTool(CCRenderState ccrs, ItemStack stack, ItemDisplayContext context, Matrix4 mat, MultiBufferSource buffers, boolean gui) {
        this.transform(mat, 0.28, 0.28, 0.5, 1.25);
        this.basePart.render(context, buffers, mat);
        this.materialPart.render(context, buffers, mat);
        this.tracePart.render(context, buffers, mat);
        this.gemPart.render(context, buffers, mat);
    }

    public static class HOE_CHAOTIC
    extends RenderModularHoe {
        public HOE_CHAOTIC() {
            super(TechLevel.CHAOTIC);
        }
    }

    public static class HOE_DRACONIC
    extends RenderModularHoe {
        public HOE_DRACONIC() {
            super(TechLevel.DRACONIC);
        }
    }

    public static class HOE_WYVERN
    extends RenderModularHoe {
        public HOE_WYVERN() {
            super(TechLevel.WYVERN);
        }
    }
}

