/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks;

import com.brandon3055.brandonscore.blocks.EntityBlockBCore;
import com.brandon3055.brandonscore.blocks.TileBCore;
import com.brandon3055.brandonscore.lib.CustomTabHandling;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.draconicevolution.blocks.tileentity.TileDislocatorReceptacle;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePortal;
import com.brandon3055.draconicevolution.init.DEContent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class Portal
extends EntityBlockBCore
implements CustomTabHandling {
    public static final EnumProperty<Direction.Axis> AXIS = EnumProperty.create((String)"axis", Direction.Axis.class);
    public static final BooleanProperty DRAW_UP = BooleanProperty.create((String)"drawup");
    public static final BooleanProperty DRAW_DOWN = BooleanProperty.create((String)"drawdown");
    public static final BooleanProperty DRAW_EAST = BooleanProperty.create((String)"draweast");
    public static final BooleanProperty DRAW_WEST = BooleanProperty.create((String)"drawwest");
    public static final BooleanProperty VISIBLE = BooleanProperty.create((String)"visible");

    public Portal(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue((Property)DRAW_UP, (Comparable)Boolean.valueOf(true))).setValue((Property)DRAW_DOWN, (Comparable)Boolean.valueOf(true))).setValue((Property)DRAW_EAST, (Comparable)Boolean.valueOf(true))).setValue((Property)DRAW_WEST, (Comparable)Boolean.valueOf(true))).setValue((Property)VISIBLE, (Comparable)Boolean.valueOf(true)));
        this.setBlockEntity(() -> DEContent.TILE_PORTAL.get(), false);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> entityType) {
        if (level.isClientSide() && entityType == DEContent.TILE_PORTAL.get()) {
            return (e, e2, e3, tile) -> ((TileBCore)tile).tick();
        }
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, DRAW_UP, DRAW_DOWN, DRAW_EAST, DRAW_WEST, VISIBLE});
    }

    public VoxelShape getShape(BlockState p_220053_1_, BlockGetter p_220053_2_, BlockPos p_220053_3_, CollisionContext p_220053_4_) {
        return Shapes.empty();
    }

    public boolean canSurvive(BlockState state, LevelReader world, BlockPos pos) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (!(tile instanceof TilePortal)) {
            return false;
        }
        TileDislocatorReceptacle controller = ((TilePortal)tile).getController();
        if (controller != null && controller.ignitionStage.get() == 2) {
            return true;
        }
        if (!((TilePortal)tile).isPortalActive()) {
            return false;
        }
        for (Direction dir : FacingUtils.getFacingsAroundAxis((Direction.Axis)((Direction.Axis)state.getValue(AXIS)))) {
            if (Portal.isFrame(world, pos.relative(dir)) || Portal.isPortal(world, pos.relative(dir))) continue;
            return false;
        }
        return true;
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource rand) {
        if (!state.canSurvive((LevelReader)world, pos)) {
            world.removeBlock(pos, false);
        }
    }

    public void neighborChanged(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (world.isClientSide) {
            return;
        }
        if (!this.canSurvive(state, (LevelReader)world, pos)) {
            BlockEntity tile = world.getBlockEntity(pos);
            if (tile instanceof TileDislocatorReceptacle) {
                ((TileDislocatorReceptacle)tile).deactivate();
            }
            world.scheduleTick(pos, (Block)this, 1);
        }
        world.setBlockAndUpdate(pos, Portal.getPlacementState(state, world, pos));
    }

    public void entityInside(BlockState state, Level world, BlockPos pos, Entity entity) {
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof TilePortal && ((TilePortal)tile).getController() != null) {
            ((TilePortal)tile).getController().handleEntityTeleport(entity);
        }
    }

    public static BlockState getPlacementState(BlockState state, Level world, BlockPos pos) {
        return switch ((Direction.Axis)state.getValue(AXIS)) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.Z -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)DRAW_UP, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.above())))).setValue((Property)DRAW_DOWN, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.below())))).setValue((Property)DRAW_EAST, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.east())))).setValue((Property)DRAW_WEST, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.west())));
            case Direction.Axis.Y -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)DRAW_UP, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.north())))).setValue((Property)DRAW_DOWN, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.south())))).setValue((Property)DRAW_EAST, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.east())))).setValue((Property)DRAW_WEST, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.west())));
            case Direction.Axis.X -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)DRAW_UP, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.above())))).setValue((Property)DRAW_DOWN, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.below())))).setValue((Property)DRAW_EAST, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.south())))).setValue((Property)DRAW_WEST, (Comparable)Boolean.valueOf(Portal.isFrame((LevelReader)world, pos.north())));
        };
    }

    private static boolean isFrame(LevelReader world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return state.is((Block)DEContent.INFUSED_OBSIDIAN.get()) || state.is((Block)DEContent.DISLOCATOR_RECEPTACLE.get());
    }

    private static boolean isPortal(LevelReader world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        return state.is((Block)DEContent.PORTAL.get());
    }
}

