from os import listdir, chdir
from os.path import isfile, join, dirname

import json





# Places the program in the folder of the python file
chdir(dirname(__file__))





# FOLDERS

blockStatesFolder = "assets/bountifulblocks/blockstates"
vanillaTagsFolder = "data/minecraft/tags/blocks"
modTagsFolder = "data/bountifulblocks/tags/blocks"





# TAG FILES

# Vanilla
mineablePickaxeFile = open(vanillaTagsFolder + "/mineable/pickaxe.json", "r+")
mineableAxeFile = open(vanillaTagsFolder + "/mineable/axe.json", "r+")
mineableShovelFile = open(vanillaTagsFolder + "/mineable/shovel.json", "r+")
mineableHoeFile = open(vanillaTagsFolder + "/mineable/hoe.json", "r+")

woodenSlabsFile = open(vanillaTagsFolder + "/wooden_slabs.json", "r+")
woodenStairsFile = open(vanillaTagsFolder + "/wooden_stairs.json", "r+")
stairsFile = open(vanillaTagsFolder + "/stairs.json", "r+")
slabsFile = open(vanillaTagsFolder + "/slabs.json", "r+")
wallsFile = open(vanillaTagsFolder + "/walls.json", "r+")
woolFile = open(vanillaTagsFolder + "/wool.json", "r+")
carpetFile = open(vanillaTagsFolder + "/wool_carpets.json", "r+")
occludesVibrationSignalsFile = open(vanillaTagsFolder + "/occludes_vibration_signals.json", "r+")
needsDiamondToolFile = open(vanillaTagsFolder + "/needs_diamond_tool.json", "r+")

# Modded

netherPortalFramesFile = open(modTagsFolder + "/nether_portal_frames.json", "r+")




# BLOCKS

allBlocks = [f for f in listdir(blockStatesFolder) if isfile(join(blockStatesFolder, f))]

wallBlocks = [f for f in allBlocks if isfile(join(blockStatesFolder, f)) and "wall" in f]

# Blocksets (for tags)
obsidianBlocks = [f for f in allBlocks if isfile(join(blockStatesFolder, f)) and "obsidian" in f]
flooringBlocks = [f for f in allBlocks if isfile(join(blockStatesFolder, f)) and "flooring" in f]
snowBlocks = [f for f in allBlocks if isfile(join(blockStatesFolder, f)) and "snow" in f]
woolBlocks = [f for f in allBlocks if isfile(join(blockStatesFolder, f)) and "wool" in f]
carpetBlocks = [f for f in allBlocks if isfile(join(blockStatesFolder, f)) and "carpet" in f]
carvedPlanksBlocks = [f for f in allBlocks if isfile(join(blockStatesFolder, f)) and "planks" in f and "carved" in f]

woodenBlocks = carvedPlanksBlocks + flooringBlocks

woodenStairBlocks = [f for f in allBlocks if isfile(join(blockStatesFolder, f)) and "stairs" in f and f in woodenBlocks]
woodenSlabBlocks = [f for f in allBlocks if isfile(join(blockStatesFolder, f)) and "slab" in f and f in woodenBlocks]

stairBlocks = [f for f in allBlocks if "stairs" in f and f not in woodenStairBlocks]
slabBlocks = [f for f in allBlocks if "slab" in f and f not in woodenSlabBlocks]

occludesVibrationSignalsBlocks = woolBlocks + carpetBlocks

axeBlocks = woolBlocks
shovelBlocks = snowBlocks
hoeBlocks = []

pickaxeBlocks = [f for f in allBlocks if f not in axeBlocks + shovelBlocks + hoeBlocks]





# Adds every wool block to the "wool.json" tag file

wool = json.load(woolFile)
wool["values"] = ["bountifulblocks:" + block.replace(".json", "") for block in woolBlocks]
woolFile.seek(0)
woolFile.write(json.dumps(wool, indent=4))
woolFile.truncate()
woolFile.close()





# Adds every carpet block to the "carpet.json" tag file

carpet = json.load(carpetFile)
carpet["values"] = ["bountifulblocks:" + block.replace(".json", "") for block in carpetBlocks]
carpetFile.seek(0)
carpetFile.write(json.dumps(carpet, indent=4))
carpetFile.truncate()
carpetFile.close()





# Adds some blocks to the "occludes_vibration_signals.json" tag file

occludesVibrationSignals = json.load(occludesVibrationSignalsFile)
occludesVibrationSignals["values"] = ["bountifulblocks:" + block.replace(".json", "") for block in occludesVibrationSignalsBlocks]
occludesVibrationSignalsFile.seek(0)
occludesVibrationSignalsFile.write(json.dumps(occludesVibrationSignals, indent=4))
occludesVibrationSignalsFile.truncate()
occludesVibrationSignalsFile.close()





# Adds every wooden slab to the "wooden_slabs.json" tag file

woodenSlabs = json.load(woodenSlabsFile)
woodenSlabs["values"] = ["bountifulblocks:" + block.replace(".json", "") for block in woodenSlabBlocks]
woodenSlabsFile.seek(0)
woodenSlabsFile.write(json.dumps(woodenSlabs, indent=4))
woodenSlabsFile.truncate()
woodenSlabsFile.close()





# Adds every wooden stair to the "wooden_stairs.json" tag file

woodenStairs = json.load(woodenStairsFile)
woodenStairs["values"] = ["bountifulblocks:" + block.replace(".json", "") for block in woodenStairBlocks]
woodenStairsFile.seek(0)
woodenStairsFile.write(json.dumps(woodenStairs, indent=4))
woodenStairsFile.truncate()
woodenStairsFile.close()





# Adds every slab to the "slabs.json" tag file

slabs = json.load(slabsFile)
slabs["values"] = ["bountifulblocks:" + block.replace(".json", "") for block in slabBlocks]
slabsFile.seek(0)
slabsFile.write(json.dumps(slabs, indent=4))
slabsFile.truncate()
slabsFile.close()



# Adds every stair to the "stairs.json" tag file

stairs = json.load(stairsFile)
stairs["values"] = ["bountifulblocks:" + block.replace(".json", "") for block in stairBlocks]
stairsFile.seek(0)
stairsFile.write(json.dumps(stairs, indent=4))
stairsFile.truncate()
stairsFile.close()



# Adds every wall to the "walls.json" tag file

walls = json.load(wallsFile)
walls["values"] = ["bountifulblocks:" + block.replace(".json", "") for block in wallBlocks]
wallsFile.seek(0)
wallsFile.write(json.dumps(walls, indent=4))
wallsFile.truncate()
wallsFile.close()





# Adds every block that needs a diamond tool to the "needs_diamond_tool.json" tag file

needsDiamondTool = json.load(needsDiamondToolFile)
needsDiamondTool["values"] = ["bountifulblocks:" + block.replace(".json", "") for block in obsidianBlocks]
needsDiamondToolFile.seek(0)
needsDiamondToolFile.write(json.dumps(needsDiamondTool, indent=4))
needsDiamondToolFile.truncate()
needsDiamondToolFile.close()



# Adds every nether portal frame to the "nether_portal_frames.json" tag file + obsidian and crying obsidian

obsidianBlocks2 = obsidianBlocks + ["obsidian.json", "crying_obsidian.json"]

netherPortalFrames = json.load(netherPortalFramesFile)
netherPortalFrames["values"] = ["bountifulblocks:" + block.replace(".json", "") for block in obsidianBlocks2]
netherPortalFramesFile.seek(0)
netherPortalFramesFile.write(json.dumps(netherPortalFrames, indent=4))
netherPortalFramesFile.truncate()
netherPortalFramesFile.close()



# Adds every block to their corresponding mineable tag file

mineablePickaxe = json.load(mineablePickaxeFile)
mineableAxe = json.load(mineableAxeFile)
mineableShovel = json.load(mineableShovelFile)
mineableHoe = json.load(mineableHoeFile)

mineablePickaxe["values"] = ["bountifulblocks:" + block.replace(".json", "") for block in pickaxeBlocks]
mineableAxe["values"] = ["bountifulblocks:" + block.replace(".json", "") for block in axeBlocks]
mineableShovel["values"] = ["bountifulblocks:" + block.replace(".json", "") for block in shovelBlocks]
mineableHoe["values"] = ["bountifulblocks:" + block.replace(".json", "") for block in hoeBlocks]

mineablePickaxeFile.seek(0)
mineablePickaxeFile.write(json.dumps(mineablePickaxe, indent=4))
mineablePickaxeFile.truncate()
mineablePickaxeFile.close()

mineableAxeFile.seek(0)
mineableAxeFile.write(json.dumps(mineableAxe, indent=4))
mineableAxeFile.truncate()
mineableAxeFile.close()

mineableShovelFile.seek(0)
mineableShovelFile.write(json.dumps(mineableShovel, indent=4))
mineableShovelFile.truncate()
mineableShovelFile.close()

mineableHoeFile.seek(0)
mineableHoeFile.write(json.dumps(mineableHoe, indent=4))
mineableHoeFile.truncate()
mineableHoeFile.close()





print("Tags generated successfully!")
print(f"Generated {len(wallBlocks)} wall blocks.")
print(f"Generated {len(obsidianBlocks)} obsidian blocks.")
print(f"Generated {len(flooringBlocks)} flooring blocks.")
print(f"Generated {len(snowBlocks)} snow blocks.")
print(f"Generated {len(woolBlocks)} wool blocks.")
print(f"Generated {len(carpetBlocks)} carpet blocks.")
print(f"Generated {len(carvedPlanksBlocks)} carved planks blocks.")
print(f"Generated {len(woodenStairBlocks)} wooden stair blocks.")
print(f"Generated {len(woodenSlabBlocks)} wooden slab blocks.")
print(f"Generated {len(stairBlocks)} stair blocks.")
print(f"Generated {len(slabBlocks)} slab blocks.")
print(f"Generated {len(occludesVibrationSignalsBlocks)} occludes vibration signals blocks.")
print(f"Generated {len(pickaxeBlocks)} pickaxe blocks.")
print(f"Generated {len(axeBlocks)} axe blocks.")
print(f"Generated {len(shovelBlocks)} shovel blocks.")
print(f"Generated {len(hoeBlocks)} hoe blocks.")

input("Press Enter to exit...")