from os import listdir, chdir
from os.path import isfile, join, dirname





# Places the program in the folder of the python file
chdir(dirname(__file__))





# FOLDERS

blockStatesFolder = "assets/bountifulblocks/blockstates"
exportFolder = "data/bountifulblocks/loot_table/blocks"

templateFolder = "LOOTGEN"
defaultTemplate = templateFolder + "/DEFAULT/INSTANCE.json"
slabTemplate = templateFolder + "/SLAB/INSTANCE.json"
silkTouchTemplate = templateFolder + "/SILK_TOUCH/INSTANCE.json"





# BLOCKS

exceptions = ["mud_pot"]

allBlocks = [f for f in listdir(blockStatesFolder) if isfile(join(blockStatesFolder, f))]
allBlocks = [f for f in allBlocks if f.split(".")[0] not in exceptions]

# Blocksets (for tags)
iceBlocks = [f for f in allBlocks if isfile(join(blockStatesFolder, f)) and "ice" in f]
slabBlocks = [f for f in allBlocks if isfile(join(blockStatesFolder, f)) and "slab" in f]

otherBlocks = [f for f in allBlocks if f not in iceBlocks and f not in slabBlocks]







# Generate loot tables for ice blocks

for block in iceBlocks:
    with open(silkTouchTemplate, "r") as file:
        data = file.read()
        data = data.replace("INSTANCE", block.split(".")[0])

    with open(f"{exportFolder}/{block.split('.')[0]}.json", "w") as file:
        file.write(data)



# Generate loot tables for slab blocks

for block in slabBlocks:
    with open(slabTemplate, "r") as file:
        data = file.read()
        data = data.replace("INSTANCE", block.split(".")[0])

    with open(f"{exportFolder}/{block.split('.')[0]}.json", "w") as file:
        file.write(data)



# Generate loot tables for all other blocks

for block in otherBlocks:
    with open(defaultTemplate, "r") as file:
        data = file.read()
        data = data.replace("INSTANCE", block.split(".")[0])

    with open(f"{exportFolder}/{block.split('.')[0]}.json", "w") as file:
        file.write(data)






print(f"Generated {len(iceBlocks)} loot tables for ice blocks.")
print(f"Generated {len(slabBlocks)} loot tables for slab blocks.")
print(f"Generated {len(otherBlocks)} loot tables for other blocks.")
input("Press enter to exit.")