/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Either;
import io.netty.buffer.ByteBuf;
import java.util.Calendar;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.TetraCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_1836;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2627;
import net.minecraft.class_3218;
import net.minecraft.class_6755;
import net.minecraft.class_6760;
import org.jetbrains.annotations.Nullable;

public class MiscUtils {
    public static final Festivity FESTIVITY = Festivity.get();
    private static final Supplier<class_2627> SHULKER_TILE = Suppliers.memoize(() -> new class_2627(class_2338.field_10980, class_2246.field_10603.method_9564()));

    public static boolean showsHints(class_1836 flagIn) {
        if (PlatHelper.getPhysicalSide().isServer()) {
            return false;
        }
        return ClientConfigs.General.TOOLTIP_HINTS.get();
    }

    @Nullable
    public static class_1297 cloneEntity(class_1297 entity, class_3218 level) {
        class_2487 c = new class_2487();
        entity.method_5662(c);
        Optional opt = class_1299.method_5892((class_2487)c, (class_1937)level);
        return opt.orElse(null);
    }

    public static boolean isSword(class_1792 i) {
        if (i.method_40131().method_40220(ModTags.STATUE_SWORDS)) {
            return true;
        }
        if (CompatHandler.TETRA && TetraCompat.isTetraSword(i)) {
            return true;
        }
        return i instanceof class_1829;
    }

    public static boolean isTool(class_1792 i) {
        if (i.method_40131().method_40220(ModTags.STATUE_TOOLS)) {
            return true;
        }
        if (CompatHandler.TETRA && TetraCompat.isTetraTool(i)) {
            return true;
        }
        return i instanceof class_1766 || i instanceof class_1835;
    }

    public static boolean isAllowedInShulker(class_1799 stack, class_1937 level) {
        class_2627 te = SHULKER_TILE.get();
        te.method_31662(level);
        boolean first = te.method_5492(0, stack, null);
        te.method_31662(null);
        return first && stack.method_7909().method_31568();
    }

    public static boolean withinDistanceDown(class_2338 pos, class_243 vector, double distW, double distDown) {
        double dx = vector.method_10216() - ((double)pos.method_10263() + 0.5);
        double dy = vector.method_10214() - ((double)pos.method_10264() + 0.5);
        double dz = vector.method_10215() - ((double)pos.method_10260() + 0.5);
        double myDistW = dx * dx + dz * dz;
        return myDistW < distW * distW && dy < distW && dy > -distDown;
    }

    public static void scheduleTickOverridingExisting(class_3218 level, class_2338 pos, class_2248 block, int delay) {
        class_6760 tick = new class_6760((Object)block, pos, level.method_8510() + (long)delay, level.method_39224());
        long l = class_1923.method_37232((class_2338)tick.comp_253());
        class_6755 container = (class_6755)level.method_14196().field_35534.get(l);
        container.method_39367(t -> t.comp_253().equals((Object)tick.comp_253()) && t.comp_252() == tick.comp_252());
        container.method_39363(tick);
    }

    public static <A, B, Buf extends ByteBuf> void writeEither(Buf buf, Either<A, B> either, BiConsumer<Buf, A> encodeA, BiConsumer<Buf, B> encodeB) {
        buf.writeBoolean(either.left().isPresent());
        if (either.left().isPresent()) {
            encodeA.accept(buf, either.left().get());
        } else {
            encodeB.accept(buf, either.right().get());
        }
    }

    public static <A, B, Buf extends ByteBuf> Either<A, B> readEither(Buf buf, Function<Buf, A> decodeA, Function<Buf, B> decodeB) {
        if (buf.readBoolean()) {
            return Either.left(decodeA.apply(buf));
        }
        return Either.right(decodeB.apply(buf));
    }

    public static enum Festivity {
        NONE,
        HALLOWEEN,
        APRILS_FOOL,
        CHRISTMAS,
        EARTH_DAY,
        ST_VALENTINE,
        MY_BIRTHDAY,
        MOD_BIRTHDAY;


        public boolean isHalloween() {
            return this == HALLOWEEN;
        }

        public boolean isAprilsFool() {
            return this == APRILS_FOOL;
        }

        public boolean isStValentine() {
            return this == ST_VALENTINE;
        }

        public boolean isChristmas() {
            return this == CHRISTMAS;
        }

        public boolean isEarthDay() {
            return this == EARTH_DAY;
        }

        public boolean isBirthday() {
            return this == MOD_BIRTHDAY || this == MY_BIRTHDAY;
        }

        public float getCandyWrappingIndex() {
            return switch (this.ordinal()) {
                case 1 -> 0.5f;
                case 3 -> 1.0f;
                default -> 0.0f;
            };
        }

        private static Festivity get() {
            if (PlatHelper.getPhysicalSide().isClient() && ClientConfigs.General.UNFUNNY.get().booleanValue()) {
                return NONE;
            }
            Calendar calendar = Calendar.getInstance();
            int month = calendar.get(2);
            int date = calendar.get(5);
            if (month == 9 && date >= 29 || month == 10 && date == 1) {
                return HALLOWEEN;
            }
            if (month == 3 && date == 1) {
                return APRILS_FOOL;
            }
            if (month == 1 && date == 14) {
                return ST_VALENTINE;
            }
            if (month == 3 && date == 22) {
                return EARTH_DAY;
            }
            if (month == 11 && date >= 20) {
                return CHRISTMAS;
            }
            if (month == 1 && date == 7) {
                return MY_BIRTHDAY;
            }
            if (month == 9 && date == 9) {
                return MOD_BIRTHDAY;
            }
            return NONE;
        }
    }
}

