/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.fluids;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.common.block.ModBlockProperties;
import net.minecraft.class_1755;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2402;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_4538;

public abstract class FiniteFluid
extends class_3611 {
    public static final class_2758 LEVEL = ModBlockProperties.FINITE_FLUID_LEVEL;
    private final Map<class_3610, class_265> shapes = Maps.newIdentityHashMap();
    protected final int maxLayers;
    private final Supplier<? extends class_1755> bucket;
    private final Supplier<? extends class_2248> block;

    public FiniteFluid(int maxLayers, Supplier<? extends class_2248> block, Supplier<? extends class_1755> bucket) {
        this.maxLayers = maxLayers;
        this.block = block;
        this.bucket = bucket;
        this.method_15781((class_3610)((class_3610)this.field_15905.method_11664()).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(maxLayers)));
    }

    public int getLayersPerBlock() {
        return this.maxLayers;
    }

    public class_1792 method_15774() {
        return (class_1792)this.bucket.get();
    }

    protected void method_15775(class_2689.class_2690<class_3611, class_3610> builder) {
        builder.method_11667(new class_2769[]{LEVEL});
    }

    public class_243 method_15782(class_1922 blockReader, class_2338 pos, class_3610 fluidState) {
        return class_243.field_1353;
    }

    /*
     * WARNING - void declaration
     */
    private void spreadToSides(class_1937 level, class_2338 pos, class_3610 fluidState, class_2680 blockState) {
        int currentAmount = fluidState.method_15761();
        if (currentAmount > 1) {
            Map<class_2350, Integer> map = this.getWantedSpreadDirections((class_1922)level, pos, blockState);
            ArrayList<Map.Entry<class_2350, Integer>> entryList = new ArrayList<Map.Entry<class_2350, Integer>>(map.entrySet());
            Collections.shuffle(entryList);
            map = new LinkedHashMap<class_2350, Integer>();
            for (Map.Entry entry : entryList) {
                map.put((class_2350)entry.getKey(), (Integer)entry.getValue());
            }
            int initialAmount = currentAmount;
            map.values().removeIf(i -> i >= initialAmount);
            boolean bl = true;
            block1: while (currentAmount <= map.size()) {
                void var9_12;
                void finalR = var9_12++;
                Iterator<Map.Entry<class_2350, Integer>> iter = map.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry<class_2350, Integer> e = iter.next();
                    if (e.getValue() > initialAmount - finalR) {
                        iter.remove();
                    }
                    if (currentAmount <= map.size()) continue;
                    continue block1;
                }
            }
            for (Map.Entry<class_2350, Integer> e : map.entrySet()) {
                int oldAmount = e.getValue();
                class_2350 dir = e.getKey();
                class_2338 facingPos = pos.method_10093(dir);
                class_2680 s = level.method_8320(facingPos);
                class_3610 fluidstate = this.makeState(oldAmount + 1);
                this.spreadTo((class_1936)level, facingPos, s, dir, fluidstate);
            }
            if (!map.isEmpty()) {
                class_3610 myNewState = this.makeState(currentAmount - map.size());
                class_2680 blockstate = (class_2680)blockState.method_11657((class_2769)class_2741.field_12538, (Comparable)((Integer)myNewState.method_15759().method_11654((class_2769)class_2741.field_12538)));
                level.method_8652(pos, blockstate, 2);
                level.method_8452(pos, blockstate.method_26204());
            }
        }
    }

    public class_3610 makeState(int level) {
        return (class_3610)this.method_15785().method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(level));
    }

    protected void spreadTo(class_1936 level, class_2338 pos, class_2680 blockState, class_2350 direction, class_3610 fluidState) {
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof class_2402) {
            class_2402 container = (class_2402)class_22482;
            container.method_10311(level, pos, blockState, fluidState);
        } else if (blockState.method_26227().method_39360((class_3611)this)) {
            level.method_8652(pos, (class_2680)blockState.method_11657((class_2769)class_2741.field_12538, (Comparable)((Integer)fluidState.method_15759().method_11654((class_2769)class_2741.field_12538))), 3);
        } else {
            if (!blockState.method_26215()) {
                this.beforeDestroyingBlock(level, pos, blockState);
            }
            level.method_8652(pos, fluidState.method_15759(), 3);
        }
    }

    protected Map<class_2350, Integer> getWantedSpreadDirections(class_1922 level, class_2338 pos, class_2680 state) {
        HashMap<class_2350, Integer> list = new HashMap<class_2350, Integer>();
        for (class_2350 direction : class_2350.class_2353.field_11062) {
            class_2338 facingPos = pos.method_10093(direction);
            class_2680 facingState = level.method_8320(facingPos);
            class_3610 facingFluid = facingState.method_26227();
            if (!this.canHoldFluid(level, facingPos, facingState)) continue;
            list.put(direction, facingFluid.method_15761());
        }
        return list;
    }

    public void method_15778(class_1937 level, class_2338 pos, class_3610 state) {
        if (state.method_15769()) {
            return;
        }
        class_2680 myState = level.method_8320(pos);
        class_2338 belowPos = pos.method_10074();
        class_2680 belowState = level.method_8320(belowPos);
        class_3610 belowFluid = belowState.method_26227();
        if (belowFluid.method_15772().method_15780((class_3611)this)) {
            if (belowFluid.method_15761() < this.maxLayers) {
                int belowMissing = this.maxLayers - belowFluid.method_15761();
                int belowAddition = Math.min(belowMissing, state.method_15761());
                int newAboveAmount = state.method_15761() - belowAddition;
                level.method_8501(belowPos, ((class_3610)belowFluid.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(belowFluid.method_15761() + belowAddition))).method_15759());
                if (newAboveAmount > 0) {
                    level.method_8501(pos, ((class_3610)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(newAboveAmount))).method_15759());
                } else {
                    level.method_8501(pos, class_2246.field_10124.method_9564());
                }
            } else {
                this.spreadToSides(level, pos, state, myState);
            }
            return;
        }
        if (this.canHoldFluid((class_1922)level, belowPos, belowState)) {
            this.spreadTo((class_1936)level, belowPos, belowState, class_2350.field_11033, state);
            level.method_8501(pos, class_2246.field_10124.method_9564());
        } else {
            this.spreadToSides(level, pos, state, myState);
        }
    }

    private boolean canHoldFluid(class_1922 level, class_2338 pos, class_2680 state) {
        class_3610 fluidState = state.method_26227();
        if (!fluidState.method_15769() && !fluidState.method_39360((class_3611)this)) {
            return false;
        }
        class_2248 block = state.method_26204();
        if (block instanceof class_2402) {
            class_2402 lc = (class_2402)block;
            return lc.method_10310(null, level, pos, state, (class_3611)this);
        }
        if (!(block instanceof class_2323 || state.method_26164(class_3481.field_15500) || state.method_27852(class_2246.field_9983) || state.method_27852(class_2246.field_10424) || state.method_27852(class_2246.field_10422) || state.method_27852(class_2246.field_10316) || state.method_27852(class_2246.field_10027) || state.method_27852(class_2246.field_10613) || state.method_27852(class_2246.field_10369))) {
            return !state.method_51366();
        }
        return false;
    }

    private static boolean hasSameAbove(class_3610 fluidState, class_1922 level, class_2338 pos) {
        return fluidState.method_15772().method_15780(level.method_8316(pos.method_10084()).method_15772());
    }

    public float method_15788(class_3610 state, class_1922 level, class_2338 pos) {
        return FiniteFluid.hasSameAbove(state, level, pos) ? 1.0f : state.method_20785();
    }

    public float method_20784(class_3610 state) {
        return 0.875f * (float)state.method_15761() / (float)this.maxLayers;
    }

    public boolean method_15793(class_3610 state) {
        return true;
    }

    public int method_15779(class_3610 state) {
        return (Integer)state.method_11654((class_2769)LEVEL);
    }

    public class_265 method_17775(class_3610 state, class_1922 level, class_2338 pos) {
        return this.shapes.computeIfAbsent(state, arg3 -> class_259.method_1081((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)arg3.method_15763(level, pos), (double)1.0));
    }

    public boolean shouldSlowDown(class_3610 state) {
        return state.method_15761() > 2;
    }

    protected void beforeDestroyingBlock(class_1936 level, class_2338 pos, class_2680 state) {
        class_2586 blockEntity = state.method_31709() ? level.method_8321(pos) : null;
        class_2248.method_9610((class_2680)state, (class_1936)level, (class_2338)pos, (class_2586)blockEntity);
    }

    protected boolean method_15777(class_3610 state, class_1922 level, class_2338 pos, class_3611 fluid, class_2350 direction) {
        return true;
    }

    public int method_15789(class_4538 level) {
        return 5;
    }

    protected float method_15784() {
        return 0.0f;
    }

    protected class_2680 method_15790(class_3610 state) {
        return (class_2680)this.block.get().method_9564().method_11657((class_2769)class_2404.field_11278, (Comparable)Integer.valueOf(this.getLegacyLevel(state)));
    }

    protected int getLegacyLevel(class_3610 state) {
        int amount = state.method_15761();
        return this.maxLayers - Math.min(amount, this.maxLayers);
    }
}

