/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.blocks;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.block.IPistonMotionReact;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.integration.CompatHandler;
import net.mehvahdjukaar.supplementaries.integration.QuarkCompat;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2669;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4770;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_8710;

public class FlintBlock
extends class_2248
implements IPistonMotionReact {
    private static final Long2ObjectMap<class_2350> BY_NORMAL = (Long2ObjectMap)Arrays.stream(class_2350.values()).collect(Collectors.toMap(direction -> new class_2338(direction.method_10163()).method_10063(), direction -> direction, (direction, direction2) -> {
        throw new IllegalArgumentException("Duplicate keys");
    }, Long2ObjectOpenHashMap::new));

    public FlintBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    public void onMoved(class_1937 level, class_2338 pos, class_2680 movedState, class_2350 direction, boolean extending) {
        class_2338 firePos;
        if (!extending && !level.field_9236 && level.method_8320(firePos = pos.method_10093(direction)).method_26215()) {
            for (class_2350 ironDir : class_2350.values()) {
                class_2338 ironPos;
                class_2680 facingState;
                if (ironDir.method_10166() == direction.method_10166() || !FlintBlock.canBlockCreateSpark(facingState = level.method_8320(ironPos = firePos.method_10093(ironDir)), level, ironPos, ironDir.method_10153())) continue;
                this.ignitePosition(level, firePos, false);
                return;
            }
        }
    }

    private void ignitePosition(class_1937 level, class_2338 firePos, boolean isIronMoving) {
        NetworkHelper.sendToAllClientPlayersInParticleRange((class_3218)((class_3218)level), (class_2338)firePos, (class_8710)new ClientBoundParticlePacket(class_243.method_24953((class_2382)firePos), ClientBoundParticlePacket.Kind.FLINT_BLOCK_IGNITE, isIronMoving ? 1 : 0));
        for (class_2350 dir : class_2350.values()) {
            if (!class_4770.method_30032((class_1937)level, (class_2338)firePos, (class_2350)dir)) continue;
            level.method_8501(firePos, class_4770.method_24416((class_1922)level, (class_2338)firePos));
            level.method_33596(null, (class_6880)class_5712.field_28164, firePos);
            break;
        }
        this.playSound(level, firePos);
    }

    public void method_9591(class_1937 level, class_2338 pos, class_2680 state, class_1297 entity) {
        class_1309 le;
        if (!level.field_9236 && entity instanceof class_1309 && !(le = (class_1309)entity).method_21749() && le.method_5624() && le.field_6012 % 2 == 0 && le.method_6118(class_1304.field_6166).method_31573(ModTags.IGNITE_FLINT_BLOCKS) && level.method_8320(pos.method_10084()).method_26215()) {
            this.ignitePosition(level, pos.method_10084(), true);
        }
        super.method_9591(level, pos, state, entity);
    }

    public static boolean canBlockCreateSpark(class_2680 state, class_1937 level, class_2338 pos, class_2350 face) {
        return state.method_26164(ModTags.FLINT_METALS) && state.method_26206((class_1922)level, pos, face);
    }

    private void playSound(class_1937 level, class_2338 pos) {
        class_5819 randomSource = level.method_8409();
        level.method_8396(null, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, (randomSource.method_43057() - randomSource.method_43057()) * 0.2f + 1.0f);
    }

    public void method_9612(class_2680 state, class_1937 level, class_2338 pos, class_2248 oldBlock, class_2338 targetPos, boolean isMoving) {
        super.method_9612(state, level, pos, oldBlock, targetPos, isMoving);
        class_2680 newState = level.method_8320(targetPos);
        if (!newState.method_26215() || !oldBlock.method_40142().method_40220(ModTags.FLINT_METALS)) {
            return;
        }
        class_2350 dir = (class_2350)BY_NORMAL.get(pos.method_10059((class_2382)targetPos).method_10063());
        for (class_2350 pistonDir : class_2350.values()) {
            class_2680 magnetState;
            if (dir.method_10166() == pistonDir.method_10166()) continue;
            class_2338 tilePos = targetPos.method_10093(pistonDir);
            class_2586 be = level.method_8321(tilePos);
            if (be instanceof class_2669) {
                class_2669 piston = (class_2669)be;
                if (piston.method_11498() != pistonDir.method_10153() || !piston.method_11495().method_27852(oldBlock) || !FlintBlock.canBlockCreateSpark(piston.method_11495(), level, tilePos, dir)) continue;
                this.ignitePosition(level, targetPos, true);
                continue;
            }
            if (be == null || !CompatHandler.QUARK || (magnetState = QuarkCompat.getMagnetStateForFlintBlock(be, pistonDir)) == null || !magnetState.method_27852(oldBlock) || !FlintBlock.canBlockCreateSpark(magnetState, level, tilePos, dir)) continue;
            this.ignitePosition(level, targetPos, true);
        }
    }
}

