/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.screens.widgets;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_1144;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3544;
import net.minecraft.class_3728;
import net.minecraft.class_437;
import net.minecraft.class_5225;
import net.minecraft.class_6382;
import net.minecraft.class_768;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiLineEditBoxWidget
extends class_339 {
    protected final class_310 minecraft;
    protected final class_327 font;
    protected final class_3728 pageEdit;
    @Nullable
    private Consumer<Boolean> onOutOfBounds = null;
    @NotNull
    private String text = "";
    private int frameTick;
    private long lastClickTime;
    private int lastIndex = -1;
    @Nullable
    private DisplayCache displayCache = DisplayCache.EMPTY;

    public MultiLineEditBoxWidget(class_310 mc, int x, int y, int width, int height) {
        super(x, y, width, height, (class_2561)class_2561.method_43470((String)"hhhhh"));
        this.minecraft = mc;
        this.font = mc.field_1772;
        this.pageEdit = new class_3728(this::getText, this::setText, this::getClipboard, this::setClipboard, this::isStringValid);
        this.clearDisplayCache();
    }

    public void setOutOfBoundResponder(Consumer<Boolean> onOutOfBounds) {
        this.onOutOfBounds = onOutOfBounds;
    }

    public void setState(boolean hasItem, boolean packed) {
        this.method_25365(false);
        if (packed) {
            this.field_22763 = false;
        } else {
            this.field_22763 = hasItem;
            if (!hasItem) {
                this.setText("");
            }
        }
    }

    private boolean isStringValid(String s) {
        if (s != null && ((String)s).length() < 256) {
            if (((String)s).endsWith("\n")) {
                s = (String)s + "-";
            }
            return this.font.method_1713((String)s, this.field_22758) <= this.field_22759;
        }
        return false;
    }

    private void setClipboard(String s) {
        if (this.minecraft != null) {
            class_3728.method_27551((class_310)this.minecraft, (String)s);
        }
    }

    private String getClipboard() {
        return this.minecraft != null ? class_3728.method_27556((class_310)this.minecraft) : "";
    }

    public void tick() {
        ++this.frameTick;
    }

    public boolean method_25400(char c, int key) {
        if (this.canConsumeInput() && class_3544.method_57175((char)c)) {
            this.pageEdit.method_16197(Character.toString(c));
            this.clearDisplayCache();
            return true;
        }
        return false;
    }

    public boolean canConsumeInput() {
        return this.method_25370() && this.method_37303();
    }

    public boolean method_25404(int key, int alt, int ctrl) {
        if (this.canConsumeInput() && this.bookKeyPressed(key, alt, ctrl)) {
            this.clearDisplayCache();
            return true;
        }
        return false;
    }

    private boolean bookKeyPressed(int key, int alt, int ctrl) {
        if (class_437.method_25439((int)key)) {
            this.pageEdit.method_27563();
            return true;
        }
        if (class_437.method_25438((int)key)) {
            this.pageEdit.method_27559();
            return true;
        }
        if (class_437.method_25437((int)key)) {
            this.pageEdit.method_27554();
            return true;
        }
        if (class_437.method_25436((int)key)) {
            this.pageEdit.method_27547();
            return true;
        }
        switch (key) {
            case 257: 
            case 335: {
                int p = this.pageEdit.method_16201();
                this.pageEdit.method_16197("\n");
                if (p == this.pageEdit.method_16201()) {
                    this.callOutOfBounds(false);
                }
                return true;
            }
            case 259: {
                this.pageEdit.method_27564(-1);
                return true;
            }
            case 261: {
                this.pageEdit.method_27564(1);
                return true;
            }
            case 262: {
                this.pageEdit.method_27549(1, class_437.method_25442());
                return true;
            }
            case 263: {
                this.pageEdit.method_27549(-1, class_437.method_25442());
                return true;
            }
            case 264: {
                this.keyDown();
                return true;
            }
            case 265: {
                this.keyUp();
                return true;
            }
            case 268: {
                this.keyHome();
                return true;
            }
            case 269: {
                this.moveCursorToEnd();
                return true;
            }
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        boolean old = super.method_25401(mouseX, mouseY, scrollX, scrollY);
        if (this.canConsumeInput() && this.field_22764) {
            if (scrollY >= 1.0) {
                this.keyUp();
                this.clearDisplayCache();
                return true;
            }
            if (scrollY <= -1.0) {
                this.keyDown();
                this.clearDisplayCache();
                return true;
            }
        }
        return old;
    }

    private void callOutOfBounds(boolean up) {
        if (this.onOutOfBounds != null) {
            this.onOutOfBounds.accept(up);
        }
    }

    private void keyUp() {
        this.changeLine(-1);
    }

    private void keyDown() {
        this.changeLine(1);
    }

    private void changeLine(int amount) {
        int i = this.pageEdit.method_16201();
        int j = this.getDisplayCache().changeLine(i, amount);
        this.pageEdit.method_27560(j, class_437.method_25442());
        if (i == j) {
            this.callOutOfBounds(amount < 0);
        }
    }

    private void keyHome() {
        int i = this.pageEdit.method_16201();
        int j = this.getDisplayCache().findLineStart(i);
        this.pageEdit.method_27560(j, class_437.method_25442());
    }

    public void moveCursorToEnd() {
        DisplayCache displayCache = this.getDisplayCache();
        int i = this.pageEdit.method_16201();
        int j = displayCache.findLineEnd(i);
        this.pageEdit.method_27560(j, class_437.method_25442());
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.clearDisplayCache();
        this.onValueChanged();
    }

    public void onValueChanged() {
    }

    protected void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        DisplayCache displayCache = this.getDisplayCache();
        for (LineInfo lineInfo : displayCache.lines) {
            graphics.method_51439(this.font, lineInfo.asComponent, lineInfo.x, lineInfo.y, -16777216, false);
        }
        if (this.method_25370()) {
            this.renderHighlight(graphics, displayCache.selection);
            this.renderCursor(graphics, displayCache.cursor, displayCache.cursorAtEnd);
        }
    }

    private void renderCursor(class_332 graphics, Pos2i pos2i, boolean isEndOfText) {
        if (this.frameTick / 6 % 2 == 0) {
            pos2i = this.convertLocalToScreen(pos2i);
            if (!isEndOfText) {
                graphics.method_25294(pos2i.x, pos2i.y - 1, pos2i.x + 1, pos2i.y + 9, -16777216);
            } else {
                graphics.method_51433(this.font, "_", pos2i.x, pos2i.y, 0, false);
            }
        }
    }

    private void renderHighlight(class_332 graphics, class_768[] rect2is) {
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.class_1030)GlStateManager.class_1030.field_5110);
        for (class_768 rect2i : rect2is) {
            int i = rect2i.method_3321();
            int j = rect2i.method_3322();
            int k = i + rect2i.method_3319();
            int l = j + rect2i.method_3320();
            graphics.method_25294(i, j, k, l, -16776961);
        }
        RenderSystem.disableColorLogicOp();
    }

    private Pos2i convertScreenToLocal(Pos2i pos2i) {
        return new Pos2i(pos2i.x - this.method_46426(), pos2i.y - this.method_46427());
    }

    private Pos2i convertLocalToScreen(Pos2i pos2i) {
        return new Pos2i(pos2i.x + this.method_46426(), pos2i.y + this.method_46427());
    }

    public void method_25354(class_1144 soundManager) {
    }

    public void method_25348(double mouseX, double mouseY) {
        this.method_25365(true);
    }

    public boolean method_25361(double mouseX, double mouseY) {
        if (this.method_25405(mouseX, mouseY)) {
            long i = class_156.method_658();
            DisplayCache displayCache = this.getDisplayCache();
            int j = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
            if (j >= 0) {
                if (j == this.lastIndex && i - this.lastClickTime < 250L) {
                    if (!this.pageEdit.method_27568()) {
                        this.selectWord(j);
                    } else {
                        this.pageEdit.method_27563();
                    }
                } else {
                    this.pageEdit.method_27560(j, class_437.method_25442());
                }
                this.clearDisplayCache();
            }
            this.lastIndex = j;
            this.lastClickTime = i;
            return true;
        }
        return false;
    }

    private void selectWord(int i) {
        String s = this.getText();
        this.pageEdit.method_27548(class_5225.method_27483((String)s, (int)-1, (int)i, (boolean)false), class_5225.method_27483((String)s, (int)1, (int)i, (boolean)false));
    }

    public void method_25349(double mouseX, double mouseY, double dx, double dy) {
        DisplayCache displayCache = this.getDisplayCache();
        int i = displayCache.getIndexAtPosition(this.font, this.convertScreenToLocal(new Pos2i((int)mouseX, (int)mouseY)));
        this.pageEdit.method_27560(i, true);
        this.clearDisplayCache();
    }

    protected DisplayCache getDisplayCache() {
        if (this.displayCache == null) {
            this.displayCache = this.rebuildDisplayCache();
        }
        return this.displayCache;
    }

    protected void clearDisplayCache() {
        this.displayCache = null;
    }

    private DisplayCache rebuildDisplayCache() {
        Pos2i pos2i;
        boolean flag;
        String s = this.getText();
        if (s.isEmpty()) {
            return DisplayCache.EMPTY;
        }
        int i = this.pageEdit.method_16201();
        int j = this.pageEdit.method_16203();
        IntArrayList intlist = new IntArrayList();
        ArrayList list = Lists.newArrayList();
        MutableInt mutableint = new MutableInt();
        MutableBoolean mutableboolean = new MutableBoolean();
        class_5225 stringsplitter = this.font.method_27527();
        stringsplitter.method_27485(s, this.field_22758, class_2583.field_24360, true, (arg_0, arg_1, arg_2) -> this.lambda$rebuildDisplayCache$0(mutableint, s, mutableboolean, (IntList)intlist, list, arg_0, arg_1, arg_2));
        int[] toIntArray = intlist.toIntArray();
        boolean bl = flag = i == s.length();
        if (flag && mutableboolean.isTrue()) {
            pos2i = new Pos2i(0, list.size() * 9);
        } else {
            int k = MultiLineEditBoxWidget.findLineFromPos(toIntArray, i);
            int l = this.font.method_1727(s.substring(toIntArray[k], i));
            pos2i = new Pos2i(l, k * 9);
        }
        ArrayList list1 = Lists.newArrayList();
        if (i != j) {
            int k1;
            int l2 = Math.min(i, j);
            int i1 = Math.max(i, j);
            int j1 = MultiLineEditBoxWidget.findLineFromPos(toIntArray, l2);
            if (j1 == (k1 = MultiLineEditBoxWidget.findLineFromPos(toIntArray, i1))) {
                int l1 = j1 * 9;
                int i2 = toIntArray[j1];
                list1.add(this.createPartialLineSelection(s, stringsplitter, l2, i1, l1, i2));
            } else {
                int i3 = j1 + 1 > toIntArray.length ? s.length() : toIntArray[j1 + 1];
                list1.add(this.createPartialLineSelection(s, stringsplitter, l2, i3, j1 * 9, toIntArray[j1]));
                for (int j3 = j1 + 1; j3 < k1; ++j3) {
                    int j2 = j3 * 9;
                    String s1 = s.substring(toIntArray[j3], toIntArray[j3 + 1]);
                    int k2 = (int)stringsplitter.method_27482(s1);
                    list1.add(this.createSelection(new Pos2i(0, j2), new Pos2i(k2, j2 + 9)));
                }
                list1.add(this.createPartialLineSelection(s, stringsplitter, toIntArray[k1], i1, k1 * 9, toIntArray[k1]));
            }
        }
        return new DisplayCache(s, pos2i, flag, toIntArray, list.toArray(new LineInfo[0]), list1.toArray(new class_768[0]));
    }

    static int findLineFromPos(int[] lineStarts, int find) {
        int i = Arrays.binarySearch(lineStarts, find);
        return i < 0 ? -(i + 2) : i;
    }

    private class_768 createPartialLineSelection(String input, class_5225 splitter, int i, int j, int k, int l) {
        String string = input.substring(l, i);
        String string2 = input.substring(l, j);
        Pos2i pos2i = new Pos2i((int)splitter.method_27482(string), k);
        int var10002 = (int)splitter.method_27482(string2);
        Objects.requireNonNull(this.font);
        Pos2i pos2i2 = new Pos2i(var10002, k + 9);
        return this.createSelection(pos2i, pos2i2);
    }

    private class_768 createSelection(Pos2i corner1, Pos2i corner2) {
        Pos2i pos2i = this.convertLocalToScreen(corner1);
        Pos2i pos2i2 = this.convertLocalToScreen(corner2);
        int i = Math.min(pos2i.x, pos2i2.x);
        int j = Math.max(pos2i.x, pos2i2.x);
        int k = Math.min(pos2i.y, pos2i2.y);
        int l = Math.max(pos2i.y, pos2i2.y);
        return new class_768(i, k, j - i, l - k);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    private /* synthetic */ void lambda$rebuildDisplayCache$0(MutableInt mutableint, String s, MutableBoolean mutableboolean, IntList intlist, List list, class_2583 lineInfo, int i1, int i2) {
        int k3 = mutableint.getAndIncrement();
        String s2 = s.substring(i1, i2);
        mutableboolean.setValue(s2.endsWith("\n"));
        String s3 = StringUtils.stripEnd((String)s2, (String)" \n");
        int l3 = k3 * 9;
        Pos2i pos2i = this.convertLocalToScreen(new Pos2i(0, l3));
        intlist.add(i1);
        list.add(new LineInfo(lineInfo, s3, pos2i.x, pos2i.y));
    }

    protected static class DisplayCache {
        static final DisplayCache EMPTY = new DisplayCache("", new Pos2i(0, 0), true, new int[]{0}, new LineInfo[]{new LineInfo(class_2583.field_24360, "", 0, 0)}, new class_768[0]);
        private final String fullText;
        final Pos2i cursor;
        final boolean cursorAtEnd;
        private final int[] lineStarts;
        final LineInfo[] lines;
        final class_768[] selection;

        public DisplayCache(String text, Pos2i cursorPos, boolean cursorAtEnd, int[] lineStart, LineInfo[] lines, class_768[] selection) {
            this.fullText = text;
            this.cursor = cursorPos;
            this.cursorAtEnd = cursorAtEnd;
            this.lineStarts = lineStart;
            this.lines = lines;
            this.selection = selection;
        }

        public int getIndexAtPosition(class_327 font, Pos2i pos2i) {
            int i = pos2i.y / 9;
            if (i < 0) {
                return 0;
            }
            if (i >= this.lines.length) {
                return this.fullText.length();
            }
            LineInfo lineInfo = this.lines[i];
            return this.lineStarts[i] + font.method_27527().method_27484(lineInfo.contents, pos2i.x, lineInfo.style);
        }

        public int changeLine(int x, int y) {
            int k;
            int i = MultiLineEditBoxWidget.findLineFromPos(this.lineStarts, x);
            int j = i + y;
            if (0 <= j && j < this.lineStarts.length) {
                int l = x - this.lineStarts[i];
                int i1 = this.lines[j].contents.length();
                k = this.lineStarts[j] + Math.min(l, i1);
            } else {
                k = x;
            }
            return k;
        }

        public int findLineStart(int i1) {
            int i = MultiLineEditBoxWidget.findLineFromPos(this.lineStarts, i1);
            return this.lineStarts[i];
        }

        public int findLineEnd(int i1) {
            int i = MultiLineEditBoxWidget.findLineFromPos(this.lineStarts, i1);
            return this.lineStarts[i] + this.lines[i].contents.length();
        }
    }

    static class LineInfo {
        final class_2583 style;
        final String contents;
        final class_2561 asComponent;
        final int x;
        final int y;

        public LineInfo(class_2583 style, String contents, int x, int y) {
            this.style = style;
            this.contents = contents;
            this.x = x;
            this.y = y;
            this.asComponent = class_2561.method_43470((String)contents).method_10862(style);
        }
    }

    protected record Pos2i(int x, int y) {
    }
}

