/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.network.codec;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import fuzs.puzzleslib.api.network.v3.codec.ExtraStreamCodecs;
import fuzs.puzzleslib.api.network.v3.codec.StreamCodecRegistry;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.network.codec.RecordStreamCodec;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1842;
import net.minecraft.class_1856;
import net.minecraft.class_1923;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2379;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3917;
import net.minecraft.class_3965;
import net.minecraft.class_4050;
import net.minecraft.class_4158;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8824;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9141;
import net.minecraft.class_9142;
import net.minecraft.class_9336;
import org.joml.Vector3f;

public final class StreamCodecRegistryImpl
implements StreamCodecRegistry<StreamCodecRegistryImpl> {
    public static final StreamCodecRegistry<?> INSTANCE = new StreamCodecRegistryImpl();
    private static final Map<Class<?>, class_9139<?, ?>> SERIALIZERS = Collections.synchronizedMap(Maps.newIdentityHashMap());
    private static final Map<Class<?>, Function<Type[], class_9139<?, ?>>> CONTAINER_PROVIDERS = Collections.synchronizedMap(Maps.newLinkedHashMap());

    @Override
    public <B extends ByteBuf, V> StreamCodecRegistryImpl registerSerializer(Class<V> type, class_9139<? super B, V> streamCodec) {
        if (SERIALIZERS.put(type, streamCodec) != null) {
            PuzzlesLib.LOGGER.warn("Overriding serializer registered for type {}", type);
        }
        return this;
    }

    @Override
    public <B extends ByteBuf, V> StreamCodecRegistryImpl registerContainerProvider(Class<V> type, Function<Type[], class_9139<? super B, ? extends V>> factory) {
        if (CONTAINER_PROVIDERS.put(type, factory) != null) {
            PuzzlesLib.LOGGER.warn("Overriding collection provider registered for type {}", type);
        }
        return this;
    }

    public static <B extends ByteBuf, V> class_9139<B, V> fromType(Class<V> type) {
        Object streamCodec = SERIALIZERS.get(type);
        if (streamCodec == null) {
            streamCodec = StreamCodecRegistryImpl.computeIfAbsent(type);
            SERIALIZERS.put(type, (class_9139<?, ?>)streamCodec);
        }
        return streamCodec;
    }

    private static <B extends ByteBuf, V> class_9139<B, V> computeIfAbsent(Class<V> clazz) {
        if (Record.class.isAssignableFrom(clazz)) {
            return RecordStreamCodec.createRecordSerializer(clazz);
        }
        if (clazz.isArray()) {
            return StreamCodecRegistryImpl.createArraySerializer(clazz.getComponentType());
        }
        if (clazz.isEnum()) {
            return StreamCodecRegistryImpl.createEnumSerializer(clazz);
        }
        throw new RuntimeException("Missing serializer for type " + String.valueOf(clazz));
    }

    public static <B extends ByteBuf, V> class_9139<B, V> fromGenericType(Type type) {
        if (type instanceof Class) {
            return StreamCodecRegistryImpl.fromType((Class)type);
        }
        ParameterizedType parameterizedType = (ParameterizedType)type;
        Class clazz = (Class)parameterizedType.getRawType();
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        for (Map.Entry<Class<?>, Function<Type[], class_9139<?, ?>>> entry : CONTAINER_PROVIDERS.entrySet()) {
            if (!entry.getKey().isAssignableFrom(clazz)) continue;
            return entry.getValue().apply(typeArguments);
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return StreamCodecRegistryImpl.createCollectionSerializer(typeArguments, Sets::newLinkedHashSetWithExpectedSize);
        }
        return StreamCodecRegistryImpl.fromType(clazz);
    }

    private static <K, V> class_9139<class_2540, Map<K, V>> createMapSerializer(Type[] typeArguments) {
        class_9139 keyStreamCodec = StreamCodecRegistryImpl.fromType((Class)typeArguments[0]);
        class_9139 valueStreamCodec = StreamCodecRegistryImpl.fromType((Class)typeArguments[1]);
        return class_9139.method_56437((friendlyByteBuf, map) -> friendlyByteBuf.method_34063(map, (class_9142)keyStreamCodec, (class_9142)valueStreamCodec), buf -> buf.method_34067((class_9141)keyStreamCodec, (class_9141)valueStreamCodec));
    }

    private static <V, C extends Collection<V>> class_9139<class_2540, C> createCollectionSerializer(Type[] typeArguments, IntFunction<C> factory) {
        class_9139 streamCodec = StreamCodecRegistryImpl.fromType((Class)typeArguments[0]);
        return class_9139.method_56437((buf, collection) -> buf.method_34062(collection, (class_9142)streamCodec), buf -> buf.method_34068(factory, (class_9141)streamCodec));
    }

    private static <V> class_9139<class_2540, Optional<V>> createOptionalSerializer(Type[] typeArguments) {
        class_9139 streamCodec = StreamCodecRegistryImpl.fromType((Class)typeArguments[0]);
        return class_9139.method_56437((buf, optional) -> buf.method_37435(optional, (class_9142)streamCodec), buf -> buf.method_37436((class_9141)streamCodec));
    }

    private static <V> class_9139<class_9129, class_6880<V>> createHolderSerializer(Type[] typeArguments) {
        return class_9139.method_56437((buf, holder) -> {
            class_5321 resourceKey = (class_5321)holder.method_40230().orElseThrow();
            ExtraStreamCodecs.DIRECT_RESOURCE_KEY.encode(buf, (Object)resourceKey);
            class_9135.method_56383((class_5321)resourceKey.method_58273()).encode(buf, holder);
        }, buf -> {
            class_5321 resourceKey = (class_5321)ExtraStreamCodecs.DIRECT_RESOURCE_KEY.decode(buf);
            return (class_6880)class_9135.method_56383((class_5321)resourceKey.method_58273()).decode(buf);
        });
    }

    private static <V> class_9139<class_2540, V[]> createArraySerializer(Class<?> clazz) {
        class_9139 streamCodec = StreamCodecRegistryImpl.fromType(clazz);
        return class_9139.method_56437((buf, array) -> {
            int length = Array.getLength(array);
            buf.method_10804(length);
            for (int i = 0; i < length; ++i) {
                streamCodec.encode(buf, Array.get(array, i));
            }
        }, buf -> {
            int length = buf.method_10816();
            Object array = Array.newInstance(clazz, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, streamCodec.decode(buf));
            }
            return (Object[])array;
        });
    }

    private static <E extends Enum<E>> class_9139<class_2540, E> createEnumSerializer(Class<Enum<?>> clazz) {
        return class_9139.method_56437(class_2540::method_10817, buf -> buf.method_10818(clazz));
    }

    static {
        INSTANCE.registerSerializer(Boolean.TYPE, class_9135.field_48547);
        INSTANCE.registerSerializer(Boolean.class, class_9135.field_48547);
        INSTANCE.registerSerializer(Integer.TYPE, class_9135.field_48550);
        INSTANCE.registerSerializer(Integer.class, class_9135.field_48550);
        INSTANCE.registerSerializer(Long.TYPE, class_9135.field_48551);
        INSTANCE.registerSerializer(Long.class, class_9135.field_48551);
        INSTANCE.registerSerializer(Float.TYPE, class_9135.field_48552);
        INSTANCE.registerSerializer(Float.class, class_9135.field_48552);
        INSTANCE.registerSerializer(Double.TYPE, class_9135.field_48553);
        INSTANCE.registerSerializer(Double.class, class_9135.field_48553);
        INSTANCE.registerSerializer(Byte.TYPE, class_9135.field_48548);
        INSTANCE.registerSerializer(Byte.class, class_9135.field_48548);
        INSTANCE.registerSerializer(Short.TYPE, class_9135.field_48549);
        INSTANCE.registerSerializer(Short.class, class_9135.field_48549);
        INSTANCE.registerSerializer(Character.TYPE, ExtraStreamCodecs.CHAR);
        INSTANCE.registerSerializer(Character.class, ExtraStreamCodecs.CHAR);
        INSTANCE.registerSerializer(String.class, class_9135.field_48554);
        INSTANCE.registerSerializer(Date.class, ExtraStreamCodecs.DATE);
        INSTANCE.registerSerializer(Instant.class, ExtraStreamCodecs.INSTANT);
        INSTANCE.registerSerializer(UUID.class, class_4844.field_48453);
        INSTANCE.registerSerializer(class_2561.class, class_8824.field_49666);
        INSTANCE.registerSerializer(class_1799.class, class_1799.field_49268);
        INSTANCE.registerSerializer(class_1856.class, class_1856.field_48355);
        INSTANCE.registerSerializer(class_2379.class, class_2379.field_48452);
        INSTANCE.registerSerializer(class_2338.class, class_2338.field_48404);
        INSTANCE.registerSerializer(class_2350.class, class_2350.field_48450);
        INSTANCE.registerSerializer(class_2487.class, class_9135.field_49677);
        INSTANCE.registerSerializer(class_2394.class, class_2398.field_48456);
        INSTANCE.registerSerializer(class_3850.class, class_3850.field_48345);
        INSTANCE.registerSerializer(class_4050.class, class_4050.field_48323);
        INSTANCE.registerSerializer(class_1923.class, ExtraStreamCodecs.CHUNK_POS);
        INSTANCE.registerSerializer(class_2960.class, class_2960.field_48267);
        INSTANCE.registerSerializer(class_5321.class, ExtraStreamCodecs.DIRECT_RESOURCE_KEY);
        INSTANCE.registerSerializer(class_9336.class, class_9336.field_49657);
        INSTANCE.registerSerializer(class_3965.class, ExtraStreamCodecs.BLOCK_HIT_RESULT);
        INSTANCE.registerSerializer(BitSet.class, ExtraStreamCodecs.BIT_SET);
        INSTANCE.registerSerializer(GameProfile.class, class_9135.field_49679);
        INSTANCE.registerSerializer(class_243.class, ExtraStreamCodecs.VEC3);
        INSTANCE.registerSerializer(Vector3f.class, ExtraStreamCodecs.VECTOR3F);
        INSTANCE.registerSerializer(class_2540.class, ExtraStreamCodecs.FRIENDLY_BYTE_BUF);
        INSTANCE.registerSerializer(class_9129.class, ExtraStreamCodecs.REGISTRY_FRIENDLY_BYTE_BUF);
        INSTANCE.registerSerializer(class_3414.class, class_7924.field_41225);
        INSTANCE.registerSerializer(class_3611.class, class_7924.field_41270);
        INSTANCE.registerSerializer(class_1291.class, class_7924.field_41208);
        INSTANCE.registerSerializer(class_2248.class, class_7924.field_41254);
        INSTANCE.registerSerializer(class_1299.class, class_7924.field_41266);
        INSTANCE.registerSerializer(class_1792.class, class_7924.field_41197);
        INSTANCE.registerSerializer(class_1842.class, class_7924.field_41215);
        INSTANCE.registerSerializer(class_2396.class, class_7924.field_41210);
        INSTANCE.registerSerializer(class_2591.class, class_7924.field_41255);
        INSTANCE.registerSerializer(class_3917.class, class_7924.field_41207);
        INSTANCE.registerSerializer(class_1320.class, class_7924.field_41251);
        INSTANCE.registerSerializer(class_5712.class, class_7924.field_41273);
        INSTANCE.registerSerializer(class_3854.class, class_7924.field_41235);
        INSTANCE.registerSerializer(class_3852.class, class_7924.field_41234);
        INSTANCE.registerSerializer(class_4158.class, class_7924.field_41212);
        INSTANCE.registerContainerProvider(Map.class, StreamCodecRegistryImpl::createMapSerializer);
        INSTANCE.registerContainerProvider(List.class, (Type[] typeArguments) -> StreamCodecRegistryImpl.createCollectionSerializer(typeArguments, ArrayList::new));
        INSTANCE.registerContainerProvider(Optional.class, StreamCodecRegistryImpl::createOptionalSerializer);
        INSTANCE.registerContainerProvider(class_6880.class, StreamCodecRegistryImpl::createHolderSerializer);
    }
}

