/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v3;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3898;
import net.minecraft.class_5629;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public interface PlayerSet {
    public void broadcast(class_8710.class_9154<?> var1, class_2596<?> var2);

    public static PlayerSet ofNone() {
        return (type, packet) -> {};
    }

    public static PlayerSet ofEntity(class_1297 entity) {
        PlayerSet playerSet;
        Objects.requireNonNull(entity, "entity is null");
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            playerSet = PlayerSet.ofPlayer(serverPlayer);
        } else {
            playerSet = PlayerSet.ofNone();
        }
        return playerSet;
    }

    public static PlayerSet ofPlayer(class_3222 serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return (type, packet) -> {
            if (CommonAbstractions.INSTANCE.hasChannel(serverPlayer, type)) {
                serverPlayer.field_13987.method_14364(packet);
            }
        };
    }

    public static PlayerSet ofOthers(class_3222 serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return (type, packet) -> serverPlayer.method_5682().method_3760().method_14571().forEach(currentServerPlayer -> {
            if (currentServerPlayer != serverPlayer) {
                PlayerSet.ofPlayer(currentServerPlayer).broadcast(type, packet);
            }
        });
    }

    public static PlayerSet ofAll(MinecraftServer minecraftServer) {
        return (type, packet) -> minecraftServer.method_3760().method_14571().forEach(serverPlayer -> PlayerSet.ofPlayer(serverPlayer).broadcast(type, packet));
    }

    public static PlayerSet inLevel(class_3218 serverLevel) {
        Objects.requireNonNull(serverLevel, "server level is null");
        return (type, packet) -> {
            for (class_3222 serverPlayer : serverLevel.method_18456()) {
                PlayerSet.ofPlayer(serverPlayer).broadcast(type, packet);
            }
        };
    }

    public static PlayerSet nearPosition(class_2382 position, class_3218 serverLevel) {
        Objects.requireNonNull(position, "position is null");
        return PlayerSet.nearPosition(position.method_10263(), position.method_10264(), position.method_10260(), serverLevel);
    }

    public static PlayerSet nearPosition(double posX, double posY, double posZ, class_3218 serverLevel) {
        return PlayerSet.nearPosition(null, posX, posY, posZ, 64.0, serverLevel);
    }

    public static PlayerSet nearPosition(@Nullable class_3222 excludePlayer, double posX, double posY, double posZ, double distance, class_3218 serverLevel) {
        Objects.requireNonNull(serverLevel, "server level is null");
        return (type, packet) -> {
            for (class_3222 serverPlayer : serverLevel.method_8503().method_3760().method_14571()) {
                double deltaZ;
                double deltaY;
                double deltaX;
                if (serverPlayer == excludePlayer || serverPlayer.method_37908().method_27983() != serverLevel.method_27983() || !((deltaX = posX - serverPlayer.method_23317()) * deltaX + (deltaY = posY - serverPlayer.method_23318()) * deltaY + (deltaZ = posZ - serverPlayer.method_23321()) * deltaZ < distance * distance)) continue;
                PlayerSet.ofPlayer(serverPlayer).broadcast(type, packet);
            }
        };
    }

    public static PlayerSet nearBlockEntity(class_2586 blockEntity) {
        Objects.requireNonNull(blockEntity, "block entity is null");
        class_1937 level = blockEntity.method_10997();
        Objects.requireNonNull(level, "block entity level is null");
        return level.field_9236 ? PlayerSet.ofNone() : PlayerSet.nearPosition((class_2382)blockEntity.method_11016(), (class_3218)level);
    }

    public static PlayerSet nearChunk(class_2818 levelChunk) {
        Objects.requireNonNull(levelChunk, "chunk is null");
        return levelChunk.method_12200().field_9236 ? PlayerSet.ofNone() : PlayerSet.nearChunk((class_3218)levelChunk.method_12200(), levelChunk.method_12004());
    }

    public static PlayerSet nearChunk(class_3218 serverLevel, class_1923 chunkPos) {
        Objects.requireNonNull(serverLevel, "server level is null");
        Objects.requireNonNull(chunkPos, "chunk pos is null");
        return (type, packet) -> serverLevel.method_14178().field_17254.method_17210(chunkPos, false).forEach(serverPlayer -> PlayerSet.ofPlayer(serverPlayer).broadcast(type, packet));
    }

    public static PlayerSet nearEntity(class_1297 entity) {
        Objects.requireNonNull(entity, "entity is null");
        return entity.method_5770().field_9236 ? PlayerSet.ofNone() : (type, packet) -> {
            class_3898 chunkMap = ((class_3218)entity.method_5770()).method_14178().field_17254;
            class_3898.class_3208 trackedEntity = (class_3898.class_3208)chunkMap.field_18242.get(entity.method_5628());
            if (trackedEntity != null) {
                for (class_5629 serverPlayerConnection : trackedEntity.field_18250) {
                    PlayerSet.ofPlayer(serverPlayerConnection.method_32311()).broadcast(type, packet);
                }
                if (entity instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)entity;
                    PlayerSet.ofPlayer(serverPlayer).broadcast(type, packet);
                }
            }
        };
    }

    public static PlayerSet nearPlayer(class_3222 serverPlayer) {
        Objects.requireNonNull(serverPlayer, "server player is null");
        return (type, packet) -> {
            class_3898 chunkMap = serverPlayer.method_51469().method_14178().field_17254;
            class_3898.class_3208 trackedEntity = (class_3898.class_3208)chunkMap.field_18242.get(serverPlayer.method_5628());
            if (trackedEntity != null) {
                for (class_5629 serverPlayerConnection : trackedEntity.field_18250) {
                    PlayerSet.ofPlayer(serverPlayerConnection.method_32311()).broadcast(type, packet);
                }
            }
        };
    }
}

