/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.network.v3;

import fuzs.puzzleslib.api.core.v1.utility.Buildable;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import fuzs.puzzleslib.api.network.v2.MessageV2;
import fuzs.puzzleslib.api.network.v3.ClientboundMessage;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import fuzs.puzzleslib.api.network.v3.ServerboundMessage;
import fuzs.puzzleslib.api.network.v3.codec.StreamCodecRegistry;
import fuzs.puzzleslib.impl.core.ModContext;
import fuzs.puzzleslib.impl.network.NetworkHandlerRegistry;
import fuzs.puzzleslib.impl.network.codec.StreamCodecRegistryImpl;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_2382;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8705;
import net.minecraft.class_8706;
import net.minecraft.class_9139;
import net.minecraft.class_9141;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public interface NetworkHandler {
    public static Builder builder(String modId) {
        return NetworkHandler.builder(ResourceLocationHelper.fromNamespaceAndPath(modId, "play"));
    }

    public static Builder builder(class_2960 channelName) {
        return ModContext.get(channelName.method_12836()).getNetworkHandler(channelName);
    }

    public <T> class_2596<class_8705> toClientboundPacket(ClientboundMessage<T> var1);

    public <T> class_2596<class_8706> toServerboundPacket(ServerboundMessage<T> var1);

    public <T> void sendMessage(PlayerSet var1, ClientboundMessage<T> var2);

    public <T> void sendMessage(ServerboundMessage<T> var1);

    @Deprecated
    default public <T> void sendToServer(ServerboundMessage<T> message) {
        this.sendMessage(message);
    }

    @Deprecated
    default public <T> void sendTo(class_3222 player, ClientboundMessage<T> message) {
        this.sendMessage(PlayerSet.ofPlayer(player), message);
    }

    @Deprecated
    default public <T> void sendToAll(MinecraftServer server, ClientboundMessage<T> message) {
        this.sendMessage(PlayerSet.ofAll(server), message);
    }

    @Deprecated
    default public <T> void sendToAll(MinecraftServer server, @Nullable class_3222 excludePlayer, ClientboundMessage<T> message) {
        PlayerSet playerSet = excludePlayer != null ? PlayerSet.ofOthers(excludePlayer) : PlayerSet.ofAll(server);
        this.sendMessage(playerSet, message);
    }

    @Deprecated
    default public <T> void sendToAll(Collection<class_3222> playerList, @Nullable class_3222 excludePlayer, ClientboundMessage<T> message) {
        Objects.requireNonNull(playerList, "player list is null");
        for (class_3222 serverPlayer : playerList) {
            if (serverPlayer == excludePlayer) continue;
            this.sendTo(serverPlayer, message);
        }
    }

    @Deprecated
    default public <T> void sendToAll(class_3218 level, ClientboundMessage<T> message) {
        this.sendMessage(PlayerSet.inLevel(level), message);
    }

    @Deprecated
    default public <T> void sendToAllNear(class_2382 pos, class_3218 level, ClientboundMessage<T> message) {
        this.sendMessage(PlayerSet.nearPosition(pos, level), message);
    }

    @Deprecated
    default public <T> void sendToAllNear(double posX, double posY, double posZ, class_3218 level, ClientboundMessage<T> message) {
        this.sendMessage(PlayerSet.nearPosition(posX, posY, posZ, level), message);
    }

    @Deprecated
    default public <T> void sendToAllNear(@Nullable class_3222 excludePlayer, double posX, double posY, double posZ, double distance, class_3218 level, ClientboundMessage<T> message) {
        this.sendMessage(PlayerSet.nearPosition(excludePlayer, posX, posY, posZ, distance, level), message);
    }

    @Deprecated
    default public <T> void sendToAllTracking(class_2586 blockEntity, ClientboundMessage<T> message) {
        this.sendMessage(PlayerSet.nearBlockEntity(blockEntity), message);
    }

    @Deprecated
    default public <T> void sendToAllTracking(class_2818 chunk, ClientboundMessage<T> message) {
        this.sendMessage(PlayerSet.nearChunk(chunk), message);
    }

    @Deprecated
    default public <T> void sendToAllTracking(class_3218 level, class_1923 chunkPos, ClientboundMessage<T> message) {
        this.sendMessage(PlayerSet.nearChunk(level, chunkPos), message);
    }

    @Deprecated
    default public <T> void sendToAllTracking(class_1297 entity, ClientboundMessage<T> message, boolean includeSelf) {
        if (includeSelf || !(entity instanceof class_3222)) {
            this.sendMessage(PlayerSet.nearEntity(entity), message);
        } else {
            class_3222 serverPlayer = (class_3222)entity;
            this.sendMessage(PlayerSet.nearPlayer(serverPlayer), message);
        }
    }

    public static interface Builder
    extends NetworkHandlerRegistry,
    StreamCodecRegistry<Builder>,
    Buildable {
        @Override
        default public <B extends ByteBuf, V> Builder registerSerializer(Class<V> type, class_9139<? super B, V> streamCodec) {
            StreamCodecRegistryImpl.INSTANCE.registerSerializer(type, streamCodec);
            return this;
        }

        @Override
        default public <B extends ByteBuf, V> Builder registerContainerProvider(Class<V> type, Function<Type[], class_9139<? super B, ? extends V>> factory) {
            StreamCodecRegistryImpl.INSTANCE.registerContainerProvider(type, factory);
            return this;
        }

        public <T extends Record> Builder registerClientbound(Class<T> var1);

        public <T extends Record> Builder registerServerbound(Class<T> var1);

        default public <T extends MessageV2<T>> Builder registerLegacyClientbound(Class<T> clazz, Supplier<T> factory) {
            return this.registerLegacyClientbound(clazz, friendlyByteBuf -> {
                MessageV2 message = (MessageV2)factory.get();
                message.read((class_2540)friendlyByteBuf);
                return message;
            });
        }

        default public <T extends MessageV2<T>> Builder registerLegacyServerbound(Class<T> clazz, Supplier<T> factory) {
            return this.registerLegacyServerbound(clazz, friendlyByteBuf -> {
                MessageV2 message = (MessageV2)factory.get();
                message.read((class_2540)friendlyByteBuf);
                return message;
            });
        }

        public <T extends MessageV2<T>> Builder registerLegacyClientbound(Class<T> var1, class_9141<class_2540, T> var2);

        public <T extends MessageV2<T>> Builder registerLegacyServerbound(Class<T> var1, class_9141<class_2540, T> var2);

        public Builder optional();
    }
}

