/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.adventuremodetweaks_common_forge.features;

import com.natamus.adventuremodetweaks_common_forge.config.ConfigHandler;
import com.natamus.adventuremodetweaks_common_forge.util.Util;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.FishingHook;

public class FishingCheck {
    public static boolean shouldStopFishing(Player player) {
        if (!ConfigHandler.preventFishing) {
            return false;
        }
        return Util.isInAdventureMode(player);
    }

    public static boolean shouldBlockEntityHook(FishingHook fishingHook) {
        if (!ConfigHandler.preventFishingRodHookedEntities) {
            return false;
        }
        Player player = FishingCheck.getPlayerOwner(fishingHook);
        if (player == null) {
            return false;
        }
        return Util.isInAdventureMode(player);
    }

    @Nullable
    public static Player getPlayerOwner(FishingHook fishingHook) {
        Entity entity = fishingHook.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player;
        }
        return null;
    }
}

