/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.adventuremodetweaks_common_fabric.events;

import com.natamus.adventuremodetweaks_common_fabric.config.ConfigHandler;
import com.natamus.adventuremodetweaks_common_fabric.features.BoatCheck;
import com.natamus.adventuremodetweaks_common_fabric.features.CowCheck;
import com.natamus.adventuremodetweaks_common_fabric.features.GeneralAttackCheck;
import com.natamus.adventuremodetweaks_common_fabric.features.ItemFrameCheck;
import com.natamus.adventuremodetweaks_common_fabric.features.LeadCheck;
import com.natamus.adventuremodetweaks_common_fabric.features.MinecartCheck;
import com.natamus.adventuremodetweaks_common_fabric.features.PaintingCheck;
import com.natamus.adventuremodetweaks_common_fabric.features.SheepCheck;
import com.natamus.adventuremodetweaks_common_fabric.util.Util;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_3966;

public class EntityEvents {
    public static void onEntityJoin(class_1937 level, class_1297 entity) {
        if (!ConfigHandler.forceSurvivalToAdventureMode) {
            return;
        }
        if (level.field_9236) {
            return;
        }
        if (!(entity instanceof class_3222)) {
            return;
        }
        class_3222 serverPlayer = (class_3222)entity;
        class_1934 gameType = serverPlayer.field_13974.method_14257();
        if (gameType.equals((Object)class_1934.field_9215)) {
            serverPlayer.method_7336(class_1934.field_9216);
        }
    }

    public static boolean onEntityAttack(class_3222 serverPlayer, class_1937 level, class_1297 targetEntity) {
        if (!Util.serverIsInAdventureMode(serverPlayer)) {
            return true;
        }
        if (GeneralAttackCheck.shouldBlockEntityDamage(targetEntity)) {
            return false;
        }
        if (BoatCheck.targetIsBoatAndShouldBeBlocked(targetEntity)) {
            return false;
        }
        if (MinecartCheck.targetIsMinecartAndShouldBeBlocked(targetEntity)) {
            return false;
        }
        if (PaintingCheck.targetIsPaintingAndShouldBeBlocked(targetEntity)) {
            return false;
        }
        if (ItemFrameCheck.targetIsItemFrameAndShouldBeBlocked(targetEntity)) {
            return false;
        }
        return !LeadCheck.entityIsLeashKnotAndShouldBeBlocked(targetEntity);
    }

    public static boolean onEntityInteract(class_1657 player, class_1937 level, class_1268 interactionHand, class_1297 targetEntity, class_3966 hitResult) {
        if (!Util.isInAdventureMode(player)) {
            return true;
        }
        if (ConfigHandler.preventEntityInteraction) {
            return false;
        }
        if (CowCheck.entityIsCowAndMilkingShouldBeBlocked(targetEntity)) {
            return false;
        }
        if (SheepCheck.entityIsSheepAndShearingShouldBeBlocked(targetEntity)) {
            return false;
        }
        if (LeadCheck.entityIsLeashKnotAndShouldBeBlocked(targetEntity)) {
            return false;
        }
        class_1799 handStack = player.method_5998(interactionHand);
        class_1792 handItem = handStack.method_7909();
        return !LeadCheck.itemUsedIsALeadAndShouldBeBlocked(handItem);
    }
}

