/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import com.mojang.datafixers.util.Either;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import org.jetbrains.annotations.Nullable;

public class TileOrEntityTarget {
    private final Either<class_2338, Integer> posOrEntityId;

    private TileOrEntityTarget(Either<class_2338, Integer> either) {
        this.posOrEntityId = either;
    }

    public static TileOrEntityTarget orThrow(Object object) {
        if (object instanceof class_2586) {
            class_2586 be = (class_2586)object;
            return TileOrEntityTarget.of(be);
        }
        if (object instanceof class_1297) {
            class_1297 entity = (class_1297)object;
            return TileOrEntityTarget.of(entity);
        }
        throw new IllegalArgumentException("Object must be a BlockEntity or Entity");
    }

    public static TileOrEntityTarget of(class_2586 be) {
        return new TileOrEntityTarget((Either<class_2338, Integer>)Either.left((Object)be.method_11016()));
    }

    public static TileOrEntityTarget of(class_1297 entity) {
        return new TileOrEntityTarget((Either<class_2338, Integer>)Either.right((Object)entity.method_5628()));
    }

    public void write(class_2540 buf) {
        buf.method_52964(this.posOrEntityId.left().isPresent());
        if (this.posOrEntityId.left().isPresent()) {
            buf.method_10807((class_2338)this.posOrEntityId.left().get());
        } else {
            buf.method_10804(((Integer)this.posOrEntityId.right().get()).intValue());
        }
    }

    public static TileOrEntityTarget read(class_2540 buf) {
        if (buf.readBoolean()) {
            return new TileOrEntityTarget((Either<class_2338, Integer>)Either.left((Object)buf.method_10811()));
        }
        return new TileOrEntityTarget((Either<class_2338, Integer>)Either.right((Object)buf.method_10816()));
    }

    @Nullable
    public Object getTarget(class_1937 level) {
        if (this.posOrEntityId.left().isPresent()) {
            class_2338 pos = (class_2338)this.posOrEntityId.left().get();
            class_2586 be = level.method_8321(pos);
            if (be != null) {
                return be;
            }
            return level.method_8320(pos);
        }
        return level.method_8469(((Integer)this.posOrEntityId.right().get()).intValue());
    }

    public <T extends class_2586> T getBlockEntityOrThrow(class_1937 level, class_2591<T> type) {
        class_2586 be;
        if (this.posOrEntityId.left().isPresent() && (be = type.method_24182((class_1922)level, (class_2338)this.posOrEntityId.left().get())) != null) {
            return (T)be;
        }
        throw new IllegalStateException("No BlockEntity found at " + String.valueOf(this.posOrEntityId.left().orElse(null)));
    }

    public <T extends class_1297> T getEntityOrThrow(class_1937 level, class_1299<T> type) {
        class_1297 entity;
        if (this.posOrEntityId.right().isPresent() && (entity = level.method_8469(((Integer)this.posOrEntityId.right().get()).intValue())) != null && entity.method_5864() == type) {
            return (T)entity;
        }
        throw new IllegalStateException("No Entity found with ID " + String.valueOf(this.posOrEntityId.right().orElse(null)));
    }

    @Nullable
    public <T> T map(class_1937 level, Function<class_2586, T> a, Function<class_1297, T> b) {
        if (this.posOrEntityId.left().isPresent()) {
            class_2586 be = level.method_8321((class_2338)this.posOrEntityId.left().get());
            if (be != null) {
                return a.apply(be);
            }
        } else {
            class_1297 entity = level.method_8469(((Integer)this.posOrEntityId.right().get()).intValue());
            if (entity != null) {
                return b.apply(entity);
            }
        }
        return null;
    }

    @Nullable
    public class_2338 getPos() {
        return this.posOrEntityId.left().orElse(null);
    }

    @Nullable
    public Integer getEntityId() {
        return this.posOrEntityId.right().orElse(null);
    }

    public String toString() {
        return "TileOrEntityTarget{posOrEntityId=" + String.valueOf(this.posOrEntityId) + "}";
    }
}

