/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.screen;

import java.util.List;
import net.fieldb0y.wanna_play_chess.utils.GeometryUtils;
import net.fieldb0y.wanna_play_chess.utils.Utils;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.joml.Vector2f;
import org.joml.Vector2i;

public class ClickableRect {
    public Vector2i[] absoluteVertices = new Vector2i[4];
    public Vector2f[] relativeVertices = new Vector2f[4];
    public int gridX;
    public int gridY;
    public Vector2i offset = new Vector2i(0, 0);
    public final int defWindowWidth;
    public final int defWindowHeight;
    public class_310 client;
    private int color = -16711936;

    public ClickableRect(List<Vector2f> relativeVertices, int gridX, int gridY, int defWindowWidth, int defWindowHeight, int screenHeight) {
        this.defWindowWidth = defWindowWidth;
        this.defWindowHeight = defWindowHeight;
        for (int i = 0; i < 4; ++i) {
            this.relativeVertices[i] = relativeVertices.get(i);
        }
        this.updateVertices(screenHeight);
        this.gridX = gridX;
        this.gridY = gridY;
    }

    public void render(class_332 context) {
        for (int i = 0; i < 4; ++i) {
            Vector2i current = this.absoluteVertices[i];
            Vector2i next = this.absoluteVertices[(i + 1) % 4];
            Utils.drawLine(context, current.x, current.y, next.x, next.y, this.color);
        }
    }

    public void render(class_332 context, int color) {
        for (int i = 0; i < 4; ++i) {
            Vector2i current = this.absoluteVertices[i];
            Vector2i next = this.absoluteVertices[(i + 1) % 4];
            Utils.drawLine(context, current.x, current.y, next.x, next.y, color);
        }
    }

    public boolean isMouseInRect(double mouseX, double mouseY) {
        double[] xCoords = new double[]{this.absoluteVertices[0].x, this.absoluteVertices[1].x, this.absoluteVertices[2].x, this.absoluteVertices[3].x};
        double[] yCoords = new double[]{this.absoluteVertices[0].y, this.absoluteVertices[1].y, this.absoluteVertices[2].y, this.absoluteVertices[3].y};
        return GeometryUtils.isPointInQuadrilateral(mouseX, mouseY, xCoords, yCoords);
    }

    public void setOffset(int x, int y) {
        this.offset.set(x, y);
    }

    public int getOppositeX() {
        return 7 - this.gridX;
    }

    public int getOppositeY() {
        return 7 - this.gridY;
    }

    public void updateVertices(int screenHeight) {
        for (int i = 0; i < 4; ++i) {
            this.absoluteVertices[i] = new Vector2i(this.offset.x + Math.round(this.relativeVertices[i].x * (float)this.defWindowWidth * ((float)screenHeight / (float)this.defWindowHeight)), this.offset.y + Math.round(this.relativeVertices[i].y * (float)screenHeight));
        }
    }

    public void updateVerticesX() {
        for (int i = 0; i < 4; ++i) {
            this.absoluteVertices[i] = new Vector2i(this.offset.x + Math.round(this.relativeVertices[i].x * (float)this.defWindowWidth), this.offset.y + Math.round(this.relativeVertices[i].y * (float)this.defWindowHeight));
        }
    }
}

