/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fieldb0y.wanna_play_chess.chess.renderingStates.ChessRenderingState;
import net.fieldb0y.wanna_play_chess.screen.ClickableRect;
import net.fieldb0y.wanna_play_chess.utils.Utils;
import net.minecraft.class_332;
import org.joml.Vector2f;
import org.joml.Vector2i;

public class ClickableChooser {
    public List<ClickableRect> rects = new ArrayList<ClickableRect>();
    public ChessRenderingState renderingState;
    public int renderX;
    public int renderY;
    public int width;
    public int height;
    public int buttonsCount;
    public boolean active = true;

    public ClickableChooser(int renderX, int renderY, int width, int height, int buttonsCount, ChessRenderingState renderingState) {
        this.renderX = renderX;
        this.renderY = renderY;
        this.width = width;
        this.height = height;
        this.buttonsCount = buttonsCount;
        this.renderingState = renderingState;
        this.createRects();
    }

    private void createRects() {
        this.rects.clear();
        int rectWidth = this.width / this.buttonsCount;
        for (int i = 0; i < this.buttonsCount; ++i) {
            Vector2f cornerPos = Utils.toRelative(new Vector2i(this.renderX + rectWidth * i, this.renderY), 427, 240);
            Vector2f relativeDimensions = Utils.toRelative(new Vector2i(rectWidth, this.height), 427, 240);
            ClickableRect rect = new ClickableRect(List.of(cornerPos, new Vector2f(cornerPos.x + relativeDimensions.x, cornerPos.y), new Vector2f(cornerPos.x + relativeDimensions.x, cornerPos.y + relativeDimensions.y), new Vector2f(cornerPos.x, cornerPos.y + relativeDimensions.y)), i, 0, 427, 240, 240);
            this.rects.add(rect);
        }
    }

    public void render(class_332 context) {
        if (this.active) {
            for (ClickableRect rect : this.rects) {
                rect.render(context);
            }
        }
    }

    public void renderRect(class_332 context, int id, int color) {
        if (this.active) {
            this.rects.get(id).render(context, color);
        }
    }

    public void onScreenResize(boolean setYOffset) {
        int x = this.renderingState.getScreenWidth() / 2 - 213;
        int y = this.renderingState.getScreenHeight() / 2 - 120;
        for (ClickableRect rect : this.rects) {
            rect.setOffset(x, setYOffset ? y : 0);
            rect.updateVerticesX();
        }
    }

    public void setPos(int x, int y) {
        this.renderX = x;
        this.renderY = y;
        for (ClickableRect rect : this.rects) {
            rect.setOffset(x, y);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, Consumer<Integer> executableMethod) {
        if (this.active) {
            for (ClickableRect rect : this.rects) {
                if (!rect.isMouseInRect(mouseX, mouseY)) continue;
                executableMethod.accept(rect.gridX);
                return true;
            }
        }
        return false;
    }

    public int getMouseIntersectedRect(double mouseX, double mouseY) {
        if (this.active) {
            for (ClickableRect rect : this.rects) {
                if (!rect.isMouseInRect(mouseX, mouseY)) continue;
                return rect.gridX;
            }
        }
        return -1;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

