/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.mixin;

import net.fieldb0y.wanna_play_chess.CameraAnimationPlayable;
import net.fieldb0y.wanna_play_chess.block.entity.ChessBoardBlockEntity;
import net.fieldb0y.wanna_play_chess.chess.ChessGrid;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameState;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_4184.class})
public abstract class CameraMixin
implements CameraAnimationPlayable {
    @Unique
    private boolean isAnimationPlaying = false;
    @Unique
    private boolean focusOnBlockEntity = false;
    @Unique
    private class_2338 blockEntityPos;
    @Unique
    private class_243 startPos;
    @Unique
    private float startYaw;
    @Unique
    private float startPitch;
    @Unique
    private class_243 targetPos;
    @Unique
    private float targetYaw;
    @Unique
    private float targetPitch;
    @Shadow
    private class_243 field_18712;
    @Shadow
    private float field_18718;
    @Shadow
    private float field_18717;
    @Unique
    private class_2350 gridDirection;
    @Unique
    private int playerRole;
    @Unique
    private float animationProgress = 0.0f;
    @Unique
    private float animationDuration = 0.5f;
    @Unique
    private long lastUpdateTime = 0L;

    @Shadow
    protected abstract void method_19327(double var1, double var3, double var5);

    @Shadow
    protected abstract void method_19325(float var1, float var2);

    @Inject(method={"update"}, at={@At(value="TAIL")}, cancellable=true)
    private void onUpdate(class_1922 area, class_1297 focusedEntity, boolean thirdPerson, boolean inverseView, float tickDelta, CallbackInfo ci) {
        if (this.focusOnBlockEntity) {
            this.method_19327(this.targetPos.field_1352, this.targetPos.field_1351, this.targetPos.field_1350);
            this.method_19325(this.targetYaw, this.targetPitch);
            ci.cancel();
        }
        if (this.isAnimationPlaying) {
            this.updateCameraPosition();
            this.checkAnimationCompletion();
            ci.cancel();
        }
    }

    @Unique
    private void updateCameraPosition() {
        long currentTime = System.nanoTime();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        float deltaTime = (float)(currentTime - this.lastUpdateTime) / 1.0E9f;
        this.animationProgress += deltaTime;
        this.lastUpdateTime = currentTime;
        float progress = Math.min(this.animationProgress / this.animationDuration, 1.0f);
        float smoothProgress = this.smoothStep(progress);
        class_243 newPos = this.startPos.method_35590(this.targetPos, (double)smoothProgress);
        float newPitch = this.startPitch + (this.targetPitch - this.startPitch) * smoothProgress;
        float newYaw = this.lerpAngle(this.startYaw, this.targetYaw, smoothProgress);
        this.method_19327(newPos.field_1352, newPos.field_1351, newPos.field_1350);
        this.method_19325(newYaw, newPitch);
    }

    @Unique
    private void initializeAnimation() {
        this.startPos = this.field_18712;
        this.startYaw = class_3532.method_15393((float)this.field_18718);
        this.startPitch = class_3532.method_15393((float)this.field_18717);
        this.targetPos = class_243.method_24953((class_2382)this.blockEntityPos).method_1019(this.calculateOffset());
        this.calculateTargetRotation();
    }

    @Unique
    private void calculateTargetRotation() {
        class_243 direction = class_243.method_24953((class_2382)this.blockEntityPos).method_1020(this.targetPos).method_1029();
        double dx = direction.field_1352;
        double dy = direction.field_1351;
        double dz = direction.field_1350;
        float baseYaw = (float)Math.toDegrees(Math.atan2(dz, dx)) + this.calculateYawOffset();
        float directionOffset = this.playerRole == 0 ? this.gridDirection.method_10153().method_10144() : this.gridDirection.method_10144();
        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
        this.targetYaw = class_3532.method_15393((float)(baseYaw + directionOffset));
        this.targetPitch = class_3532.method_15363((float)((float)Math.toDegrees(Math.atan2(-dy, horizontalDistance) * 1.5)), (float)-90.0f, (float)90.0f);
    }

    @Unique
    private float calculateYawOffset() {
        float offset = this.playerRole == 0 ? (this.gridDirection.equals((Object)class_2350.field_11034) ? 180.0f : (this.gridDirection.equals((Object)class_2350.field_11035) ? 90.0f : (this.gridDirection.equals((Object)class_2350.field_11043) ? -90.0f : 0.0f))) : (this.gridDirection.equals((Object)class_2350.field_11034) ? 0.0f : (this.gridDirection.equals((Object)class_2350.field_11035) ? -90.0f : (this.gridDirection.equals((Object)class_2350.field_11043) ? 90.0f : -180.0f)));
        return offset;
    }

    @Unique
    private class_243 calculateOffset() {
        float z;
        float x;
        float y = 0.3f;
        if (this.playerRole == 0) {
            float f = this.gridDirection == class_2350.field_11034 ? -0.3f : (x = this.gridDirection == class_2350.field_11039 ? 0.3f : 0.0f);
            z = this.gridDirection == class_2350.field_11043 ? 0.3f : (this.gridDirection == class_2350.field_11035 ? -0.3f : 0.0f);
        } else {
            float f = this.gridDirection == class_2350.field_11034 ? 0.3f : (x = this.gridDirection == class_2350.field_11039 ? -0.3f : 0.0f);
            z = this.gridDirection == class_2350.field_11043 ? -0.3f : (this.gridDirection == class_2350.field_11035 ? 0.3f : 0.0f);
        }
        return new class_243((double)x, (double)y, (double)z);
    }

    @Unique
    private float lerpAngle(float start, float end, float progress) {
        start = class_3532.method_15393((float)start);
        float difference = (end = class_3532.method_15393((float)end)) - start;
        if (difference > 180.0f) {
            difference -= 360.0f;
        } else if (difference < -180.0f) {
            difference += 360.0f;
        }
        return class_3532.method_15393((float)(start + difference * progress));
    }

    @Unique
    private float smoothStep(float t) {
        return t * t * (3.0f - 2.0f * t);
    }

    @Unique
    private void checkAnimationCompletion() {
        if (this.animationProgress >= this.animationDuration) {
            this.isAnimationPlaying = false;
            this.animationProgress = 0.0f;
            this.lastUpdateTime = 0L;
            this.focusOnBlockEntity = true;
        }
    }

    @Unique
    public void playAnimation(ChessBoardBlockEntity blockEntity) {
        this.blockEntityPos = blockEntity.method_11016();
        this.isAnimationPlaying = true;
        this.animationProgress = 0.0f;
        this.lastUpdateTime = System.nanoTime();
        this.initializeAnimation();
    }

    @Override
    public void focusOnBlockEntity(ChessBoardBlockEntity blockEntity, class_1657 player) {
        ChessGameState chessGameState = (ChessGameState)blockEntity.states.get(1);
        ChessGrid chessGrid = chessGameState.getGrid();
        this.playerRole = chessGameState.getPlayers()[0].compareTo(player.method_5667()) == 0 ? 0 : 1;
        this.gridDirection = chessGrid.getDirection();
        this.playAnimation(blockEntity);
    }

    @Override
    public void focusOnBlockEntity(ChessBoardBlockEntity blockEntity, int playerRole) {
        ChessGameState chessGameState = (ChessGameState)blockEntity.states.get(1);
        ChessGrid chessGrid = chessGameState.getGrid();
        this.playerRole = playerRole;
        this.gridDirection = chessGrid.getDirection();
        this.playAnimation(blockEntity);
    }

    @Override
    public void stopFocusing() {
        this.focusOnBlockEntity = false;
        this.isAnimationPlaying = false;
    }

    @Override
    public boolean isCameraFocused() {
        return this.focusOnBlockEntity;
    }
}

