/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.item.custom;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fieldb0y.wanna_play_chess.block.entity.ChessBoardBlockEntity;
import net.fieldb0y.wanna_play_chess.chess.ChessGrid;
import net.fieldb0y.wanna_play_chess.chess.utils.ChessPieces;
import net.fieldb0y.wanna_play_chess.item.ModComponents;
import net.fieldb0y.wanna_play_chess.item.ModItems;
import net.fieldb0y.wanna_play_chess.item.custom.ChessPiece;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_437;

public class BoxForPieces
extends class_1792 {
    public static final class_2561 SET_ALREADY_INSERTED_MESSAGE = class_2561.method_43471((String)"wanna_play_chess.box_for_pieces.set_already_inserted");
    public static final class_2561 BOX_IS_NOT_FULL_MESSAGE = class_2561.method_43471((String)"wanna_play_chess.box_for_pieces.box_is_not_full");
    public static final class_2561 SUCCESSFUL_SET_INSERT = class_2561.method_43471((String)"wanna_play_chess.box_for_pieces.successful_set_insert");
    public static final class_2561 BOX_IS_EMPTY_TOOLTIP = class_2561.method_43471((String)"wanna_play_chess.box_for_pieces.box_is_empty_tooltip");
    public static final class_2561 EMPTY_BOX_SHIFT_TOOLTIP = class_2561.method_43471((String)"wanna_play_chess.box_for_pieces.empty_box_shift_tooltip");
    public static final class_2561 BOX_SHIFT_TOOLTIP = class_2561.method_43471((String)"wanna_play_chess.box_for_pieces.box_shift_tooltip");
    public static final class_2561 PRESS_SHIFT_TOOLTIP = class_2561.method_43471((String)"wanna_play_chess.box_for_pieces.press_shift_tooltip");
    private static final int PAWNS_MAX_COUNT = 8;
    private static final int BISHOPS_KNIGHTS_ROOKS_MAX_COUNT = 2;
    private static final int DEFAULT_MAX_COUNT = 1;

    public BoxForPieces(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7884(class_1838 context) {
        class_2586 class_25862;
        class_1937 world = context.method_8045();
        class_1657 player = context.method_8036();
        if (!world.method_8608() && (class_25862 = world.method_8321(context.method_8037())) instanceof ChessBoardBlockEntity) {
            ChessBoardBlockEntity blockEntity = (ChessBoardBlockEntity)class_25862;
            class_1799 stack = player.method_5998(context.method_20287());
            if (!player.method_5715()) {
                if (BoxForPieces.isFull(stack)) {
                    int role = BoxForPieces.getPiecesInBoxRole(stack);
                    if (!blockEntity.isSetInserted(role)) {
                        blockEntity.insertPiecesSet(role);
                        if (!player.method_6047().equals(stack)) {
                            player.method_31548().method_5441(40);
                        } else {
                            player.method_31548().method_5441(player.method_31548().field_7545);
                        }
                        return class_1269.field_5812;
                    }
                    player.method_43496((class_2561)SET_ALREADY_INSERTED_MESSAGE.method_27661().method_27692(class_124.field_1061));
                } else {
                    player.method_43496((class_2561)BOX_IS_NOT_FULL_MESSAGE.method_27661().method_27692(class_124.field_1061));
                }
            }
        }
        return super.method_7884(context);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        if (!world.method_8608()) {
            class_1799 stack = player.method_5998(hand);
            class_1799 otherHandStack = player.method_5998(hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808);
            HashMap<Integer, Integer> piecesInBox = new HashMap<Integer, Integer>((Map)stack.method_57825(ModComponents.PIECES_IN_BOX_COMPONENT, Collections.emptyMap()));
            if (player.method_5715()) {
                Iterator iterator = piecesInBox.keySet().iterator();
                while (iterator.hasNext()) {
                    int pieceId = (Integer)iterator.next();
                    ChessPiece piece = ChessGrid.getPieceById(pieceId);
                    player.method_7270(ChessGrid.getPieceRole(pieceId) == 0 ? piece.getWhiteStack().method_46651(((Integer)piecesInBox.get(pieceId)).intValue()) : piece.getBlackStack().method_46651(((Integer)piecesInBox.get(pieceId)).intValue()));
                }
                piecesInBox.clear();
                piecesInBox = new HashMap();
                stack.method_57379(ModComponents.PIECES_IN_BOX_COMPONENT, piecesInBox);
            } else {
                class_1792 pieceId = otherHandStack.method_7909();
                if (pieceId instanceof ChessPiece) {
                    ChessPiece piece = (ChessPiece)pieceId;
                    int pieceId2 = ChessPieces.getId(piece);
                    int stackCount = otherHandStack.method_7947();
                    if (piecesInBox.containsKey(pieceId2)) {
                        int countToPut = this.getCountToPut(pieceId2, (Integer)piecesInBox.get(pieceId2), stackCount);
                        if (countToPut > 0) {
                            piecesInBox.put(pieceId2, (Integer)piecesInBox.get(pieceId2) + countToPut);
                            otherHandStack.method_7934(countToPut);
                        }
                    } else {
                        int neededRole = piecesInBox.isEmpty() ? -1 : ChessGrid.getPieceRole((Integer)piecesInBox.keySet().toArray()[0]);
                        int countToPut = this.getCountToPut(pieceId2, 0, stackCount);
                        if (countToPut > 0 && (neededRole == -1 || ChessGrid.getPieceRole(pieceId2) == neededRole)) {
                            piecesInBox.put(pieceId2, countToPut);
                            otherHandStack.method_7934(countToPut);
                        }
                    }
                }
                stack.method_57379(ModComponents.PIECES_IN_BOX_COMPONENT, piecesInBox);
            }
        }
        return class_1271.method_22428((Object)player.method_5998(hand));
    }

    private int getCountToPut(int pieceId, int countOfPiecesInBox, int otherHandStackCount) {
        int countToPut = 1 - countOfPiecesInBox;
        if (pieceId == ChessPieces.WHITE_PAWN.id || pieceId == ChessPieces.BLACK_PAWN.id) {
            countToPut = 8 - countOfPiecesInBox;
        }
        if (pieceId == ChessPieces.WHITE_KNIGHT.id || pieceId == ChessPieces.BLACK_KNIGHT.id || pieceId == ChessPieces.WHITE_BISHOP.id || pieceId == ChessPieces.BLACK_BISHOP.id || pieceId == ChessPieces.WHITE_ROOK.id || pieceId == ChessPieces.BLACK_ROOK.id) {
            countToPut = 2 - countOfPiecesInBox;
        }
        return Math.min(countToPut, otherHandStackCount);
    }

    public static boolean isFull(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof BoxForPieces) {
            BoxForPieces item = (BoxForPieces)class_17922;
            HashMap piecesInBox = new HashMap((Map)stack.method_57825(ModComponents.PIECES_IN_BOX_COMPONENT, Collections.emptyMap()));
            if (piecesInBox.size() < 6) {
                return false;
            }
            int role = BoxForPieces.getPiecesInBoxRole(stack);
            int indexOffset = role == 0 ? 0 : 6;
            return (Integer)piecesInBox.get(ChessPieces.WHITE_PAWN.id + indexOffset) >= 8 && (Integer)piecesInBox.get(ChessPieces.WHITE_KNIGHT.id + indexOffset) >= 2 && (Integer)piecesInBox.get(ChessPieces.WHITE_BISHOP.id + indexOffset) >= 2 && (Integer)piecesInBox.get(ChessPieces.WHITE_ROOK.id + indexOffset) >= 2 && (Integer)piecesInBox.get(ChessPieces.WHITE_QUEEN.id + indexOffset) >= 1 && (Integer)piecesInBox.get(ChessPieces.WHITE_KING.id + indexOffset) >= 1;
        }
        return false;
    }

    public boolean isEnoughPieces(int pieceId, int count) {
        return BoxForPieces.getFullBoxMap(ChessGrid.getPieceRole(pieceId)).get(pieceId) <= count;
    }

    public static class_1799 getFullBoxStack(int role) {
        class_1799 stack = ModItems.BOX_FOR_CHESS_PIECES.method_7854();
        stack.method_57379(ModComponents.PIECES_IN_BOX_COMPONENT, BoxForPieces.getFullBoxMap(role));
        return stack;
    }

    public static Map<Integer, Integer> getFullBoxMap(int role) {
        int indexOffset = role == 0 ? 0 : 6;
        return Map.of(ChessPieces.WHITE_PAWN.id + indexOffset, 8, ChessPieces.WHITE_KNIGHT.id + indexOffset, 2, ChessPieces.WHITE_BISHOP.id + indexOffset, 2, ChessPieces.WHITE_ROOK.id + indexOffset, 2, ChessPieces.WHITE_QUEEN.id + indexOffset, 1, ChessPieces.WHITE_KING.id + indexOffset, 1);
    }

    public static int getPiecesInBoxRole(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof BoxForPieces) {
            BoxForPieces item = (BoxForPieces)class_17922;
            HashMap piecesInBox = new HashMap((Map)stack.method_57825(ModComponents.PIECES_IN_BOX_COMPONENT, Collections.emptyMap()));
            if (piecesInBox.isEmpty()) {
                return -1;
            }
            return ChessGrid.getPieceRole((Integer)piecesInBox.keySet().toArray()[0]);
        }
        return -1;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        Map pieces = (Map)stack.method_57825(ModComponents.PIECES_IN_BOX_COMPONENT, Collections.emptyMap());
        if (pieces.isEmpty()) {
            tooltip.add((class_2561)BOX_IS_EMPTY_TOOLTIP.method_27661().method_27692(class_124.field_1061));
        }
        if (class_437.method_25442()) {
            if (!pieces.isEmpty()) {
                pieces.forEach((id, count) -> tooltip.add((class_2561)class_2561.method_43471((String)ChessGrid.getPieceById(id).method_7876()).method_27692(class_124.field_1080).method_27693(": " + (this.isEnoughPieces((int)id, (int)count) ? "\u00a7a" : "\u00a7c") + count + "\u00a7r")));
            } else {
                tooltip.add((class_2561)EMPTY_BOX_SHIFT_TOOLTIP.method_27661().method_27692(class_124.field_1063));
            }
            tooltip.add((class_2561)BOX_SHIFT_TOOLTIP.method_27661().method_27692(class_124.field_1063));
        } else {
            tooltip.add(PRESS_SHIFT_TOOLTIP);
        }
    }
}

