/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.chess.renderingStates;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fieldb0y.wanna_play_chess.CheckBoxAccessor;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessLobbyState;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessState;
import net.fieldb0y.wanna_play_chess.chess.renderingStates.ChessGameRenderingState;
import net.fieldb0y.wanna_play_chess.chess.renderingStates.ChessRenderingState;
import net.fieldb0y.wanna_play_chess.chess.renderingStates.RenderingProperties;
import net.fieldb0y.wanna_play_chess.entity.ModEntities;
import net.fieldb0y.wanna_play_chess.entity.custom.PlayerCopyEntity;
import net.fieldb0y.wanna_play_chess.mixin.HandledScreenAccessor;
import net.fieldb0y.wanna_play_chess.mixin.ScreenAccessor;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.JoinLobbyButtonPayload;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.LeaveLobbyPayload;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.LobbyFirstPlayerRolePayload;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.LobbyGameTimePayload;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.LobbyNoTimeControlCheckboxPayload;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.StartGameButtonPayload;
import net.fieldb0y.wanna_play_chess.screen.ChessBoardScreen;
import net.fieldb0y.wanna_play_chess.screen.ClickableChooser;
import net.fieldb0y.wanna_play_chess.screen.NumericTextField;
import net.fieldb0y.wanna_play_chess.utils.GameState;
import net.fieldb0y.wanna_play_chess.utils.Utils;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_4286;
import net.minecraft.class_490;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import net.minecraft.class_8710;
import org.joml.Vector4i;

public class ChessLobbyRenderingState
extends ChessRenderingState {
    public static final class_2561 JOIN_LOBBY_BUTTON_TEXT = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.join_lobby_button");
    public static final class_2561 LEAVE_LOBBY_BUTTON_TEXT = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.leave_lobby_button");
    public static final class_2561 START_GAME_BUTTON_TEXT = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.start_game_button");
    public static final class_2561 NO_TIME_CONTROL_CHECKBOX_TEXT = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.no_time_control_checkbox");
    public static final class_2561 GAME_TIME_TEXT = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.game_time_text");
    public static final class_2561 SEC_TEXT = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.sec_text");
    public static final class_2561 MIN_TEXT = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.min_text");
    public static final class_2561 FIRST_PLAYER_ROLE_TEXT = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.first_player_role_text");
    public static final class_2561 SINGLEPLAYER_TEXT = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.singleplayer_text").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067, class_124.field_1056});
    public static final class_2561 MULTIPLAYER_TEXT = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.multiplayer_text").method_27695(new class_124[]{class_124.field_1065, class_124.field_1067, class_124.field_1056});
    public static final class_2561 START_WORD = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.start_word");
    public static final class_2561 GAME_WORD = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.game_word");
    public static final class_2561 WHITE_SET_ISNT_INSERTED_TEXT = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.white_set_isnt_inserted_text");
    public static final class_2561 BLACK_SET_ISNT_INSERTED_TEXT = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.black_set_isnt_inserted_text");
    public static final class_2561 NEITHER_SET_INSERTED_TEXT = class_2561.method_43471((String)"wanna_play_chess.lobby_rs.neither_set_inserted_text");
    public static final int FIRST = 0;
    public static final int SECOND = 1;
    private static final class_2960 CHESS_LOBBY = class_2960.method_60655((String)"wanna_play_chess", (String)"textures/gui/chess_lobby.png");
    private static final class_2960 WHITE_BLACK_KING_ICON = class_2960.method_60655((String)"wanna_play_chess", (String)"textures/gui/role_chooser.png");
    private PlayerCopyEntity[] playerCopies = new PlayerCopyEntity[2];
    public int firstPlayerRole;
    private class_4185 joinLobbyButton;
    private class_4185 leaveLobbyButton;
    private class_4185 startGameButton;
    private class_342 timeInMinsTextField;
    private class_342 timeInSecTextField;
    private class_4286 noTimeControlCheckbox;
    private ClickableChooser roleClickableChooser;
    private int gameTimeInSec = 0;

    public ChessLobbyRenderingState(ChessState serverState, ChessBoardScreen screen) {
        super(serverState, screen, new RenderingProperties(true, false));
        this.playerCopies[0] = (PlayerCopyEntity)ModEntities.PLAYER_COPY.method_5883(this.blockEntity.method_10997());
        this.playerCopies[1] = (PlayerCopyEntity)ModEntities.PLAYER_COPY.method_5883(this.blockEntity.method_10997());
        this.playerCopies[0].idleAnimationState.method_41322(this.playerCopies[0].field_6012);
        this.playerCopies[1].idleAnimationState.method_41322(this.playerCopies[1].field_6012);
    }

    @Override
    public void createWidgets(ChessBoardScreen screen) {
        HandledScreenAccessor accessor = (HandledScreenAccessor)((Object)screen);
        int centerX = this.getScreenWidth() / 2;
        int centerY = this.getScreenHeight() / 2;
        this.joinLobbyButton = class_4185.method_46430((class_2561)JOIN_LOBBY_BUTTON_TEXT, button -> ClientPlayNetworking.send((class_8710)new JoinLobbyButtonPayload(this.blockEntity.method_11016()))).method_46434(accessor.getX() - 40, accessor.getY() + 160, 70, 25).method_46431();
        this.leaveLobbyButton = class_4185.method_46430((class_2561)LEAVE_LOBBY_BUTTON_TEXT, button -> ClientPlayNetworking.send((class_8710)new LeaveLobbyPayload(this.blockEntity.method_11016()))).method_46434(accessor.getX() + 40, accessor.getY() + 160, 70, 25).method_46431();
        this.startGameButton = class_4185.method_46430((class_2561)START_GAME_BUTTON_TEXT, button -> ClientPlayNetworking.send((class_8710)new StartGameButtonPayload(this.blockEntity.method_11016()))).method_46434(accessor.getX() + 130, accessor.getY() + 160, 90, 25).method_46431();
        this.timeInMinsTextField = new NumericTextField(((ScreenAccessor)((Object)screen)).getTextRenderer(), centerX - 30, centerY - 50, 30, 13, (class_2561)class_2561.method_43470((String)""));
        this.timeInSecTextField = new NumericTextField(((ScreenAccessor)((Object)screen)).getTextRenderer(), centerX + 30, centerY - 50, 30, 13, (class_2561)class_2561.method_43470((String)""));
        this.timeInMinsTextField.method_1880(3);
        this.setGameTimeTextFields(((ChessLobbyState)this.serverState).gameTimeInSec);
        this.noTimeControlCheckbox = class_4286.method_54787((class_2561)NO_TIME_CONTROL_CHECKBOX_TEXT, (class_327)((ScreenAccessor)((Object)screen)).getTextRenderer()).method_54789(centerX - 50, centerY - 32).method_54794(((ChessLobbyState)this.serverState).noTimeControl).method_54791((checkbox, checked) -> ClientPlayNetworking.send((class_8710)new LobbyNoTimeControlCheckboxPayload(this.blockEntity.method_11016(), checked))).method_54788();
        this.roleClickableChooser = new ClickableChooser(162, 128, 105, 34, 3, this);
        this.roleClickableChooser.onScreenResize(true);
        this.firstPlayerRole = ((ChessLobbyState)this.serverState).firstPlayerRole;
        ((ScreenAccessor)((Object)screen)).addWidget(this.joinLobbyButton);
        ((ScreenAccessor)((Object)screen)).addWidget(this.leaveLobbyButton);
        ((ScreenAccessor)((Object)screen)).addWidget(this.startGameButton);
        ((ScreenAccessor)((Object)screen)).addWidget(this.timeInMinsTextField);
        ((ScreenAccessor)((Object)screen)).addWidget(this.timeInSecTextField);
        ((ScreenAccessor)((Object)screen)).addWidget(this.noTimeControlCheckbox);
    }

    @Override
    public void onScreenResize(int width, int height) {
        this.roleClickableChooser.onScreenResize(true);
    }

    @Override
    public void afterSwitch() {
        this.joinLobbyButton.field_22764 = false;
        this.leaveLobbyButton.field_22764 = false;
        this.startGameButton.field_22764 = false;
        this.timeInSecTextField.field_22764 = false;
        this.timeInMinsTextField.field_22764 = false;
        this.noTimeControlCheckbox.field_22764 = false;
        this.screen.renderingGameStates.get(1).createWidgets(this.screen);
        ((ChessGameRenderingState)this.screen.renderingGameStates.get(1)).init();
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button, ChessBoardScreen screen) {
        this.roleClickableChooser.mouseClicked(mouseX, mouseY, this::chooseFirstPlayerRole);
        return super.mouseClicked(mouseX, mouseY, button, screen);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        ChessLobbyState chessLobbyState = (ChessLobbyState)this.serverState;
        ScreenAccessor accessor = (ScreenAccessor)((Object)this.screen);
        class_327 textRenderer = accessor.getTextRenderer();
        this.manageTimeTextFields();
        ((CheckBoxAccessor)this.noTimeControlCheckbox).setChecked(chessLobbyState.noTimeControl);
        if (chessLobbyState.isPlayerInLobby(this.client.field_1724.method_5667())) {
            if (!(this.blockEntity.blackSetInserted && this.blockEntity.whiteSetInsereted || this.client.field_1724.method_7337())) {
                if (!this.blockEntity.blackSetInserted && !this.blockEntity.whiteSetInsereted) {
                    this.startGameButton.method_47400(class_7919.method_47407((class_2561)NEITHER_SET_INSERTED_TEXT));
                } else if (!this.blockEntity.whiteSetInsereted) {
                    this.startGameButton.method_47400(class_7919.method_47407((class_2561)WHITE_SET_ISNT_INSERTED_TEXT));
                } else {
                    this.startGameButton.method_47400(class_7919.method_47407((class_2561)BLACK_SET_ISNT_INSERTED_TEXT));
                }
                this.startGameButton.field_22763 = false;
            } else if (this.blockEntity.getGameState().equals((Object)GameState.NOT_READY_TO_PLAY)) {
                this.startGameButton.field_22763 = false;
                if (this.blockEntity.blackSetInserted && this.blockEntity.whiteSetInsereted) {
                    this.startGameButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43473()));
                }
            } else {
                this.startGameButton.method_47400(class_7919.method_47407((class_2561)START_WORD.method_27661().method_27692(class_124.field_1056).method_27693(" ").method_10852(this.blockEntity.getGameState().equals((Object)GameState.READY_FOR_SINGLEPLAYER_GAME) ? SINGLEPLAYER_TEXT : MULTIPLAYER_TEXT).method_27693(" ").method_10852(GAME_WORD)));
                this.startGameButton.field_22763 = true;
            }
        } else {
            this.startGameButton.field_22763 = false;
        }
        int centerX = this.getScreenWidth() / 2;
        int centerY = this.getScreenHeight() / 2;
        this.renderPlayers(context, mouseX, mouseY);
        this.renderRoles(context, mouseX, mouseY);
        this.renderPlayerNames(context, textRenderer, chessLobbyState.getPlayerInLobby(0), chessLobbyState.getPlayerInLobby(1));
        context.method_51439(textRenderer, GAME_TIME_TEXT, centerX - textRenderer.method_27525((class_5348)GAME_TIME_TEXT) / 2, centerY - 65, -4539718, true);
        context.method_51439(textRenderer, MIN_TEXT, centerX - 50, centerY - 47, -2142128, false);
        context.method_51439(textRenderer, SEC_TEXT, centerX + 5, centerY - 47, -2142128, false);
        context.method_51439(textRenderer, FIRST_PLAYER_ROLE_TEXT, centerX - textRenderer.method_27525((class_5348)FIRST_PLAYER_ROLE_TEXT) / 2 + 2, centerY - 5, -4539718, true);
    }

    @Override
    public void drawBackground(class_332 context, float delta, int mouseX, int mouseY) {
        int x = this.getScreenWidth() / 2 - 128 - 11;
        int y = this.getScreenHeight() / 2 - 128 + 15;
        int width = Math.round(332.8f);
        int height = Math.round(332.8f);
        context.method_25290(CHESS_LOBBY, x, y, 0.0f, 0.0f, width, height, width, height);
    }

    public void manageTimeTextFields() {
        int mins = 0;
        int secs = 0;
        try {
            mins = this.timeInMinsTextField.method_1882().isEmpty() ? 0 : Integer.parseInt(this.timeInMinsTextField.method_1882());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            secs = this.timeInSecTextField.method_1882().isEmpty() ? 0 : Integer.parseInt(this.timeInSecTextField.method_1882());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        int time = mins * 60 + secs;
        if (time != this.gameTimeInSec) {
            ClientPlayNetworking.send((class_8710)new LobbyGameTimePayload(this.blockEntity.method_11016(), time));
            this.gameTimeInSec = time;
        }
    }

    public void setGameTimeTextFields(int timeInSec) {
        this.timeInMinsTextField.method_1852(String.valueOf((int)Math.floor((double)timeInSec / 60.0)));
        this.timeInSecTextField.method_1852(String.valueOf(timeInSec % 60));
    }

    private void renderPlayers(class_332 context, int mouseX, int mouseY) {
        HandledScreenAccessor accessor = (HandledScreenAccessor)((Object)this.screen);
        float fixedMouseY = (float)(this.screen.field_22790 - accessor.getBackgroundHeight()) / 2.0f + Math.clamp((float)mouseY / 2.0f, 55.0f, 105.0f) + 10.0f;
        class_1657 player1 = ((ChessLobbyState)this.getServerState()).getPlayerInLobby(0);
        class_1657 player2 = ((ChessLobbyState)this.getServerState()).getPlayerInLobby(1);
        this.playerCopies[0].setSkin(player1);
        this.playerCopies[1].setSkin(player2);
        class_490.method_2486((class_332)context, (int)(accessor.getX() - 53), (int)(accessor.getY() - 30), (int)(accessor.getX() + 25), (int)(accessor.getY() + 150), (int)45, (float)0.0625f, (float)mouseX, (float)fixedMouseY, (class_1309)this.playerCopies[0]);
        class_490.method_2486((class_332)context, (int)(accessor.getX() + 92), (int)(accessor.getY() - 30), (int)(accessor.getX() + 295), (int)(accessor.getY() + 150), (int)45, (float)0.0625f, (float)mouseX, (float)fixedMouseY, (class_1309)this.playerCopies[1]);
    }

    private void renderPlayerNames(class_332 context, class_327 textRenderer, class_1657 firstPlayer, class_1657 secondPlayer) {
        int textFrameCenterX;
        int textWidth;
        class_2561 text;
        int centerX = this.getScreenWidth() / 2;
        int centerY = this.getScreenHeight() / 2;
        if (firstPlayer != null) {
            text = firstPlayer.method_5476();
            textWidth = textRenderer.method_27525((class_5348)text);
            textFrameCenterX = centerX - 87;
            context.method_51439(textRenderer, text, textFrameCenterX - textWidth / 2, centerY + 53, -16711936, false);
        }
        if (secondPlayer != null) {
            text = secondPlayer.method_5476();
            textWidth = textRenderer.method_27525((class_5348)text);
            textFrameCenterX = centerX + 90;
            context.method_51439(textRenderer, text, textFrameCenterX - textWidth / 2, centerY + 53, -16711936, false);
        }
    }

    private void renderRoles(class_332 context, int mouseX, int mouseY) {
        int centerX = this.getScreenWidth() / 2;
        int centerY = this.getScreenHeight() / 2;
        this.firstPlayerRole = ((ChessLobbyState)this.serverState).firstPlayerRole;
        context.method_25290(WHITE_BLACK_KING_ICON, centerX - 51 + 2, centerY + 10, 0.0f, 0.0f, 102, 31, 102, 31);
        switch (this.firstPlayerRole) {
            case 0: {
                this.roleClickableChooser.renderRect(context, 0, -4539718);
                break;
            }
            case 1: {
                this.roleClickableChooser.renderRect(context, 2, -4539718);
                break;
            }
            case 2: {
                this.roleClickableChooser.renderRect(context, 1, -4539718);
            }
        }
        int intersectedRect = this.roleClickableChooser.getMouseIntersectedRect(mouseX, mouseY);
        switch (intersectedRect) {
            case 0: {
                Utils.advancedFill(context, centerX - 50, centerY + 9, centerX - 16, centerY + 42, new Vector4i(1, 1, 1, 80));
                break;
            }
            case 1: {
                Utils.advancedFill(context, centerX - 15, centerY + 9, centerX + 19, centerY + 42, new Vector4i(1, 1, 1, 80));
                break;
            }
            case 2: {
                Utils.advancedFill(context, centerX + 20, centerY + 9, centerX + 55, centerY + 42, new Vector4i(1, 1, 1, 80));
            }
        }
    }

    private void chooseFirstPlayerRole(int clickedRectId) {
        switch (clickedRectId) {
            case 0: {
                this.firstPlayerRole = 0;
                break;
            }
            case 1: {
                this.firstPlayerRole = 2;
                break;
            }
            case 2: {
                this.firstPlayerRole = 1;
            }
        }
        ClientPlayNetworking.send((class_8710)new LobbyFirstPlayerRolePayload(this.blockEntity.method_11016(), this.firstPlayerRole));
    }
}

