/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.chess.renderingStates;

import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fieldb0y.wanna_play_chess.CameraAnimationPlayable;
import net.fieldb0y.wanna_play_chess.chess.ChessGrid;
import net.fieldb0y.wanna_play_chess.chess.PiecesData;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameState;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessState;
import net.fieldb0y.wanna_play_chess.chess.renderingStates.ChessRenderingState;
import net.fieldb0y.wanna_play_chess.chess.renderingStates.RenderingProperties;
import net.fieldb0y.wanna_play_chess.chess.utils.ChessPieces;
import net.fieldb0y.wanna_play_chess.mixin.ScreenAccessor;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.DrawOfferButtonPayload;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.NoButtonPayload;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.ResignButtonPayload;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.TurnPawnIntoPayload;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.YesButtonPayload;
import net.fieldb0y.wanna_play_chess.screen.ChessBoardScreen;
import net.fieldb0y.wanna_play_chess.screen.ClickableChooser;
import net.fieldb0y.wanna_play_chess.screen.ClickableGrid;
import net.fieldb0y.wanna_play_chess.utils.Utils;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_5348;
import net.minecraft.class_8710;
import net.minecraft.class_9296;
import net.minecraft.class_9334;
import org.joml.Vector2i;
import org.joml.Vector4i;

public class ChessGameRenderingState
extends ChessRenderingState {
    public static final int DEF_WINDOW_WIDTH = 427;
    public static final int DEF_WINDOW_HEIGHT = 240;
    private static final class_2960 PIECES_ATLAS = class_2960.method_60655((String)"wanna_play_chess", (String)"textures/gui/chess_pieces_atlas.png");
    private static final class_2960 PIECES_CHOOSER_BG = class_2960.method_60655((String)"wanna_play_chess", (String)"textures/gui/pieces_chooser_bg.png");
    private static final class_2960 CHESS_GAME_TEXTURE = class_2960.method_60655((String)"wanna_play_chess", (String)"textures/gui/chess_game_stats.png");
    public static final class_2561 DRAW_BUTTON_TEXT = class_2561.method_43471((String)"wanna_play_chess.game_rs.draw_button_text");
    public static final class_2561 RESIGN_BUTTON_TEXT = class_2561.method_43471((String)"wanna_play_chess.game_rs.resign_button_text");
    public static final class_2561 RESIGN_TEXT = class_2561.method_43471((String)"wanna_play_chess.game_rs.resign_text");
    public static final class_2561 DRAW_TEXT = class_2561.method_43471((String)"wanna_play_chess.game_rs.draw_text");
    public class_4185 offerDrawButton;
    public class_4185 resignButton;
    public class_4185 yesButton;
    public class_4185 noButton;
    private class_1657 player;
    public ClickableGrid clickableGrid;
    private ClickableChooser pieceChooser;
    private float confirmationWindowY = -39.0f;
    private float piecesChooserY = -49.0f;
    private float gameStatsY = -87.0f;
    private int whiteTimeLeftInSec = -1;
    private int blackTimeLeftInSec = -1;
    float whiteSkullScale = 1.0f;
    float blackSkullScale = 1.0f;
    float maxSkullScale = 1.5f;

    public ChessGameRenderingState(ChessState serverState, ChessBoardScreen screen) {
        super(serverState, screen, new RenderingProperties(false, false));
        ChessGameState gameState = (ChessGameState)serverState;
        this.player = this.client.field_1724;
        this.focusCamera();
        this.whiteTimeLeftInSec = gameState.whiteTimeLeft;
        this.blackTimeLeftInSec = gameState.blackTimeLeft;
        if (serverState.shouldUse()) {
            this.init();
        }
    }

    public void init() {
        this.clickableGrid = new ClickableGrid(this);
        this.clickableGrid.onScreenResize();
        this.pieceChooser = new ClickableChooser(148, 10, 135, 30, 4, this);
        this.pieceChooser.setActive(false);
    }

    @Override
    public void createWidgets(ChessBoardScreen screen) {
        this.pieceChooser = new ClickableChooser(148, 10, 135, 30, 4, this);
        this.pieceChooser.onScreenResize(false);
        this.offerDrawButton = class_4185.method_46430((class_2561)DRAW_BUTTON_TEXT, button -> ClientPlayNetworking.send((class_8710)new DrawOfferButtonPayload(this.blockEntity.method_11016(), this.getPlayerRole()))).method_46434(this.getScreenWidth() - 88, 59, 40, 18).method_46431();
        this.resignButton = class_4185.method_46430((class_2561)RESIGN_BUTTON_TEXT, button -> ClientPlayNetworking.send((class_8710)new ResignButtonPayload(this.blockEntity.method_11016(), this.getPlayerRole()))).method_46434(this.getScreenWidth() - 45, 59, 40, 18).method_46431();
        this.yesButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Yes"), button -> ClientPlayNetworking.send((class_8710)new YesButtonPayload(this.blockEntity.method_11016()))).method_46434(this.getScreenWidth() / 2 - 50, 18, 40, 13).method_46431();
        this.noButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"No"), button -> ClientPlayNetworking.send((class_8710)new NoButtonPayload(this.blockEntity.method_11016()))).method_46434(this.getScreenWidth() / 2 + 10, 18, 40, 13).method_46431();
        ((ScreenAccessor)((Object)screen)).addWidget(this.offerDrawButton);
        ((ScreenAccessor)((Object)screen)).addWidget(this.resignButton);
        ((ScreenAccessor)((Object)screen)).addWidget(this.yesButton);
        ((ScreenAccessor)((Object)screen)).addWidget(this.noButton);
    }

    @Override
    public void render(class_332 context, int mouseX, int mouseY, float delta) {
        ChessGameState chessGameState = (ChessGameState)this.serverState;
        this.renderChessGameStats(context, delta);
        Vector2i pawnCell = chessGameState.findPieceCellWithTag(PiecesData.DataTag.SHOULD_TURN);
        this.pieceChooser.setActive(!pawnCell.equals(-1, -1) && (chessGameState.isSingleplayer || ChessGrid.getPieceRole(chessGameState.getGrid().safeGetPieceId(pawnCell.x, pawnCell.y)) == this.getPlayerRole()));
        if (this.pieceChooser.active) {
            this.renderPieceChooser(context, mouseX, mouseY, chessGameState.isSingleplayer ? ChessGrid.getPieceRole(chessGameState.getGrid().safeGetPieceId(pawnCell.x, pawnCell.y)) : this.getPlayerRole(), delta);
        } else {
            this.piecesChooserY = -49.0f;
        }
    }

    private void renderChessGameStats(class_332 context, float delta) {
        ChessGameState gameState = (ChessGameState)this.serverState;
        class_327 textRenderer = ((ScreenAccessor)((Object)this.screen)).getTextRenderer();
        class_4587 matrices = context.method_51448();
        class_1799 whitePlayerHead = new class_1799((class_1935)class_1802.field_8575);
        class_1799 blackPlayerHead = new class_1799((class_1935)class_1802.field_8575);
        if (gameState.getPlayers()[0] != null && gameState.getPlayers()[1] != null) {
            int currentTurn = gameState.currentTurn;
            Vector2i whiteTime = Utils.secondsToMinAndSec(this.whiteTimeLeftInSec);
            Vector2i blackTime = Utils.secondsToMinAndSec(this.blackTimeLeftInSec);
            float textScale = 1.0f;
            matrices.method_22903();
            matrices.method_22905(textScale, textScale, textScale);
            context.method_51433(textRenderer, Utils.timeToString(whiteTime), this.getScreenWidth() - textRenderer.method_1727(Utils.timeToString(whiteTime)) - 25, (int)(this.gameStatsY + 9.0f), currentTurn == 0 ? -2142128 : -8355712, true);
            context.method_51433(textRenderer, Utils.timeToString(blackTime), this.getScreenWidth() - textRenderer.method_1727(Utils.timeToString(blackTime)) - 25, (int)(this.gameStatsY + 34.0f), currentTurn == 1 ? -2142128 : -8355712, true);
            matrices.method_22909();
            class_1657 whitePlayer = this.blockEntity.method_10997().method_18470(gameState.getPlayers()[0]);
            class_1657 blackPlayer = this.blockEntity.method_10997().method_18470(gameState.getPlayers()[1]);
            if (whitePlayer != null) {
                whitePlayerHead.method_57379(class_9334.field_49617, (Object)new class_9296(whitePlayer.method_7334()));
            }
            if (blackPlayer != null) {
                blackPlayerHead.method_57379(class_9334.field_49617, (Object)new class_9296(blackPlayer.method_7334()));
            }
            if (currentTurn == 0) {
                this.whiteSkullScale = class_3532.method_16439((float)delta, (float)this.whiteSkullScale, (float)this.maxSkullScale);
                this.blackSkullScale = class_3532.method_16439((float)delta, (float)this.blackSkullScale, (float)1.0f);
            } else {
                this.blackSkullScale = class_3532.method_16439((float)delta, (float)this.blackSkullScale, (float)this.maxSkullScale);
                this.whiteSkullScale = class_3532.method_16439((float)delta, (float)this.whiteSkullScale, (float)1.0f);
            }
            Utils.renderScaledHead(context, whitePlayerHead, this.whiteSkullScale, this.getScreenWidth() - 86, (int)(this.gameStatsY + 3.0f));
            Utils.renderScaledHead(context, blackPlayerHead, this.blackSkullScale, this.getScreenWidth() - 86, (int)(this.gameStatsY + 28.0f));
        }
    }

    public void updateTimer(int whiteTimeLeftInSec, int blackTimeLeftInSec) {
        this.whiteTimeLeftInSec = whiteTimeLeftInSec;
        this.blackTimeLeftInSec = blackTimeLeftInSec;
    }

    public void renderPieceChooser(class_332 context, int mouseX, int mouseY, int role, float delta) {
        int width = 126;
        int height = 61;
        int x = context.method_51421() / 2 - width / 2;
        int centerX = this.getScreenWidth() / 2;
        this.piecesChooserY = class_3532.method_16439((float)(delta * 0.5f), (float)this.piecesChooserY, (float)0.0f);
        context.method_25290(PIECES_CHOOSER_BG, x - 5, (int)this.piecesChooserY, 0.0f, 0.0f, 140, 49, 140, 49);
        context.method_25290(PIECES_ATLAS, x, (int)(this.piecesChooserY + 10.0f), 0.0f, role == 1 ? (float)height / 2.0f : 0.0f, width, height / 2, width, height);
        int intersectedRect = this.pieceChooser.getMouseIntersectedRect(mouseX, mouseY);
        switch (intersectedRect) {
            case 0: {
                Utils.advancedFill(context, centerX - 65, 9, centerX - 31, 40, new Vector4i(1, 1, 1, 80));
                break;
            }
            case 1: {
                Utils.advancedFill(context, centerX - 30, 9, centerX, 40, new Vector4i(1, 1, 1, 80));
                break;
            }
            case 2: {
                Utils.advancedFill(context, centerX, 9, centerX + 35, 40, new Vector4i(1, 1, 1, 80));
                break;
            }
            case 3: {
                Utils.advancedFill(context, centerX + 35, 9, centerX + 69, 40, new Vector4i(1, 1, 1, 80));
            }
        }
    }

    public void renderConfirmationWindow(class_332 context, class_2561 text, float delta) {
        ScreenAccessor accessor = (ScreenAccessor)((Object)this.screen);
        class_327 textRenderer = accessor.getTextRenderer();
        int width = 126;
        int height = 40;
        int x = this.getScreenWidth() / 2 - width / 2;
        this.confirmationWindowY = class_3532.method_16439((float)(delta * 0.5f), (float)this.confirmationWindowY, (float)0.0f);
        this.yesButton.method_48229(this.getScreenWidth() / 2 - 50, (int)(this.confirmationWindowY + 18.0f));
        this.noButton.method_48229(this.getScreenWidth() / 2 + 10, (int)(this.confirmationWindowY + 18.0f));
        context.method_25290(PIECES_CHOOSER_BG, x, (int)this.confirmationWindowY, 0.0f, 0.0f, width, height, width, height);
        context.method_51439(textRenderer, (class_2561)text.method_27661().method_27692(class_124.field_1067), this.getScreenWidth() / 2 - textRenderer.method_27525((class_5348)text.method_27661().method_27692(class_124.field_1067)) / 2, (int)(this.confirmationWindowY + 7.0f), -2142128, true);
    }

    @Override
    public void drawBackground(class_332 context, float delta, int mouseX, int mouseY) {
        int width = Math.round(98.23529f);
        int height = Math.round(87.05882f);
        this.gameStatsY = class_3532.method_16439((float)(0.4f * delta), (float)this.gameStatsY, (float)0.0f);
        context.method_25290(CHESS_GAME_TEXTURE, this.getScreenWidth() - width, (int)this.gameStatsY, 0.0f, 0.0f, width, height, width, height);
        this.manageButtons(context, delta);
    }

    private void manageButtons(class_332 context, float delta) {
        ChessGameState gameState = (ChessGameState)this.serverState;
        this.offerDrawButton.method_46419((int)this.gameStatsY + 59);
        this.resignButton.method_46419((int)this.gameStatsY + 59);
        if (gameState.drawOfferRole != this.getPlayerRole() && gameState.drawOfferRole != -1 || gameState.drawOfferRole != -1 && gameState.isSingleplayer) {
            if (context != null) {
                this.renderConfirmationWindow(context, DRAW_TEXT, delta);
            }
            this.yesButton.field_22764 = true;
            this.noButton.field_22764 = true;
        } else if (gameState.resignOfferRole == this.getPlayerRole()) {
            if (context != null) {
                this.renderConfirmationWindow(context, RESIGN_TEXT, delta);
            }
            this.yesButton.field_22764 = true;
            this.noButton.field_22764 = true;
        } else {
            this.yesButton.field_22764 = false;
            this.noButton.field_22764 = false;
            this.confirmationWindowY = -39.0f;
        }
        if (gameState.drawOfferRole != -1 || gameState.resignOfferRole != -1 || this.pieceChooser.active) {
            this.resignButton.field_22763 = false;
            this.offerDrawButton.field_22763 = false;
        } else {
            this.resignButton.field_22763 = true;
            this.offerDrawButton.field_22763 = true;
        }
    }

    @Override
    public void onScreenResize(int width, int height) {
        this.clickableGrid.onScreenResize();
        this.pieceChooser.onScreenResize(false);
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button, ChessBoardScreen screen) {
        this.clickableGrid.onScreenResize();
        this.clickableGrid.mouseClicked(mouseX, mouseY);
        this.pieceChooser.mouseClicked(mouseX, mouseY, this::pieceChooserClick);
        return true;
    }

    public void pieceChooserClick(int cellId) {
        ChessGameState chessGameState = (ChessGameState)this.serverState;
        int whitePieceId = cellId == 0 ? ChessPieces.WHITE_QUEEN.id : (cellId == 1 ? ChessPieces.WHITE_BISHOP.id : (cellId == 2 ? ChessPieces.WHITE_KNIGHT.id : ChessPieces.WHITE_ROOK.id));
        ClientPlayNetworking.send((class_8710)new TurnPawnIntoPayload(this.blockEntity.method_11016(), chessGameState.isSingleplayer ? (chessGameState.currentTurn == 0 ? whitePieceId : whitePieceId + 6) : (this.getPlayerRole() == 0 ? whitePieceId : whitePieceId + 6)));
    }

    public int getPlayerRole() {
        if (((ChessGameState)this.serverState).getPlayers()[0] == null || ((ChessGameState)this.serverState).getPlayers()[1] == null) {
            return -1;
        }
        int whiteResult = this.client.field_1724.method_5667().compareTo(((ChessGameState)this.serverState).getPlayers()[0]);
        int blackResult = this.client.field_1724.method_5667().compareTo(((ChessGameState)this.serverState).getPlayers()[1]);
        if (!this.serverState.shouldUse() || whiteResult != 0 && blackResult != 0) {
            return -1;
        }
        return whiteResult == 0 ? 0 : 1;
    }

    public void focusCamera() {
        if (this.shouldRender()) {
            class_4184 camera = this.client.field_1773.method_19418();
            ((CameraAnimationPlayable)camera).focusOnBlockEntity(this.blockEntity, this.player);
        }
    }

    @Override
    public void afterSwitch() {
        this.screen.renderingGameStates.get(2).createWidgets(this.screen);
        this.offerDrawButton.field_22764 = false;
        this.resignButton.field_22764 = false;
        this.yesButton.field_22764 = false;
        this.noButton.field_22764 = false;
    }
}

