/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.chess.gameStates;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.fieldb0y.wanna_play_chess.block.entity.ChessBoardBlockEntity;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameState;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessState;
import net.fieldb0y.wanna_play_chess.utils.GameState;
import net.fieldb0y.wanna_play_chess.utils.Timer;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;

public class ChessLobbyState
extends ChessState {
    private UUID[] playersInLobby = new UUID[2];
    private Timer timer = new Timer(this::clearLobby, 60);
    public int gameTimeInSec = 600;
    public boolean noTimeControl = false;
    public int firstPlayerRole = 2;

    public ChessLobbyState(ChessBoardBlockEntity blockEntity) {
        super(blockEntity, List.of(GameState.NOT_READY_TO_PLAY, GameState.READY_FOR_SINGLEPLAYER_GAME, GameState.READY_TO_PLAY));
    }

    @Override
    public void tick() {
        if (this.playersInLobby[0] != null && this.getWorld().method_18470(this.playersInLobby[0]) == null) {
            this.removePlayerFromLobby(this.playersInLobby[0]);
        }
        if (this.playersInLobby[1] != null && this.getWorld().method_18470(this.playersInLobby[1]) == null) {
            this.removePlayerFromLobby(this.playersInLobby[1]);
        }
        this.timer.tick(this.playersInLobby[0] != null);
    }

    @Override
    public void writeNbt(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (int i = 0; i < this.playersInLobby.length; ++i) {
            UUID uuid = this.playersInLobby[i];
            if (uuid == null) continue;
            list.add((Object)class_2512.method_25929((UUID)uuid));
        }
        nbt.method_10566("PlayersInLobby", (class_2520)list);
        nbt.method_10569("GameTimeInSec", this.gameTimeInSec);
        nbt.method_10569("FirstPlayerRole", this.firstPlayerRole);
        nbt.method_10556("NoTimeControl", this.noTimeControl);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        if (nbt.method_10545("PlayersInLobby")) {
            class_2499 list = (class_2499)nbt.method_10580("PlayersInLobby");
            for (int i = 0; i < 2; ++i) {
                this.playersInLobby[i] = i < list.size() ? class_2512.method_25930((class_2520)list.method_10534(i)) : null;
            }
        }
        if (nbt.method_10545("GameTimeInSec")) {
            this.gameTimeInSec = nbt.method_10550("GameTimeInSec");
        }
        if (nbt.method_10545("FirstPlayerRole")) {
            this.firstPlayerRole = nbt.method_10550("FirstPlayerRole");
        }
        if (nbt.method_10545("NoTimeControl")) {
            this.noTimeControl = nbt.method_10577("NoTimeControl");
        }
    }

    public class_1657 getPlayerInLobby(int id) {
        return this.playersInLobby[id] != null ? this.getWorld().method_18470(this.playersInLobby[id]) : null;
    }

    public void setGameTimeInSec(int gameTimeInSec) {
        this.gameTimeInSec = gameTimeInSec;
        this.updateClient();
    }

    public void setNoTimeControl(boolean checked) {
        this.noTimeControl = checked;
        this.updateClient();
    }

    public void setFirstPlayerRole(int role) {
        this.firstPlayerRole = role;
        this.updateClient();
    }

    public void addPlayer(class_1657 player) {
        if (!(this.blockEntity.getGameState() != GameState.NOT_READY_TO_PLAY && this.blockEntity.getGameState() != GameState.READY_FOR_SINGLEPLAYER_GAME || Arrays.stream(this.playersInLobby).toList().contains(player.method_5667()))) {
            this.playersInLobby[this.playersInLobby[0] == null ? 0 : 1] = player.method_5667();
        }
        this.updateClient();
    }

    public void removePlayerFromLobby(UUID uuid) {
        for (int i = 0; i < this.playersInLobby.length; ++i) {
            UUID currentUuid = this.playersInLobby[i];
            if (currentUuid == null || currentUuid.compareTo(uuid) != 0) continue;
            this.playersInLobby[i] = null;
        }
        this.updateClient();
    }

    public void removePlayerFromLobby(class_1657 player) {
        if (player != null) {
            this.removePlayerFromLobby(player.method_5667());
        }
    }

    public void clearLobby() {
        this.playersInLobby = new UUID[2];
        this.updateClient();
    }

    public UUID[] getPlayersInLobby() {
        return Arrays.copyOf(this.playersInLobby, this.playersInLobby.length);
    }

    @Override
    public void afterSwitch() {
        ((ChessGameState)this.blockEntity.states.get(1)).startGame(this.playersInLobby, this.gameTimeInSec, this.noTimeControl, this.firstPlayerRole, this.playersInLobby[0] == null || this.playersInLobby[1] == null);
    }

    public boolean isPlayerInLobby(UUID uuid) {
        boolean r1 = false;
        boolean r2 = false;
        if (this.playersInLobby[0] != null) {
            boolean bl = r1 = this.playersInLobby[0].compareTo(uuid) == 0;
        }
        if (this.playersInLobby[1] != null) {
            r2 = this.playersInLobby[1].compareTo(uuid) == 0;
        }
        return r1 || r2;
    }

    @Override
    public void clear() {
        this.clearLobby();
    }
}

