/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.chess.gameStates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fieldb0y.wanna_play_chess.CameraAnimationPlayable;
import net.fieldb0y.wanna_play_chess.block.entity.ChessBoardBlockEntity;
import net.fieldb0y.wanna_play_chess.chess.ChessGrid;
import net.fieldb0y.wanna_play_chess.chess.PiecesData;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameOverState;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessState;
import net.fieldb0y.wanna_play_chess.chess.utils.ChessGameOverReason;
import net.fieldb0y.wanna_play_chess.chess.utils.ChessPieces;
import net.fieldb0y.wanna_play_chess.chess.utils.PieceAction;
import net.fieldb0y.wanna_play_chess.item.custom.ChessPiece;
import net.fieldb0y.wanna_play_chess.network.s2cPayloads.TimerUpdatePayload;
import net.fieldb0y.wanna_play_chess.sound.ModSounds;
import net.fieldb0y.wanna_play_chess.utils.GameState;
import net.fieldb0y.wanna_play_chess.utils.Timer;
import net.fieldb0y.wanna_play_chess.utils.Utils;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_4184;
import net.minecraft.class_8710;
import org.joml.Vector2i;

public class ChessGameState
extends ChessState {
    public static final int WHITE = 0;
    public static final int BLACK = 1;
    private UUID[] players = new UUID[2];
    private Map<Integer, List<Integer>> playersTakenPieces = new HashMap<Integer, List<Integer>>();
    private ChessGrid grid;
    public PiecesData piecesData;
    public Timer[] gameTimers;
    public int whiteTimeLeft = 0;
    public int blackTimeLeft = 0;
    public int currentChosenPiece;
    public Vector2i currentChosenCell;
    public int currentTurn;
    public boolean isSingleplayer;
    private ChessGameOverReason gameOverReason;
    private int winnerRole;
    public int drawOfferRole;
    public int resignOfferRole;

    public ChessGameState(ChessBoardBlockEntity blockEntity) {
        super(blockEntity, List.of(GameState.PLAYING));
        this.currentChosenPiece = ChessPieces.EMPTY.id;
        this.currentChosenCell = new Vector2i(-1, -1);
        this.currentTurn = 0;
        this.isSingleplayer = false;
        this.gameOverReason = ChessGameOverReason.NONE;
        this.winnerRole = -1;
        this.drawOfferRole = -1;
        this.resignOfferRole = -1;
        this.grid = new ChessGrid(blockEntity);
        this.piecesData = new PiecesData(this);
        this.gameTimers = new Timer[]{new Timer(this::whiteTimerTick, 1), new Timer(this::blackTimerTick, 1)};
        if (this.players.length >= 2) {
            this.gameTimers[this.currentTurn].start();
        }
    }

    public void startGame(UUID[] playersInLobby, int gameTime, boolean noTimeControl, int firstPlayerRole, boolean isSingleplayer) {
        int whiteId;
        Random random = new Random();
        this.isSingleplayer = isSingleplayer;
        int n = whiteId = firstPlayerRole == 2 ? random.nextInt(0, 1) : firstPlayerRole;
        if (isSingleplayer) {
            UUID playerUUID;
            this.players[0] = playerUUID = playersInLobby[playersInLobby[0] == null ? 1 : 0];
            this.players[1] = playerUUID;
        } else {
            this.players[0] = playersInLobby[whiteId];
            this.players[1] = playersInLobby[whiteId == 0 ? 1 : 0];
        }
        this.grid.rotateToPlayer(this.players);
        this.grid.genStartingPosition();
        this.whiteTimeLeft = noTimeControl ? -1 : gameTime;
        this.blackTimeLeft = noTimeControl ? -1 : gameTime;
        this.gameTimers = new Timer[]{new Timer(this::whiteTimerTick, 1), new Timer(this::blackTimerTick, 1)};
        this.updateClient();
        if (this.blockEntity.method_10997().method_8608()) {
            int role;
            class_310 client = class_310.method_1551();
            class_4184 camera = client.field_1773.method_19418();
            int n2 = client.field_1724.method_5667().compareTo(this.players[0]) == 0 ? 0 : (role = client.field_1724.method_5667().compareTo(this.players[1]) == 0 ? 1 : -1);
            if (role != -1) {
                ((CameraAnimationPlayable)camera).focusOnBlockEntity(this.blockEntity, role);
            }
        }
    }

    public void clickOnCell(int cellX, int cellY, int playerRole) {
        if (!this.findPieceCellWithTag(PiecesData.DataTag.SHOULD_TURN).equals(-1, -1)) {
            return;
        }
        if (this.resignOfferRole != -1 || this.drawOfferRole != -1) {
            return;
        }
        if (this.currentTurn == playerRole) {
            Vector2i prevChosenCell = new Vector2i(this.currentChosenCell.x, this.currentChosenCell.y);
            this.currentChosenCell = new Vector2i(cellX, cellY);
            int id = this.grid.safeGetPieceId(cellX, cellY);
            if (id != -1 && id != ChessPieces.EMPTY.id && ChessGrid.getPieceRole(id) == playerRole) {
                this.currentChosenPiece = this.grid.safeGetPieceId(cellX, cellY);
            } else if (this.currentChosenPiece != ChessPieces.EMPTY.id && ChessGrid.getPieceRole(this.currentChosenPiece) == playerRole) {
                ChessPiece piece = ChessGrid.getPieceById(this.currentChosenPiece);
                Map<PieceAction, List<Vector2i>> possibleMoves = piece.getPossibleMoves(prevChosenCell.x, prevChosenCell.y, playerRole, this.grid);
                for (PieceAction action : possibleMoves.keySet()) {
                    for (Vector2i move : possibleMoves.get((Object)action)) {
                        if (move.equals(cellX, cellY)) {
                            if (this.grid.safeGetPieceId(cellX, cellY) == ChessPieces.WHITE_KING.id || this.grid.safeGetPieceId(cellX, cellY) == ChessPieces.BLACK_KING.id || action == PieceAction.NONE || action == PieceAction.OTHER) continue;
                            if (action == PieceAction.TAKE) {
                                if (this.playersTakenPieces.containsKey(playerRole)) {
                                    this.playersTakenPieces.get(playerRole).add(this.grid.safeGetPieceId(cellX, cellY));
                                } else {
                                    this.playersTakenPieces.put(playerRole, new ArrayList<Integer>(List.of(Integer.valueOf(this.grid.safeGetPieceId(cellX, cellY)))));
                                }
                                this.playSound(ModSounds.CAPTURE);
                            } else if (action == PieceAction.EN_PASSANT) {
                                if (this.playersTakenPieces.containsKey(playerRole)) {
                                    this.playersTakenPieces.get(playerRole).add(playerRole == 0 ? ChessPieces.BLACK_PAWN.id : ChessPieces.WHITE_PAWN.id);
                                } else {
                                    this.playersTakenPieces.put(playerRole, new ArrayList<Integer>(List.of(Integer.valueOf(playerRole == 0 ? ChessPieces.BLACK_PAWN.id : ChessPieces.WHITE_PAWN.id))));
                                }
                                this.grid.removePiece(cellX, cellY + (playerRole == 0 ? 1 : -1));
                                this.playSound(ModSounds.CAPTURE);
                            } else if (action == PieceAction.CASTLE) {
                                int pieceRole = ChessGrid.getPieceRole(this.grid.safeGetPieceId(prevChosenCell.x, prevChosenCell.y));
                                int kingY = pieceRole == 0 ? 7 : 0;
                                Vector2i scrPos = new Vector2i(7, kingY);
                                Vector2i lcrPos = new Vector2i(0, kingY);
                                if (cellX > 4) {
                                    this.grid.movePiece(scrPos.x, scrPos.y, scrPos.x - 2, scrPos.y);
                                } else {
                                    this.grid.movePiece(lcrPos.x, lcrPos.y, lcrPos.x + 3, lcrPos.y);
                                }
                                this.playSound(ModSounds.CASTLE);
                            }
                            if (action == PieceAction.MOVE) {
                                this.playSound(ModSounds.MOVE_SELF);
                            }
                            this.updatePremoveTags();
                            ChessGrid.getPieceById(this.grid.safeGetPieceId(prevChosenCell.x, prevChosenCell.y)).updatePieceData(new Vector2i(prevChosenCell.x, prevChosenCell.y), new Vector2i(cellX, cellY), this.piecesData);
                            this.grid.movePiece(prevChosenCell.x, prevChosenCell.y, cellX, cellY);
                            if (this.currentChosenPiece == ChessPieces.WHITE_KING.id || this.currentChosenPiece == ChessPieces.BLACK_KING.id || this.currentChosenPiece == ChessPieces.WHITE_ROOK.id || this.currentChosenPiece == ChessPieces.BLACK_ROOK.id) {
                                this.piecesData.removeData(prevChosenCell.x, prevChosenCell.y, PiecesData.DataTag.ALREADY_MOVED);
                                this.piecesData.putData(cellX, cellY, List.of(PiecesData.DataTag.ALREADY_MOVED));
                            }
                            this.updateAftermoveTags();
                            if (!this.piecesData.hasDataTag(this.currentChosenCell.x, this.currentChosenCell.y, PiecesData.DataTag.SHOULD_TURN)) {
                                this.checkForGameEnd();
                                this.nextTurn();
                            }
                            this.currentChosenCell = new Vector2i(-1, -1);
                            this.currentChosenPiece = ChessPieces.EMPTY.id;
                            continue;
                        }
                        if (ChessGrid.getPieceRole(id) == playerRole) continue;
                        this.currentChosenPiece = ChessPieces.EMPTY.id;
                    }
                }
            }
        }
        this.updateClient();
    }

    private void updatePremoveTags() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (!this.piecesData.hasDataTag(i, j, PiecesData.DataTag.ONE_TURN)) continue;
                this.piecesData.clearData(i, j);
            }
        }
    }

    public void updateAftermoveTags() {
        this.updateDataForKings();
        this.updateCantMoveTag();
        this.updateShouldTurnTag();
    }

    public void checkForGameEnd() {
        if (this.getCheckedKing() != -1) {
            Vector2i cell = this.grid.findPiecePos(this.getCheckedKing());
            if (this.isKingStalemated(cell)) {
                this.gameOver(ChessGameOverReason.CHECKMATE, this.getCheckedKingRole() == 0 ? 1 : 0);
            }
        } else {
            Vector2i whiteKingPos = this.grid.findPiecePos(ChessPieces.WHITE_KING.id);
            Vector2i blackPiecePos = this.grid.findPiecePos(ChessPieces.BLACK_KING.id);
            if (this.isKingStalemated(whiteKingPos)) {
                this.gameOver(ChessGameOverReason.STALEMATE, -1);
            }
            if (this.isKingStalemated(blackPiecePos)) {
                this.gameOver(ChessGameOverReason.STALEMATE, -1);
            }
            if (!this.isPossibleToWin(whiteKingPos, blackPiecePos)) {
                this.gameOver(ChessGameOverReason.IMPOSSIBLE_TO_WIN, -1);
            }
        }
    }

    private boolean isPossibleToWin(Vector2i whiteKingPos, Vector2i blackKingPos) {
        if (whiteKingPos.equals(-1, -1) || blackKingPos.equals(-1, -1)) {
            return true;
        }
        List<Vector2i> whitePiecesCells = this.grid.getPiecesCellsByRole(0);
        List<Vector2i> blackPiecesCells = this.grid.getPiecesCellsByRole(1);
        if (whitePiecesCells.size() == 1) {
            if (blackPiecesCells.size() == 1) {
                return false;
            }
            if (this.getGrid().isAnyOfPiecesOnBoard(ChessPieces.getAllIdsWithRoleExcept(1, List.of(Integer.valueOf(ChessPieces.BLACK_KNIGHT.id), Integer.valueOf(ChessPieces.BLACK_BISHOP.id), Integer.valueOf(ChessPieces.BLACK_KING.id))))) {
                return true;
            }
            if (blackPiecesCells.size() > 3) {
                return true;
            }
            if (blackPiecesCells.size() == 2) {
                return false;
            }
            return !this.grid.findPiecesPos(ChessPieces.BLACK_BISHOP.id).isEmpty();
        }
        if (blackPiecesCells.size() == 1) {
            if (this.getGrid().isAnyOfPiecesOnBoard(ChessPieces.getAllIdsWithRoleExcept(0, List.of(Integer.valueOf(ChessPieces.WHITE_KNIGHT.id), Integer.valueOf(ChessPieces.WHITE_BISHOP.id), Integer.valueOf(ChessPieces.WHITE_KING.id))))) {
                return true;
            }
            if (whitePiecesCells.size() > 3) {
                return true;
            }
            if (whitePiecesCells.size() == 2) {
                return false;
            }
            return !this.grid.findPiecesPos(ChessPieces.WHITE_BISHOP.id).isEmpty();
        }
        return true;
    }

    private boolean isKingStalemated(Vector2i kingPos) {
        if (kingPos.equals(-1, -1)) {
            return false;
        }
        int kingId = this.grid.safeGetPieceId(kingPos.x, kingPos.y);
        int role = ChessGrid.getPieceRole(kingId);
        ChessPiece kingPiece = ChessGrid.getPieceById(kingId);
        if (!kingPiece.isAbleToMove(kingPos.x, kingPos.y, role, this.grid)) {
            List<Vector2i> piecesCellsOnBoard = this.grid.getPiecesCellsByRole(role);
            piecesCellsOnBoard.remove(kingPos);
            if (piecesCellsOnBoard.isEmpty()) {
                return true;
            }
            for (Vector2i cell : piecesCellsOnBoard) {
                ChessPiece piece = this.grid.getPieceAt(cell.x, cell.y);
                if (!piece.isAbleToMove(cell.x, cell.y, role, this.grid)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void whiteTimerTick() {
        --this.whiteTimeLeft;
        if (this.whiteTimeLeft <= 0) {
            this.gameOver(ChessGameOverReason.TIME_IS_UP, 1);
        }
        this.updateTimerOnClient();
    }

    public void blackTimerTick() {
        --this.blackTimeLeft;
        if (this.blackTimeLeft <= 0) {
            this.gameOver(ChessGameOverReason.TIME_IS_UP, 0);
        }
        this.updateTimerOnClient();
    }

    public void updateTimerOnClient() {
        class_1937 class_19372 = this.getWorld();
        if (class_19372 instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            for (class_3222 player : serverWorld.method_18456()) {
                if (player.method_5667().compareTo(this.players[0]) == 0) {
                    ServerPlayNetworking.send((class_3222)player, (class_8710)new TimerUpdatePayload(this.blockEntity.method_11016(), this.whiteTimeLeft, this.blackTimeLeft));
                    continue;
                }
                if (player.method_5667().compareTo(this.players[1]) != 0) continue;
                ServerPlayNetworking.send((class_3222)player, (class_8710)new TimerUpdatePayload(this.blockEntity.method_11016(), this.whiteTimeLeft, this.blackTimeLeft));
            }
        }
    }

    private void updateShouldTurnTag() {
        this.clearTagOnBoard(PiecesData.DataTag.SHOULD_TURN);
        for (Vector2i cell : this.grid.findPiecesPos(ChessPieces.WHITE_PAWN.id)) {
            if (cell.y != 0) continue;
            this.piecesData.putData(cell.x, cell.y, List.of(PiecesData.DataTag.SHOULD_TURN));
        }
        for (Vector2i cell : this.grid.findPiecesPos(ChessPieces.BLACK_PAWN.id)) {
            if (cell.y != 7) continue;
            this.piecesData.putData(cell.x, cell.y, List.of(PiecesData.DataTag.SHOULD_TURN));
        }
    }

    public int getCheckedKing() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int pieceId = this.grid.safeGetPieceId(i, j);
                if (pieceId != ChessPieces.WHITE_KING.id && pieceId != ChessPieces.BLACK_KING.id || !this.piecesData.hasDataTag(i, j, PiecesData.DataTag.CHECKED)) continue;
                return pieceId;
            }
        }
        return -1;
    }

    public int getCheckedKingRole() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int pieceId = this.grid.safeGetPieceId(i, j);
                if (pieceId != ChessPieces.WHITE_KING.id && pieceId != ChessPieces.BLACK_KING.id || !this.piecesData.hasDataTag(i, j, PiecesData.DataTag.CHECKED)) continue;
                return ChessGrid.getPieceRole(pieceId);
            }
        }
        return -1;
    }

    private void updateDataForKings() {
        Vector2i whiteKingPos = this.grid.findPiecePos(ChessPieces.WHITE_KING.id);
        Vector2i blackKingPos = this.grid.findPiecePos(ChessPieces.BLACK_KING.id);
        this.piecesData.removeData(whiteKingPos.x, whiteKingPos.y, PiecesData.DataTag.CHECKED);
        this.piecesData.removeData(blackKingPos.x, blackKingPos.y, PiecesData.DataTag.CHECKED);
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int pieceId = this.grid.safeGetPieceId(i, j);
                if (pieceId == -1 || pieceId == ChessPieces.EMPTY.id) continue;
                this.piecesData.removeData(i, j, PiecesData.DataTag.GIVES_CHECK);
                ChessPiece piece = ChessGrid.getPieceById(pieceId);
                List<Vector2i> takeCells = piece.getPossibleMoves(i, j, ChessGrid.getPieceRole(pieceId), this.grid).get((Object)PieceAction.TAKE);
                if (takeCells == null) continue;
                if (!whiteKingPos.equals(-1, -1) && takeCells.contains(whiteKingPos)) {
                    this.piecesData.putData(whiteKingPos.x, whiteKingPos.y, List.of(PiecesData.DataTag.CHECKED));
                    this.piecesData.putData(i, j, List.of(PiecesData.DataTag.GIVES_CHECK));
                    this.playSound(ModSounds.MOVE_CHECK);
                }
                if (blackKingPos.equals(-1, -1) || !takeCells.contains(blackKingPos)) continue;
                this.piecesData.putData(blackKingPos.x, blackKingPos.y, List.of(PiecesData.DataTag.CHECKED));
                this.piecesData.putData(i, j, List.of(PiecesData.DataTag.GIVES_CHECK));
                this.playSound(ModSounds.MOVE_CHECK);
            }
        }
        this.updateCastleTags(whiteKingPos, blackKingPos);
        this.updateClient();
    }

    private void updateCastleTags(Vector2i whiteKingPos, Vector2i blackKingPos) {
        ArrayList<Object> path;
        Vector2i lcRook;
        Vector2i scRook;
        List<Vector2i> whiteRooksPositions = this.grid.findPiecesPos(ChessPieces.WHITE_ROOK.id);
        List<Vector2i> blackRooksPositions = this.grid.findPiecesPos(ChessPieces.BLACK_ROOK.id);
        if (blackRooksPositions.isEmpty() || whiteRooksPositions.isEmpty()) {
            return;
        }
        this.clearTagOnBoard(PiecesData.DataTag.CAN_CASTLE_SHORT);
        this.clearTagOnBoard(PiecesData.DataTag.CAN_CASTLE_LONG);
        if (whiteKingPos.equals(4, 7) && !this.piecesData.hasDataTag(whiteKingPos.x, whiteKingPos.y, PiecesData.DataTag.CHECKED) && !this.piecesData.hasDataTag(whiteKingPos.x, whiteKingPos.y, PiecesData.DataTag.ALREADY_MOVED)) {
            scRook = whiteRooksPositions.getLast();
            lcRook = whiteRooksPositions.getFirst();
            if (lcRook.equals(0, 7) && !this.piecesData.hasDataTag(lcRook.x, lcRook.y, PiecesData.DataTag.ALREADY_MOVED) && !this.grid.isCellUnderAttack(whiteKingPos.x - 1, whiteKingPos.y, 0) && !this.grid.isCellUnderAttack(whiteKingPos.x - 2, whiteKingPos.y, 0)) {
                path = new ArrayList<Vector2i>();
                ChessPiece.addStraightPath(lcRook, whiteKingPos, path, false);
                if (Utils.isPathHasNoPieces(path, this.grid)) {
                    this.piecesData.putData(whiteKingPos.x, whiteKingPos.y, List.of(PiecesData.DataTag.CAN_CASTLE_SHORT));
                }
            }
            if (scRook.equals(7, 7) && !this.piecesData.hasDataTag(scRook.x, scRook.y, PiecesData.DataTag.ALREADY_MOVED) && !this.grid.isCellUnderAttack(whiteKingPos.x + 1, whiteKingPos.y, 0) && !this.grid.isCellUnderAttack(whiteKingPos.x + 2, whiteKingPos.y, 0)) {
                path = new ArrayList();
                ChessPiece.addStraightPath(scRook, whiteKingPos, path, false);
                if (Utils.isPathHasNoPieces(path, this.grid)) {
                    this.piecesData.putData(whiteKingPos.x, whiteKingPos.y, List.of(PiecesData.DataTag.CAN_CASTLE_LONG));
                }
            }
        }
        if (blackKingPos.equals(4, 0) && !this.piecesData.hasDataTag(blackKingPos.x, blackKingPos.y, PiecesData.DataTag.CHECKED) && !this.piecesData.hasDataTag(blackKingPos.x, blackKingPos.y, PiecesData.DataTag.ALREADY_MOVED)) {
            scRook = blackRooksPositions.getLast();
            lcRook = blackRooksPositions.getFirst();
            if (lcRook.equals(0, 0) && !this.piecesData.hasDataTag(lcRook.x, lcRook.y, PiecesData.DataTag.ALREADY_MOVED) && !this.grid.isCellUnderAttack(blackKingPos.x - 1, blackKingPos.y, 1) && !this.grid.isCellUnderAttack(blackKingPos.x - 2, blackKingPos.y, 1)) {
                path = new ArrayList();
                ChessPiece.addStraightPath(lcRook, blackKingPos, path, false);
                if (Utils.isPathHasNoPieces(path, this.grid)) {
                    this.piecesData.putData(blackKingPos.x, blackKingPos.y, List.of(PiecesData.DataTag.CAN_CASTLE_SHORT));
                }
            }
            if (scRook.equals(7, 0) && !this.piecesData.hasDataTag(scRook.x, scRook.y, PiecesData.DataTag.ALREADY_MOVED) && !this.grid.isCellUnderAttack(blackKingPos.x + 1, blackKingPos.y, 1) && !this.grid.isCellUnderAttack(blackKingPos.x + 2, blackKingPos.y, 1)) {
                path = new ArrayList();
                ChessPiece.addStraightPath(scRook, blackKingPos, path, false);
                if (Utils.isPathHasNoPieces(path, this.grid)) {
                    this.piecesData.putData(blackKingPos.x, blackKingPos.y, List.of(PiecesData.DataTag.CAN_CASTLE_LONG));
                }
            }
        }
    }

    private void updateCantMoveTag() {
        this.clearTagOnBoard(PiecesData.DataTag.CANT_MOVE);
        Vector2i whiteKingPos = this.grid.findPiecePos(ChessPieces.WHITE_KING.id);
        Vector2i blackKingPos = this.grid.findPiecePos(ChessPieces.BLACK_KING.id);
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int pieceId = this.grid.safeGetPieceId(i, j);
                if (pieceId == ChessPieces.WHITE_KING.id || pieceId == ChessPieces.BLACK_KING.id || pieceId == ChessPieces.EMPTY.id || pieceId == -1) continue;
                ChessPiece piece = ChessGrid.getPieceById(pieceId);
                List<Vector2i> pathToKing = ChessPiece.getAttackPath(ChessGrid.getPieceRole(pieceId) == 0 ? blackKingPos : whiteKingPos, new Vector2i(i, j), piece, false);
                int piecesOnPathCount = 0;
                Vector2i tiedPiece = new Vector2i(-1, -1);
                if (!pathToKing.isEmpty()) {
                    for (Vector2i pathCell : pathToKing) {
                        int pieceOnPath = this.grid.safeGetPieceId(pathCell.x, pathCell.y);
                        if (ChessGrid.getPieceRole(pieceOnPath) == ChessGrid.getPieceRole(pieceId) || pieceOnPath == -1 || pieceOnPath == ChessPieces.EMPTY.id) continue;
                        if (++piecesOnPathCount <= 1) {
                            tiedPiece = new Vector2i(pathCell.x, pathCell.y);
                            continue;
                        }
                        tiedPiece = new Vector2i(-1, -1);
                    }
                }
                if (tiedPiece.equals(-1, -1)) continue;
                this.piecesData.putData(tiedPiece.x, tiedPiece.y, List.of(PiecesData.DataTag.CANT_MOVE));
            }
        }
    }

    public Vector2i findPieceCellWithTag(PiecesData.DataTag tag) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (!this.piecesData.hasDataTag(i, j, tag)) continue;
                return new Vector2i(i, j);
            }
        }
        return new Vector2i(-1, -1);
    }

    private void clearTagOnBoard(PiecesData.DataTag tag) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.piecesData.removeData(i, j, tag);
            }
        }
    }

    public void nextTurn() {
        this.currentTurn = this.currentTurn == 0 ? 1 : 0;
        this.updateClient();
    }

    public Map<PieceAction, List<Vector2i>> getPossibleMoves() {
        if (!this.currentChosenCell.equals(-1, -1)) {
            return this.grid.getPossibleMoves(this.currentChosenCell.x, this.currentChosenCell.y);
        }
        return Map.of();
    }

    public void gameOver(ChessGameOverReason gameOverReason, int winnerRole) {
        this.gameOverReason = gameOverReason;
        this.winnerRole = winnerRole;
        this.blockEntity.setGameState(GameState.GAME_OVER);
    }

    public void turnPawnInto(Vector2i pawnCell, int toPieceId) {
        this.grid.turnPawnInto(pawnCell, toPieceId);
    }

    @Override
    public void writeNbt(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (int i = 0; i < this.players.length; ++i) {
            UUID uuid = this.players[i];
            if (uuid == null) continue;
            list.method_10531(i, (class_2520)class_2512.method_25929((UUID)uuid));
        }
        nbt.method_10566("PlayingPlayers", (class_2520)list);
        nbt.method_10569("CurrentTurn", this.currentTurn);
        nbt.method_10572("CurrentChosenCellXY", List.of(Integer.valueOf(this.currentChosenCell.x), Integer.valueOf(this.currentChosenCell.y)));
        nbt.method_10569("CurrentChosenPiece", this.currentChosenPiece);
        this.writeTakenPiecesToNbt(nbt);
        this.grid.writeNbt(nbt);
        this.piecesData.saveData(nbt);
        nbt.method_10572("TimeLeft", List.of(Integer.valueOf(this.whiteTimeLeft), Integer.valueOf(this.blackTimeLeft)));
        nbt.method_10569("DrawOfferRole", this.drawOfferRole);
        nbt.method_10569("ResignOfferRole", this.resignOfferRole);
    }

    @Override
    public void readNbt(class_2487 nbt) {
        if (nbt.method_10545("PlayingPlayers")) {
            class_2499 list = (class_2499)nbt.method_10580("PlayingPlayers");
            for (int i = 0; i < 2; ++i) {
                if (i >= list.size()) continue;
                this.players[i] = class_2512.method_25930((class_2520)list.method_10534(i));
            }
        }
        if (nbt.method_10545("CurrentChosenCellXY")) {
            int[] xy = nbt.method_10561("CurrentChosenCellXY");
            this.currentChosenCell.set(xy[0], xy[1]);
        }
        if (nbt.method_10545("CurrentChosenPiece")) {
            this.currentChosenPiece = nbt.method_10550("CurrentChosenPiece");
        }
        if (nbt.method_10545("CurrentTurn")) {
            this.currentTurn = nbt.method_10550("CurrentTurn");
        }
        this.readTakenPiecesFromNbt(nbt);
        this.grid.readNbt(nbt);
        this.piecesData.readData(nbt);
        if (nbt.method_10545("TimeLeft")) {
            int[] array = nbt.method_10561("TimeLeft");
            this.whiteTimeLeft = array[0];
            this.blackTimeLeft = array[1];
        }
        if (nbt.method_10545("DrawOfferRole")) {
            this.drawOfferRole = nbt.method_10550("DrawOfferRole");
        }
        if (nbt.method_10545("ResignOfferRole")) {
            this.resignOfferRole = nbt.method_10550("ResignOfferRole");
        }
    }

    private void writeTakenPiecesToNbt(class_2487 nbt) {
        class_2499 takenList = new class_2499();
        for (int role : new int[]{0, 1}) {
            class_2499 roleList = new class_2499();
            for (Integer pieceId : this.playersTakenPieces.getOrDefault(role, Collections.emptyList())) {
                roleList.add((Object)class_2497.method_23247((int)pieceId));
            }
            takenList.add((Object)roleList);
        }
        nbt.method_10566("TakenPieces", (class_2520)takenList);
    }

    private void readTakenPiecesFromNbt(class_2487 nbt) {
        ArrayList<Integer> wtpl = new ArrayList<Integer>();
        ArrayList<Integer> btpl = new ArrayList<Integer>();
        if (nbt.method_10545("TakenPieces")) {
            int i;
            class_2499 list = (class_2499)nbt.method_10580("TakenPieces");
            class_2499 whiteList = list.method_10603(0);
            class_2499 blackList = list.method_10603(1);
            for (i = 0; i < whiteList.size(); ++i) {
                wtpl.add(whiteList.method_10600(i));
            }
            for (i = 0; i < blackList.size(); ++i) {
                btpl.add(blackList.method_10600(i));
            }
        }
        this.playersTakenPieces.put(0, wtpl);
        this.playersTakenPieces.put(1, btpl);
    }

    public boolean isPlayerInList(UUID uuid) {
        boolean r1 = false;
        boolean r2 = false;
        if (this.players[0] != null) {
            boolean bl = r1 = this.players[0].compareTo(uuid) == 0;
        }
        if (this.players[1] != null) {
            r2 = this.players[1].compareTo(uuid) == 0;
        }
        return r1 || r2;
    }

    @Override
    public void tick() {
        this.grid.tick();
        if (this.whiteTimeLeft != -1 && this.blackTimeLeft != -1 && this.gameTimers[0] != null && this.gameTimers[1] != null) {
            this.gameTimers[0].tick(this.currentTurn == 0);
            this.gameTimers[1].tick(this.currentTurn == 1);
        }
    }

    public void playSound(class_3414 sound) {
        this.getWorld().method_8396(null, this.blockEntity.method_11016(), sound, class_3419.field_15245, 1.0f, 1.0f);
    }

    public void setResignOfferRole(int role) {
        class_1657 player;
        this.resignOfferRole = role;
        if (role != -1 && (player = this.getWorld().method_18470(this.players[role])) != null) {
            this.getWorld().method_18470(this.players[role]).method_17356(ModSounds.NOTIFY, class_3419.field_15245, 1.0f, 1.0f);
        }
        this.updateClient();
    }

    public void setDrawOfferRole(int role) {
        class_1657 player;
        this.drawOfferRole = role;
        if (role != -1 && (player = this.getWorld().method_18470(this.players[role == 0 ? 1 : 0])) != null) {
            player.method_17356(ModSounds.NOTIFY, class_3419.field_15245, 1.0f, 1.0f);
        }
        this.updateClient();
    }

    @Override
    public void afterSwitch() {
        ((ChessGameOverState)this.blockEntity.states.get(2)).transferData(this, this.players, this.gameOverReason, this.winnerRole);
    }

    @Override
    public void clear() {
        this.players = new UUID[2];
        this.playersTakenPieces = new HashMap<Integer, List<Integer>>();
        this.piecesData = new PiecesData(this);
        this.gameOverReason = ChessGameOverReason.NONE;
        this.winnerRole = -1;
        this.currentTurn = 0;
        this.currentChosenCell = new Vector2i(-1, -1);
        this.currentChosenPiece = ChessPieces.EMPTY.id;
        this.gameTimers = new Timer[2];
        this.resignOfferRole = -1;
        this.drawOfferRole = -1;
        this.updateClient();
    }

    public ChessGrid getGrid() {
        return this.grid;
    }

    public UUID[] getPlayers() {
        return this.players;
    }

    public Map<Integer, List<Integer>> getTakenPieces() {
        return this.playersTakenPieces;
    }
}

