/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.chess.gameStates;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.fieldb0y.wanna_play_chess.block.entity.ChessBoardBlockEntity;
import net.fieldb0y.wanna_play_chess.chess.ChessGrid;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameState;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessState;
import net.fieldb0y.wanna_play_chess.chess.utils.ChessGameOverReason;
import net.fieldb0y.wanna_play_chess.utils.GameState;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import org.joml.Vector2i;

public class ChessGameOverState
extends ChessState {
    private ChessGrid grid;
    public UUID[] players = new UUID[2];
    public ChessGameOverReason gameOverReason;
    public int winnerRole;
    public Vector2i matedKingCell;

    public ChessGameOverState(ChessBoardBlockEntity blockEntity) {
        super(blockEntity, List.of(GameState.GAME_OVER));
        this.grid = new ChessGrid(blockEntity);
    }

    public void transferData(ChessGameState chessGameState, UUID[] players, ChessGameOverReason gameOverReason, int winnerRole) {
        this.grid = chessGameState.getGrid();
        this.gameOverReason = gameOverReason;
        this.winnerRole = winnerRole;
        this.players = Arrays.copyOf(players, 2);
        this.matedKingCell = this.grid.findPiecePos(chessGameState.getCheckedKing());
        this.updateClient();
    }

    @Override
    public void writeNbt(class_2487 nbt) {
        class_2499 list = new class_2499();
        for (int i = 0; i < this.players.length; ++i) {
            UUID uuid = this.players[i];
            if (uuid == null) continue;
            list.method_10531(i, (class_2520)class_2512.method_25929((UUID)uuid));
        }
        nbt.method_10566("Players", (class_2520)list);
        this.grid.writeNbt(nbt);
        nbt.method_10569("GameOverReason", this.gameOverReason.nbtValue);
        nbt.method_10569("WinnerRole", this.winnerRole);
        nbt.method_10572("MatedKingCell", List.of(Integer.valueOf(this.matedKingCell.x), Integer.valueOf(this.matedKingCell.y)));
    }

    @Override
    public void readNbt(class_2487 nbt) {
        if (nbt.method_10545("Players")) {
            class_2499 list = (class_2499)nbt.method_10580("Players");
            for (int i = 0; i < 2; ++i) {
                if (i >= list.size()) continue;
                this.players[i] = class_2512.method_25930((class_2520)list.method_10534(i));
            }
        }
        this.grid.readNbt(nbt);
        if (nbt.method_10545("GameOverReason")) {
            this.gameOverReason = ChessGameOverReason.getWithNbtValue(nbt.method_10550("GameOverReason"));
        }
        if (nbt.method_10545("WinnerRole")) {
            this.winnerRole = nbt.method_10550("WinnerRole");
        }
        if (nbt.method_10545("MatedKingCell")) {
            int[] array = nbt.method_10561("MatedKingCell");
            this.matedKingCell = new Vector2i(array[0], array[1]);
        }
    }

    @Override
    public void afterSwitch() {
        for (ChessState state : this.blockEntity.states) {
            state.clear();
        }
    }

    @Override
    public void clear() {
        this.grid.clearGrid();
        this.updateClient();
    }

    public boolean isPlayerInList(UUID uuid) {
        return this.players[0].compareTo(uuid) == 0 || this.players[1].compareTo(uuid) == 0;
    }

    public ChessGrid getGrid() {
        return this.grid;
    }
}

