/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.chess;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameState;
import net.fieldb0y.wanna_play_chess.chess.utils.ChessPieces;
import net.minecraft.class_2487;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import org.joml.Vector2i;

public class PiecesData {
    private Map<Vector2i, List<DataTag>> data = new HashMap<Vector2i, List<DataTag>>();
    public ChessGameState state;

    public PiecesData(ChessGameState state) {
        this.state = state;
    }

    public List<DataTag> getData(int x, int y) {
        if (this.hasData(x, y)) {
            return this.data.get(new Vector2i(x, y));
        }
        return List.of();
    }

    public void putData(int x, int y, List<DataTag> tags) {
        ArrayList<DataTag> realTags = new ArrayList<DataTag>();
        Vector2i cell = new Vector2i(x, y);
        for (DataTag tag : tags) {
            if (this.state.getGrid().safeGetPieceId(x, y) == -1) continue;
            realTags.add(tag);
        }
        if (this.data.containsKey(cell)) {
            for (DataTag tag : realTags) {
                if (this.data.get(cell).contains((Object)tag)) continue;
                this.data.get(cell).add(tag);
            }
        } else {
            this.data.put(cell, realTags);
        }
        this.state.updateClient();
    }

    public void removeData(int x, int y, DataTag tag) {
        if (this.hasDataTag(x, y, tag)) {
            if (this.data.get(new Vector2i(x, y)).size() <= 1) {
                this.clearData(x, y);
            } else {
                this.data.get(new Vector2i(x, y)).remove((Object)tag);
            }
            this.state.updateClient();
        }
    }

    public void clearData(int x, int y) {
        if (this.hasData(x, y)) {
            this.data.get(new Vector2i(x, y)).clear();
            this.data.keySet().remove(new Vector2i(x, y));
            this.state.updateClient();
        }
    }

    public boolean hasDataTag(int x, int y, DataTag tag) {
        Vector2i pos = new Vector2i(x, y);
        return this.data.containsKey(pos) && this.data.get(pos).contains((Object)tag);
    }

    public boolean hasData(int x, int y) {
        return this.data.containsKey(new Vector2i(x, y));
    }

    public void saveData(class_2487 nbt) {
        class_2499 piecesDataNbtList = new class_2499();
        for (Map.Entry<Vector2i, List<DataTag>> entry : this.data.entrySet()) {
            Vector2i pos = entry.getKey();
            List<DataTag> tags = entry.getValue();
            class_2499 tagsList = new class_2499();
            for (DataTag tag : tags) {
                tagsList.add((Object)class_2497.method_23247((int)tag.nbtValue));
            }
            class_2487 entryCompound = new class_2487();
            entryCompound.method_10539("Pos", new int[]{pos.x, pos.y});
            entryCompound.method_10566("Tags", (class_2520)tagsList);
            piecesDataNbtList.add((Object)entryCompound);
        }
        nbt.method_10566("PiecesData", (class_2520)piecesDataNbtList);
    }

    public void readData(class_2487 nbt) {
        this.data.clear();
        class_2499 piecesDataNbtList = nbt.method_10554("PiecesData", 10);
        for (class_2520 element : piecesDataNbtList) {
            class_2487 entryCompound = (class_2487)element;
            int[] posArray = entryCompound.method_10561("Pos");
            Vector2i pos = new Vector2i(posArray[0], posArray[1]);
            class_2499 tagsList = entryCompound.method_10554("Tags", 3);
            ArrayList<DataTag> tags = new ArrayList<DataTag>();
            block1: for (class_2520 tagElement : tagsList) {
                int nbtValue = ((class_2497)tagElement).method_10701();
                for (DataTag tag : DataTag.values()) {
                    if (tag.nbtValue != nbtValue) continue;
                    tags.add(tag);
                    continue block1;
                }
            }
            this.data.put(pos, tags);
        }
    }

    public String toString() {
        return this.data.toString();
    }

    public static enum DataTag {
        JUST_MOVED_2CELLS(List.of(Integer.valueOf(ChessPieces.WHITE_PAWN.id), Integer.valueOf(ChessPieces.BLACK_PAWN.id)), 0),
        ONE_TURN(ChessPieces.getAllIds(), 1),
        CHECKED(List.of(Integer.valueOf(ChessPieces.WHITE_KING.id), Integer.valueOf(ChessPieces.BLACK_KING.id)), 2),
        GIVES_CHECK(ChessPieces.getAllIdsExcept(List.of(Integer.valueOf(ChessPieces.WHITE_KING.id), Integer.valueOf(ChessPieces.BLACK_KING.id))), 3),
        CANT_MOVE(ChessPieces.getAllIdsExcept(List.of(Integer.valueOf(ChessPieces.WHITE_KING.id), Integer.valueOf(ChessPieces.BLACK_KING.id))), 4),
        CAN_CASTLE_SHORT(List.of(Integer.valueOf(ChessPieces.WHITE_KING.id), Integer.valueOf(ChessPieces.BLACK_KING.id)), 5),
        CAN_CASTLE_LONG(List.of(Integer.valueOf(ChessPieces.WHITE_KING.id), Integer.valueOf(ChessPieces.BLACK_KING.id)), 6),
        ALREADY_MOVED(ChessPieces.getAllIds(), 7),
        SHOULD_TURN(List.of(Integer.valueOf(ChessPieces.WHITE_PAWN.id), Integer.valueOf(ChessPieces.BLACK_PAWN.id)), 8);

        public List<Integer> pieces;
        public int nbtValue;

        private DataTag(List<Integer> pieces, int nbtValue) {
            this.pieces = pieces;
            this.nbtValue = nbtValue;
        }
    }
}

