/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.chess;

import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.fieldb0y.wanna_play_chess.block.custom.ChessBoardBlock;
import net.fieldb0y.wanna_play_chess.block.entity.ChessBoardBlockEntity;
import net.fieldb0y.wanna_play_chess.block.entity.renderer.PieceAnimator;
import net.fieldb0y.wanna_play_chess.chess.PiecesData;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameState;
import net.fieldb0y.wanna_play_chess.chess.utils.ChessPieces;
import net.fieldb0y.wanna_play_chess.chess.utils.PieceAction;
import net.fieldb0y.wanna_play_chess.item.custom.ChessPiece;
import net.fieldb0y.wanna_play_chess.sound.ModSounds;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2769;
import org.joml.Math;
import org.joml.Vector2i;
import org.joml.Vector3f;

public class ChessGrid {
    public static final int SIZE = 8;
    public ChessBoardBlockEntity blockEntity;
    public int[][] data = new int[8][8];
    private class_2350 direction;
    public PieceAnimator pieceAnimator;

    public ChessGrid(ChessBoardBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
        this.direction = (class_2350)blockEntity.method_11010().method_11654((class_2769)ChessBoardBlock.FACING);
        this.pieceAnimator = new PieceAnimator(this);
    }

    public void genStartingPosition() {
        int i;
        for (i = 0; i < 8; ++i) {
            this.putPiece(ChessPieces.WHITE_PAWN.id, i, 6, false);
        }
        this.putPiece(ChessPieces.WHITE_ROOK.id, 0, 7, false);
        this.putPiece(ChessPieces.WHITE_KNIGHT.id, 1, 7, false);
        this.putPiece(ChessPieces.WHITE_BISHOP.id, 2, 7, false);
        this.putPiece(ChessPieces.WHITE_QUEEN.id, 3, 7, false);
        this.putPiece(ChessPieces.WHITE_KING.id, 4, 7, false);
        this.putPiece(ChessPieces.WHITE_BISHOP.id, 5, 7, false);
        this.putPiece(ChessPieces.WHITE_KNIGHT.id, 6, 7, false);
        this.putPiece(ChessPieces.WHITE_ROOK.id, 7, 7, false);
        for (i = 0; i < 8; ++i) {
            this.putPiece(ChessPieces.BLACK_PAWN.id, i, 1, false);
        }
        this.putPiece(ChessPieces.BLACK_ROOK.id, 0, 0, false);
        this.putPiece(ChessPieces.BLACK_KNIGHT.id, 1, 0, false);
        this.putPiece(ChessPieces.BLACK_BISHOP.id, 2, 0, false);
        this.putPiece(ChessPieces.BLACK_QUEEN.id, 3, 0, false);
        this.putPiece(ChessPieces.BLACK_KING.id, 4, 0, false);
        this.putPiece(ChessPieces.BLACK_BISHOP.id, 5, 0, false);
        this.putPiece(ChessPieces.BLACK_KNIGHT.id, 6, 0, false);
        this.putPiece(ChessPieces.BLACK_ROOK.id, 7, 0, false);
        this.blockEntity.updateClient();
    }

    public void clearGrid() {
        this.data = new int[8][8];
        this.direction = (class_2350)this.blockEntity.method_11010().method_11654((class_2769)ChessBoardBlock.FACING);
        this.pieceAnimator = new PieceAnimator(this);
        this.blockEntity.updateClient();
    }

    public void writeNbt(class_2487 nbt) {
        class_2499 grid = new class_2499();
        for (int[] row : this.data) {
            grid.add((Object)new class_2495(row));
        }
        nbt.method_10566("GridData", (class_2520)grid);
        nbt.method_10548("Direction", this.direction.method_10144());
        class_2487 animData = new class_2487();
        this.pieceAnimator.writeNbt(animData);
        nbt.method_10566("AnimData", (class_2520)animData);
    }

    public void readNbt(class_2487 nbt) {
        if (nbt.method_10545("GridData")) {
            class_2499 grid = (class_2499)nbt.method_10580("GridData");
            for (int i = 0; i < 8; ++i) {
                if (i >= grid.size()) continue;
                int[] savedRow = ((class_2495)grid.method_10534(i)).method_10588();
                System.arraycopy(savedRow, 0, this.data[i], 0, Math.min((int)savedRow.length, (int)8));
            }
        }
        if (nbt.method_10545("Direction")) {
            this.direction = class_2350.method_10150((double)nbt.method_10583("Direction"));
        }
        if (nbt.method_10545("AnimData")) {
            class_2487 animData = nbt.method_10562("AnimData");
            this.pieceAnimator.readNbt(animData);
        }
    }

    public void putPiece(int piece, int x, int y) {
        this.data[x][y] = piece;
        this.blockEntity.updateClient();
    }

    public void putPiece(int piece, int x, int y, boolean updateClient) {
        this.data[x][y] = piece;
        if (updateClient) {
            this.blockEntity.updateClient();
        }
    }

    public void playPieceMovingAnimation(int fromX, int fromY, int toX, int toY) {
        this.pieceAnimator.playAnimation(new Vector2i(fromX, fromY), new Vector2i(toX, toY));
    }

    public void movePiece(int fromX, int fromY, int toX, int toY) {
        int pieceId = this.safeGetPieceId(fromX, fromY);
        if (pieceId != -1 && pieceId != ChessPieces.EMPTY.id) {
            this.playPieceMovingAnimation(fromX, fromY, toX, toY);
            this.data[toX][toY] = pieceId;
            this.data[fromX][fromY] = ChessPieces.EMPTY.id;
            this.blockEntity.updateClient();
        }
    }

    public void removePiece(int x, int y) {
        this.data[x][y] = ChessPieces.EMPTY.id;
    }

    public Map<PieceAction, List<Vector2i>> getPossibleMoves(int x, int y) {
        int pieceId = this.data[x][y];
        if (pieceId == ChessPieces.EMPTY.id) {
            return Map.of();
        }
        ChessPiece piece = ChessGrid.getPieceById(pieceId);
        int role = ChessGrid.getPieceRole(pieceId);
        return piece.getPossibleMoves(x, y, role, this);
    }

    public boolean isCellUnderAttack(int x, int y, int role) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int pieceId = this.safeGetPieceId(i, j);
                if (pieceId == ChessPieces.EMPTY.id || pieceId == -1 || ChessGrid.getPieceRole(pieceId) == role) continue;
                ChessPiece piece = ChessGrid.getPieceById(pieceId);
                Map<PieceAction, List<Vector2i>> possibleMoves = piece.getPossibleMoves(i, j, ChessGrid.getPieceRole(pieceId), this);
                for (PieceAction action : possibleMoves.keySet()) {
                    if ((pieceId == ChessPieces.WHITE_PAWN.id || pieceId == ChessPieces.BLACK_PAWN.id) && action == PieceAction.MOVE || !possibleMoves.get((Object)action).contains(new Vector2i(x, y))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isCellInArea(Vector2i cell, Vector2i areaCenter, int areaRadius) {
        int areaStartX = areaCenter.x - areaRadius;
        int areaStartY = areaCenter.y - areaRadius;
        int areaDiameter = areaRadius * 2 + 1;
        for (int i = 0; i < areaDiameter; ++i) {
            for (int j = 0; j < areaDiameter; ++j) {
                int x = areaStartX + i;
                int y = areaStartY + j;
                int pieceId = this.safeGetPieceId(x, y);
                if (pieceId == -1 || !cell.equals(x, y)) continue;
                return true;
            }
        }
        return false;
    }

    public List<Vector2i> getPiecesCellsByRole(int role) {
        ArrayList<Vector2i> cells = new ArrayList<Vector2i>();
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int pieceId = this.safeGetPieceId(i, j);
                if (ChessGrid.getPieceRole(pieceId) != role) continue;
                cells.add(new Vector2i(i, j));
            }
        }
        return cells;
    }

    public static ChessPiece getPieceById(int id) {
        return Arrays.stream(ChessPieces.values()).filter((Predicate<ChessPieces>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getPieceById$0(int net.fieldb0y.wanna_play_chess.chess.utils.ChessPieces ), (Lnet/fieldb0y/wanna_play_chess/chess/utils/ChessPieces;)Z)((int)id)).toList().getFirst().item;
    }

    public boolean isAnyOfPiecesOnBoard(List<Integer> pieces) {
        for (int pieceId : pieces) {
            if (this.findPiecePos(pieceId).equals(-1, -1)) continue;
            return true;
        }
        return false;
    }

    public int safeGetPieceId(int x, int y) {
        if (x >= 8 || y >= 8 || x < 0 || y < 0) {
            return -1;
        }
        return this.data[x][y];
    }

    public static int getPieceRole(int pieceId) {
        return pieceId > 0 && pieceId <= 6 ? 0 : (pieceId != 0 ? 1 : -1);
    }

    public void rotateToPlayer(UUID[] playersUUIDs) {
        int orientationPlayer;
        class_1937 world = this.blockEntity.method_10997();
        class_1657 whitePlayer = world.method_18470(playersUUIDs[0]);
        class_1657 blackPlayer = world.method_18470(playersUUIDs[1]);
        int n = whitePlayer != null ? 0 : (orientationPlayer = blackPlayer != null ? 1 : -1);
        if (orientationPlayer == 0) {
            this.direction = this.getDirectionToPlayer(whitePlayer).method_10153();
        } else if (orientationPlayer == 1) {
            this.direction = this.getDirectionToPlayer(blackPlayer);
        }
        this.blockEntity.updateClient();
    }

    public void tick() {
        this.pieceAnimator.getProgress();
    }

    private class_2350 getDirectionToPlayer(class_1657 player) {
        Vector3f playerOffset = new Vector3f((float)(this.blockEntity.method_11016().method_10263() - player.method_31477()), (float)(this.blockEntity.method_11016().method_10264() - player.method_31478()), (float)(this.blockEntity.method_11016().method_10260() - player.method_31479()));
        class_2350 directionToPlayer = class_2350.field_11043;
        if (this.maxComponentXZ(playerOffset) == 0) {
            directionToPlayer = playerOffset.x > 0.0f ? class_2350.field_11039 : class_2350.field_11034;
        } else if (this.maxComponentXZ(playerOffset) == 1) {
            directionToPlayer = playerOffset.z > 0.0f ? class_2350.field_11043 : class_2350.field_11035;
        }
        return directionToPlayer;
    }

    public int maxComponentXZ(Vector3f vector3f) {
        float absZ;
        float absX = Math.abs((float)vector3f.x);
        if (absX >= (absZ = Math.abs((float)vector3f.z))) {
            return 0;
        }
        return 1;
    }

    public List<Vector2i> getCheckingPiecesCells() {
        ArrayList<Vector2i> checkingPiecesCells = new ArrayList<Vector2i>();
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                if (!this.getGameState().piecesData.hasDataTag(i, j, PiecesData.DataTag.GIVES_CHECK)) continue;
                checkingPiecesCells.add(new Vector2i(i, j));
            }
        }
        return checkingPiecesCells;
    }

    public Vector2i findPiecePos(int pieceId) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int id = this.safeGetPieceId(i, j);
                if (id != pieceId) continue;
                return new Vector2i(i, j);
            }
        }
        return new Vector2i(-1, -1);
    }

    public List<Vector2i> findPiecesPos(int pieceId) {
        ArrayList<Vector2i> positions = new ArrayList<Vector2i>();
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                int id = this.safeGetPieceId(i, j);
                if (id != pieceId) continue;
                positions.add(new Vector2i(i, j));
            }
        }
        return positions;
    }

    public ChessPiece getPieceAt(int x, int y) {
        return ChessGrid.getPieceById(this.safeGetPieceId(x, y));
    }

    public ChessGameState getGameState() {
        if (this.blockEntity.currentState == this.blockEntity.states.get(1)) {
            return (ChessGameState)this.blockEntity.currentState;
        }
        return null;
    }

    public class_2350 getDirection() {
        return this.direction;
    }

    public void turnPawnInto(Vector2i cell, int turnToId) {
        int pieceId = this.safeGetPieceId(cell.x, cell.y);
        if (pieceId == ChessPieces.WHITE_PAWN.id || pieceId == ChessPieces.BLACK_PAWN.id) {
            this.putPiece(turnToId, cell.x, cell.y);
            ((ChessGameState)this.blockEntity.currentState).playSound(ModSounds.PROMOTE);
        }
    }

    public String toString() {
        return Arrays.deepToString((Object[])this.data);
    }

    private static /* synthetic */ boolean lambda$getPieceById$0(int id, ChessPieces value) {
        return value.id == id;
    }
}

