/*
 * Decompiled with CFR 0.152.
 */
package net.fieldb0y.wanna_play_chess.block.entity;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.fieldb0y.wanna_play_chess.block.custom.ChessBoardBlock;
import net.fieldb0y.wanna_play_chess.block.entity.ModBlockEntities;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameOverState;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessGameState;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessLobbyState;
import net.fieldb0y.wanna_play_chess.chess.gameStates.ChessState;
import net.fieldb0y.wanna_play_chess.item.ModComponents;
import net.fieldb0y.wanna_play_chess.network.c2sPayloads.BlockPosPayload;
import net.fieldb0y.wanna_play_chess.screenhandler.ChessBoardScreenHandler;
import net.fieldb0y.wanna_play_chess.utils.GameState;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import org.jetbrains.annotations.Nullable;

public class ChessBoardBlockEntity
extends class_2586
implements ExtendedScreenHandlerFactory<BlockPosPayload> {
    public static final int LOBBY_STATE = 0;
    public static final int GAME_STATE = 1;
    public static final int GAME_OVER_STATE = 2;
    private GameState gameState;
    public List<ChessState> states = new ArrayList<ChessState>();
    public ChessState currentState;
    public boolean whiteSetInsereted;
    public boolean blackSetInserted;

    public ChessBoardBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.CHESS_BOARD_BLOCK_ENTITY, pos, state);
        this.setGameState(Arrays.stream(GameState.values()).filter(value -> value.nbtValue == (Integer)state.method_11654((class_2769)ChessBoardBlock.GAME_STATE)).toList().getFirst());
        this.setupStates();
    }

    private void setupStates() {
        this.states.add(new ChessLobbyState(this));
        this.states.add(new ChessGameState(this));
        this.states.add(new ChessGameOverState(this));
        if (this.currentState == null) {
            for (ChessState state : this.states) {
                if (!state.shouldUse()) continue;
                this.currentState = state;
                break;
            }
        }
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state) {
        this.changeGameStates();
        if (!world.method_8608()) {
            this.currentState.tick();
        }
    }

    public void changeGameStates() {
        ChessLobbyState chessLobbyState = (ChessLobbyState)this.states.get(0);
        if (this.gameState == GameState.NOT_READY_TO_PLAY && (chessLobbyState.getPlayersInLobby()[0] != null && chessLobbyState.getPlayersInLobby()[1] == null || chessLobbyState.getPlayersInLobby()[0] == null && chessLobbyState.getPlayersInLobby()[1] != null)) {
            this.setGameState(GameState.READY_FOR_SINGLEPLAYER_GAME);
        }
        if (this.gameState == GameState.READY_FOR_SINGLEPLAYER_GAME && chessLobbyState.getPlayersInLobby()[0] != null && chessLobbyState.getPlayersInLobby()[1] != null) {
            this.setGameState(GameState.READY_TO_PLAY);
        }
        if ((this.gameState == GameState.READY_TO_PLAY || this.gameState == GameState.READY_FOR_SINGLEPLAYER_GAME) && chessLobbyState.getPlayersInLobby()[0] == null && chessLobbyState.getPlayersInLobby()[1] == null) {
            this.setGameState(GameState.NOT_READY_TO_PLAY);
        }
        if (this.currentState != null && !this.currentState.shouldUse()) {
            for (ChessState state : this.states) {
                if (!state.shouldUse()) continue;
                this.currentState.afterSwitch();
                this.currentState = state;
                break;
            }
        }
    }

    public void insertPiecesSet(int role) {
        if (role == 0) {
            this.whiteSetInsereted = true;
        } else {
            this.blackSetInserted = true;
        }
        this.updateClient();
    }

    public void removePiecesSet(int role) {
        if (role == 0) {
            this.whiteSetInsereted = false;
        } else {
            this.blackSetInserted = false;
        }
        this.updateClient();
    }

    public boolean isSetInserted(int role) {
        return role == 0 ? this.whiteSetInsereted : this.blackSetInserted;
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        this.currentState.writeNbt(nbt);
        nbt.method_10569("GameState", this.gameState.nbtValue);
        nbt.method_10556("WhiteSetInserted", this.whiteSetInsereted);
        nbt.method_10556("BlackSetInserted", this.blackSetInserted);
    }

    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        if (nbt.method_10573("GameState", 3)) {
            this.gameState = Arrays.stream(GameState.values()).filter(value -> value.nbtValue == nbt.method_10550("GameState")).toList().getFirst();
        }
        if (nbt.method_10545("WhiteSetInserted")) {
            this.whiteSetInsereted = nbt.method_10577("WhiteSetInserted");
        }
        if (nbt.method_10545("BlackSetInserted")) {
            this.blackSetInserted = nbt.method_10577("BlackSetInserted");
        }
        this.currentState.readNbt(nbt);
    }

    protected void method_57567(class_9323.class_9324 componentMapBuilder) {
        super.method_57567(componentMapBuilder);
        componentMapBuilder.method_57840(ModComponents.INSERTED_PIECES_SETS, List.of(Boolean.valueOf(this.whiteSetInsereted), Boolean.valueOf(this.blackSetInserted)));
    }

    protected void method_57568(class_2586.class_9473 components) {
        super.method_57568(components);
        List list = (List)components.method_58695(ModComponents.INSERTED_PIECES_SETS, Collections.emptyList());
        if (list.size() > 1) {
            this.whiteSetInsereted = (Boolean)list.getFirst();
            this.blackSetInserted = (Boolean)list.getLast();
        }
    }

    public void setGameState(GameState gameState) {
        this.gameState = gameState;
        if ((Integer)this.method_11010().method_11654((class_2769)ChessBoardBlock.GAME_STATE) != gameState.nbtValue) {
            this.method_10997().method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)ChessBoardBlock.GAME_STATE, (Comparable)Integer.valueOf(gameState.nbtValue)));
        }
        this.updateClient();
    }

    public BlockPosPayload getScreenOpeningData(class_3222 serverPlayerEntity) {
        return new BlockPosPayload(this.field_11867);
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Chess Board");
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new ChessBoardScreenHandler(syncId, playerInventory, this);
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public void updateClient() {
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public GameState getGameState() {
        return this.gameState;
    }
}

