/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.wiretap.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.util.UUIDTypeAdapter;
import de.maxhenkel.wiretap.Wiretap;
import de.maxhenkel.wiretap.item.MicrophoneDevice;
import de.maxhenkel.wiretap.item.SpeakerDevice;
import de.maxhenkel.wiretap.item.WiretapDevice;
import de.maxhenkel.wiretap.wiretap.DeviceType;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9290;
import net.minecraft.class_9296;
import net.minecraft.class_9334;

public class HeadUtils {
    public static final String NBT_DEVICE = "wiretap_data";
    public static final String NBT_IS_SPEAKER = "is_speaker";
    public static final String NBT_PAIR_ID = "pair_id";
    public static final String NBT_SPEAKER_RANGE = "speaker_range";
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(UUID.class, (Object)new UUIDTypeAdapter()).create();

    public static Optional<class_1799> createMicrophone(UUID id) {
        MicrophoneDevice deviceData = new MicrophoneDevice(id);
        return HeadUtils.createHead(deviceData);
    }

    public static Optional<class_1799> createSpeaker(UUID id) {
        return HeadUtils.createSpeakerWithForcedRange(id, null);
    }

    public static Optional<class_1799> createSpeakerWithForcedRange(UUID id, Float range) {
        SpeakerDevice deviceData = new SpeakerDevice(id, range);
        return HeadUtils.createHead(deviceData);
    }

    public static Optional<class_1799> createHead(WiretapDevice device) {
        class_9290 lore;
        SpeakerDevice speakerDevice;
        if (device == null) {
            throw new IllegalArgumentException("Device data cannot be null while creating head item");
        }
        DeviceType type = device.getDeviceType();
        if (type == DeviceType.NON_WIRETAP) {
            Wiretap.LOGGER.warn("Failed to create head - type of device passed in was NON_WIRETAP. Data must be scuffed.", new Throwable("Trace"));
            return Optional.empty();
        }
        class_1799 stack = new class_1799((class_1935)class_1802.field_8575);
        GameProfile gameProfile = HeadUtils.getGameProfile(device.getPairUUID(), type.getInternalName(), type.getSkinURL());
        class_5250 nameComponent = class_2561.method_43470((String)type.getDisplayName()).method_27694(style -> style.method_10978(Boolean.valueOf(false)).method_10977(class_124.field_1068));
        class_5250 loreIdComponent = class_2561.method_43470((String)"ID: %s".formatted(device.getPairUUID().toString())).method_27694(style -> style.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1080);
        if (device instanceof SpeakerDevice && (speakerDevice = (SpeakerDevice)device).isUsingRangeOverride()) {
            float range = speakerDevice.getActiveRange();
            class_5250 speakerRadius = range < 0.0f ? class_2561.method_43470((String)"Radius: Infinite") : class_2561.method_43470((String)"Radius: %.1f blocks".formatted(Float.valueOf(range)));
            lore = new class_9290(List.of(loreIdComponent, speakerRadius.method_27694(style -> style.method_10978(Boolean.valueOf(false))).method_27692(class_124.field_1080)));
        } else {
            lore = new class_9290(List.of(loreIdComponent));
        }
        device.serialiseIntoItemStack(stack);
        stack.method_57379(class_9334.field_49632, (Object)lore);
        stack.method_57379(class_9334.field_49631, (Object)nameComponent);
        class_9296 resolvableProfile = new class_9296(gameProfile);
        stack.method_57379(class_9334.field_49617, (Object)resolvableProfile);
        return Optional.of(stack);
    }

    private static GameProfile getGameProfile(UUID uuid, String name, String skinUrl) {
        GameProfile gameProfile = new GameProfile(uuid, name);
        PropertyMap properties = gameProfile.getProperties();
        ArrayList<Property> textures = new ArrayList<Property>();
        HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture> textureMap = new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        textureMap.put(MinecraftProfileTexture.Type.SKIN, new MinecraftProfileTexture(skinUrl, null));
        String json = gson.toJson((Object)new MinecraftTexturesPayload(textureMap));
        String base64Payload = Base64.getEncoder().encodeToString(json.getBytes(StandardCharsets.UTF_8));
        textures.add(new Property("textures", base64Payload));
        properties.putAll((Object)"textures", textures);
        return gameProfile;
    }

    private static class MinecraftTexturesPayload {
        private final Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures;

        public MinecraftTexturesPayload(Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures) {
            this.textures = textures;
        }

        public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextures() {
            return this.textures;
        }
    }
}

