/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.wiretap.item;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.maxhenkel.wiretap.item.MicrophoneDevice;
import de.maxhenkel.wiretap.item.SpeakerDevice;
import de.maxhenkel.wiretap.wiretap.DeviceType;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_4844;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public abstract class WiretapDevice {
    public static final float INFINITE_RANGE = -1.0f;
    public static final Codec<WiretapDevice> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)class_4844.field_25122.fieldOf("pair_id").forGetter(WiretapDevice::getPairUUID), (App)Codec.BOOL.fieldOf("is_speaker").forGetter(WiretapDevice::isSpeaker), (App)Codec.FLOAT.optionalFieldOf("speaker_range", (Object)Float.valueOf(-1.0f)).forGetter(WiretapDevice::getSerialisationRange)).apply((Applicative)builder, WiretapDevice::createDeviceData));
    private final DeviceType deviceType;
    private final UUID pairUUID;

    protected WiretapDevice(DeviceType deviceType, UUID pairUUID) {
        this.deviceType = deviceType;
        this.pairUUID = pairUUID;
    }

    public UUID getPairUUID() {
        return this.pairUUID;
    }

    public DeviceType getDeviceType() {
        return this.deviceType;
    }

    public boolean isSpeaker() {
        return this.deviceType == DeviceType.SPEAKER;
    }

    protected Float getSerialisationRange() {
        return null;
    }

    public Codec<WiretapDevice> getSerialisationCodec() {
        return CODEC;
    }

    public void serialiseIntoItemStack(class_1799 item) {
        class_9279 data = (class_9279)item.method_57824(class_9334.field_49628);
        class_9279 newData = this.saveToNewCustomData(data);
        item.method_57379(class_9334.field_49628, (Object)newData);
    }

    public class_9279 saveToNewCustomData() {
        return this.saveToNewCustomData(null);
    }

    public class_9279 saveToNewCustomData(class_9279 mergeWith) {
        class_2487 workingTag = mergeWith == null ? new class_2487() : mergeWith.method_57461();
        workingTag.method_10566("wiretap_data", (class_2520)this.getSerialisationCodec().encodeStart((DynamicOps)class_2509.field_11560, (Object)this).getOrThrow());
        return class_9279.method_57456((class_2487)workingTag);
    }

    public static WiretapDevice createDeviceData(UUID pairUUID, boolean isSpeaker) {
        return WiretapDevice.createDeviceData(pairUUID, isSpeaker, null);
    }

    public static WiretapDevice createDeviceData(UUID pairUUID, boolean isSpeaker, Float range) {
        return isSpeaker ? new SpeakerDevice(pairUUID, range) : new MicrophoneDevice(pairUUID);
    }

    public String toString() {
        return "WiretapDevice{deviceType=" + String.valueOf((Object)this.deviceType) + ", pairUUID=" + String.valueOf(this.pairUUID) + ", range?=" + this.getSerialisationRange() + "}";
    }
}

