/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.wiretap.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.maxhenkel.wiretap.Wiretap;
import de.maxhenkel.wiretap.utils.HeadUtils;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class WiretapCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 ctx, class_2170.class_5364 environment) {
        LiteralArgumentBuilder literalBuilder = (LiteralArgumentBuilder)class_2170.method_9247((String)"wiretap").requires(commandSource -> commandSource.method_9259(Wiretap.SERVER_CONFIG.commandPermissionLevel.get().intValue()));
        literalBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"items").requires(class_2168::method_43737)).executes(WiretapCommands::runWithoutRange)).then(class_2170.method_9244((String)"speaker_radius", (ArgumentType)FloatArgumentType.floatArg((float)0.0f)).executes(WiretapCommands::runWithRange))).then(class_2170.method_9247((String)"infinite").executes(WiretapCommands::runWithInfiniteRange)));
        dispatcher.register(literalBuilder);
    }

    public static int runWithoutRange(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        return WiretapCommands.processCommand(player, null);
    }

    public static int runWithRange(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        float range = FloatArgumentType.getFloat(context, (String)"speaker_radius");
        return WiretapCommands.processCommand(player, Float.valueOf(range));
    }

    public static int runWithInfiniteRange(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        return WiretapCommands.processCommand(player, Float.valueOf(-1.0f));
    }

    public static int processCommand(class_3222 player, Float range) {
        try {
            UUID id = UUID.randomUUID();
            Optional<class_1799> microphone = HeadUtils.createMicrophone(id);
            Optional<class_1799> speaker = HeadUtils.createSpeakerWithForcedRange(id, range);
            if (microphone.isPresent() && speaker.isPresent()) {
                player.method_31548().method_7394(microphone.get());
                player.method_31548().method_7394(speaker.get());
                player.method_7353((class_2561)class_2561.method_43470((String)"You have been provided with a wiretap kit."), false);
                return 1;
            }
            player.method_7353((class_2561)class_2561.method_43470((String)"There was an error while spawning in your wiretap kit.").method_27692(class_124.field_1061), false);
            return 0;
        }
        catch (Exception e) {
            player.method_7353((class_2561)class_2561.method_43470((String)"There was an unexpected error while spawning in your wiretap kit.").method_27692(class_124.field_1061), false);
            Wiretap.LOGGER.error("Error caught while executing command", (Throwable)e);
            return 0;
        }
    }
}

