/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.rasterization;

import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiomclientapi.funcinterfaces.TriIntConsumer;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3i;

public class SpiralRasterization {
    public static void archimedean(Vector3i center, int diameterX, int diameterZ, float loops, Quaternionf quaternionf, TriIntConsumer consumer) {
        if (diameterX <= 0 || diameterZ <= 0) {
            return;
        }
        int centerX = center.x;
        int centerY = center.y;
        int centerZ = center.z;
        float radiusX = (float)(diameterX - 1) / 2.0f;
        float radiusZ = (float)(diameterZ - 1) / 2.0f;
        float offsetX = radiusX % 1.0f + 0.5f;
        float offsetZ = radiusZ % 1.0f + 0.5f;
        Vector3f from = new Vector3f(offsetX, 0.5f, offsetZ);
        quaternionf.transformInverse(from);
        Vector3f to = new Vector3f();
        int a = 0;
        while ((float)a <= 360.0f * loops) {
            float amount = (float)a / (360.0f * loops);
            float currX = (float)Math.sin(Math.toRadians(a)) * amount * (radiusX - 0.15f) + offsetX;
            float currZ = (float)Math.cos(Math.toRadians(a)) * amount * (radiusZ - 0.15f) + offsetZ;
            to.set(currX, 0.5f, currZ);
            quaternionf.transformInverse(to);
            Rasterization3D.dda(from, to, (x, y, z) -> consumer.accept(x + centerX, y + centerY, z + centerZ));
            Vector3f temp = from;
            from = to;
            to = temp;
            ++a;
        }
    }
}

