/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor;

import com.mojang.blaze3d.platform.GlStateManager;
import com.moulberry.axiom.VersionUtilsClient;
import com.moulberry.axiom.core_rendering.AxiomGpuTexture;
import com.moulberry.axiom.editor.EditorUI;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.i18n.AxiomI18n;
import imgui.ImGui;
import imgui.ImGuiViewport;
import imgui.ImVec2;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_310;
import org.lwjgl.opengl.GL11;

public class ImageReferenceWindows {
    private static boolean defaultShowInGameUi = false;
    private static boolean defaultBorderless = false;
    private static final List<Reference> references = new ArrayList<Reference>();

    public static void add(class_1011 image) {
        references.add(new Reference(VersionUtilsClient.helperCreateFromNativeImageDynamicTexture(null, image), 0.0f, defaultShowInGameUi, defaultBorderless));
    }

    public static boolean hasReferenceInGameUI() {
        for (Reference reference : references) {
            if (!reference.showInGameUI) continue;
            return true;
        }
        return false;
    }

    public static void render() {
        if (class_310.method_1551().field_1687 == null || class_310.method_1551().field_1724 == null || class_310.method_1551().field_1755 != null) {
            return;
        }
        boolean isInEditor = EditorUI.isActive();
        boolean lastBorderless = false;
        boolean anyMouseDown = ImGui.isAnyMouseDown();
        for (int i = 0; i < references.size(); ++i) {
            Reference reference = references.get(i);
            if (!isInEditor && !reference.showInGameUI) continue;
            if (lastBorderless != reference.borderless) {
                if (reference.borderless) {
                    ImGuiHelper.pushStyleVar(2, 0.0f, 0.0f);
                } else {
                    ImGuiHelper.popStyleVar();
                }
                lastBorderless = reference.borderless;
            }
            ImGui.pushID(i);
            class_1011 nativeImage = reference.texture.method_4525();
            if (nativeImage == null) {
                throw new IllegalArgumentException();
            }
            ImGuiViewport viewport = ImGui.getMainViewport();
            ImGui.setNextWindowPos(viewport.getCenterX(), viewport.getCenterY(), 4, 0.5f, 0.5f);
            float lastWidth = reference.lastWidth;
            if (lastWidth != 0.0f) {
                ImGui.setNextWindowSizeConstraints(64.0f, lastWidth / (float)nativeImage.method_4307() * (float)nativeImage.method_4323(), 2048.0f, lastWidth / (float)nativeImage.method_4307() * (float)nativeImage.method_4323());
            }
            int flags = 257;
            if (reference.borderless) {
                flags |= 0x80;
            }
            if (reference.hasCalculatedCorner && !anyMouseDown) {
                float screenX = reference.cornerX;
                float screenY = reference.cornerY;
                if (EditorUI.isActive()) {
                    screenX += (float)EditorUI.frameX + (float)EditorUI.frameWidth * reference.pivotX;
                    screenY += (float)EditorUI.frameY + (float)EditorUI.frameHeight * reference.pivotY;
                } else {
                    screenX += viewport.getSizeX() * reference.pivotX;
                    screenY += viewport.getSizeY() * reference.pivotY;
                }
                ImGui.setNextWindowPos(screenX, screenY, 1, reference.pivotX, reference.pivotY);
            }
            if (reference.opacity[0] < 0.99f) {
                int col = ImGui.getColorU32(2);
                int opacity = col >> 24 & 0xFF;
                opacity *= (int)(255.0f * reference.opacity[0]);
                col &= 0xFFFFFF;
                ImGuiHelper.pushStyleColor(2, col |= (opacity /= 255) << 24);
            }
            boolean visible = ImGui.begin("##Reference" + String.valueOf(reference.uuid), flags);
            if (reference.opacity[0] < 0.99f) {
                ImGuiHelper.popStyleColor();
            }
            if (visible) {
                float windowWidth = ImGui.getWindowWidth();
                float windowHeight = windowWidth / (float)nativeImage.method_4307() * (float)nativeImage.method_4323();
                ImGui.setWindowSize(windowWidth, windowHeight);
                ImVec2 windowPos = ImGui.getWindowPos();
                if (EditorUI.isActive()) {
                    reference.pivotX = windowPos.x + windowWidth / 2.0f < (float)EditorUI.frameX + (float)EditorUI.frameWidth / 2.0f ? 0.0f : 1.0f;
                    reference.pivotY = windowPos.y + windowHeight / 2.0f < (float)EditorUI.frameY + (float)EditorUI.frameHeight / 2.0f ? 0.0f : 1.0f;
                    reference.cornerX = windowPos.x + windowWidth * reference.pivotX - ((float)EditorUI.frameX + (float)EditorUI.frameWidth * reference.pivotX);
                    reference.cornerY = windowPos.y + windowHeight * reference.pivotY - ((float)EditorUI.frameY + (float)EditorUI.frameHeight * reference.pivotY);
                    reference.hasCalculatedCorner = true;
                }
                reference.lastWidth = windowWidth;
                float availX = ImGui.getContentRegionAvailX();
                float availY = ImGui.getContentRegionAvailY();
                ImGui.image(new AxiomGpuTexture(reference.texture.method_4624()).glId(), availX, availY, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, reference.opacity[0]);
                String popupName = "##EditProperties" + String.valueOf(reference.uuid);
                if (ImGui.isItemClicked(1)) {
                    ImGui.openPopup(popupName);
                }
                if (ImGui.isPopupOpen(popupName)) {
                    boolean borderless = reference.borderless;
                    if (borderless) {
                        ImGuiHelper.popStyleVar();
                    }
                    if (ImGui.beginPopup(popupName)) {
                        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.reference_image.close_window"))) {
                            EditorUI.deferredClose((AutoCloseable)ImageReferenceWindows.references.remove((int)i).texture);
                            --i;
                        }
                        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.reference_image.set_filtering_nearest"))) {
                            GlStateManager._bindTexture((int)new AxiomGpuTexture(reference.texture.method_4624()).glId());
                            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
                            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
                        }
                        if (ImGui.menuItem(AxiomI18n.get("axiom.editorui.reference_image.set_filtering_linear"))) {
                            GlStateManager._bindTexture((int)new AxiomGpuTexture(reference.texture.method_4624()).glId());
                            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
                            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
                            GL11.glTexParameteri((int)3553, (int)10242, (int)33071);
                            GL11.glTexParameteri((int)3553, (int)10243, (int)33071);
                        }
                        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.reference_image.show_in_game_ui"), reference.showInGameUI)) {
                            defaultShowInGameUi = reference.showInGameUI = !reference.showInGameUI;
                        }
                        if (ImGui.checkbox(AxiomI18n.get("axiom.editorui.reference_image.borderless"), reference.borderless)) {
                            defaultBorderless = reference.borderless = !reference.borderless;
                        }
                        ImGui.sliderFloat("Opacity", reference.opacity, 0.0f, 1.0f);
                        ImGui.endPopup();
                    }
                    if (borderless) {
                        ImGuiHelper.pushStyleVar(2, 0.0f, 0.0f);
                    }
                }
            } else {
                EditorUI.deferredClose((AutoCloseable)ImageReferenceWindows.references.remove((int)i).texture);
                --i;
            }
            ImGui.end();
            ImGui.popID();
        }
        if (lastBorderless) {
            ImGuiHelper.popStyleVar();
        }
    }

    private static final class Reference {
        private final UUID uuid = UUID.randomUUID();
        private final class_1043 texture;
        private float lastWidth;
        private boolean showInGameUI;
        private boolean borderless;
        private float[] opacity = new float[]{1.0f};
        private boolean hasCalculatedCorner = false;
        private float cornerX;
        private float cornerY;
        private float pivotX;
        private float pivotY;

        private Reference(class_1043 texture, float lastWidth, boolean showInGameUI, boolean borderless) {
            this.texture = texture;
            this.lastWidth = lastWidth;
            this.showInGameUI = showInGameUI;
            this.borderless = borderless;
        }
    }
}

