/*
 * Decompiled with CFR 0.152.
 */
package toni.sodiumdynamiclights.mixin.lightsource;

import dev.lambdaurora.lambdynlights.api.DynamicLightHandlers;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_761;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import toni.sodiumdynamiclights.DynamicLightSource;
import toni.sodiumdynamiclights.DynamicLightsMode;
import toni.sodiumdynamiclights.SodiumDynamicLights;

@Mixin(value={class_2586.class})
public abstract class BlockEntityMixin
implements DynamicLightSource {
    @Final
    @Shadow
    protected class_2338 field_11867;
    @Shadow
    @Nullable
    protected class_1937 field_11863;
    @Shadow
    protected boolean field_11865;
    @Unique
    private int luminance = 0;
    @Unique
    private int lastLuminance = 0;
    @Unique
    private long lastUpdate = 0L;
    @Unique
    private final LongOpenHashSet sodiumdynamiclights$trackedLitChunkPos = new LongOpenHashSet();

    @Override
    public double sdl$getDynamicLightX() {
        return (double)this.field_11867.method_10263() + 0.5;
    }

    @Override
    public double sdl$getDynamicLightY() {
        return (double)this.field_11867.method_10264() + 0.5;
    }

    @Override
    public double sdl$getDynamicLightZ() {
        return (double)this.field_11867.method_10260() + 0.5;
    }

    @Override
    public class_1937 sdl$getDynamicLightLevel() {
        return this.field_11863;
    }

    @Inject(method={"setRemoved"}, at={@At(value="TAIL")})
    private void onRemoved(CallbackInfo ci) {
        this.sdl$setDynamicLightEnabled(false);
    }

    @Override
    public void sdl$resetDynamicLight() {
        this.lastLuminance = 0;
    }

    @Override
    public void sdl$dynamicLightTick() {
        if (this.field_11863 == null || !this.field_11863.method_8608()) {
            return;
        }
        if (!this.field_11865) {
            this.luminance = DynamicLightHandlers.getLuminanceFrom((class_2586)this);
            SodiumDynamicLights.updateTracking(this);
            if (!this.sdl$isDynamicLightEnabled()) {
                this.lastLuminance = 0;
            }
        }
    }

    @Override
    public int sdl$getLuminance() {
        return this.luminance;
    }

    @Override
    public boolean sdl$shouldUpdateDynamicLight() {
        DynamicLightsMode mode = SodiumDynamicLights.get().config.getDynamicLightsMode();
        if (!mode.isEnabled()) {
            return false;
        }
        if (mode.hasDelay()) {
            long currentTime = System.currentTimeMillis();
            if (currentTime < this.lastUpdate + (long)mode.getDelay()) {
                return false;
            }
            this.lastUpdate = currentTime;
        }
        return true;
    }

    @Override
    public boolean sodiumdynamiclights$updateDynamicLight(@NotNull class_761 renderer) {
        if (!this.sdl$shouldUpdateDynamicLight()) {
            return false;
        }
        int luminance = this.sdl$getLuminance();
        if (luminance != this.lastLuminance) {
            this.lastLuminance = luminance;
            if (this.sodiumdynamiclights$trackedLitChunkPos.isEmpty()) {
                class_2338.class_2339 chunkPos = new class_2338.class_2339(Math.floorDiv(this.field_11867.method_10263(), 16), class_3532.method_48116((int)this.field_11867.method_10264(), (int)16), class_3532.method_48116((int)this.field_11867.method_10260(), (int)16));
                SodiumDynamicLights.updateTrackedChunks((class_2338)chunkPos, null, this.sodiumdynamiclights$trackedLitChunkPos);
                class_2350 directionX = (this.field_11867.method_10263() & 0xF) >= 8 ? class_2350.field_11034 : class_2350.field_11039;
                class_2350 directionY = (this.field_11867.method_10264() & 0xF) >= 8 ? class_2350.field_11036 : class_2350.field_11033;
                class_2350 directionZ = (this.field_11867.method_10260() & 0xF) >= 8 ? class_2350.field_11035 : class_2350.field_11043;
                for (int i = 0; i < 7; ++i) {
                    if (i % 4 == 0) {
                        chunkPos.method_10098(directionX);
                    } else if (i % 4 == 1) {
                        chunkPos.method_10098(directionZ);
                    } else if (i % 4 == 2) {
                        chunkPos.method_10098(directionX.method_10153());
                    } else {
                        chunkPos.method_10098(directionZ.method_10153());
                        chunkPos.method_10098(directionY);
                    }
                    SodiumDynamicLights.updateTrackedChunks((class_2338)chunkPos, null, this.sodiumdynamiclights$trackedLitChunkPos);
                }
            }
            this.sodiumdynamiclights$scheduleTrackedChunksRebuild(renderer);
            return true;
        }
        return false;
    }

    @Override
    public void sodiumdynamiclights$scheduleTrackedChunksRebuild(@NotNull class_761 renderer) {
        if (this.field_11863 == class_310.method_1551().field_1687) {
            LongIterator longIterator = this.sodiumdynamiclights$trackedLitChunkPos.iterator();
            while (longIterator.hasNext()) {
                long pos = (Long)longIterator.next();
                SodiumDynamicLights.scheduleChunkRebuild(renderer, pos);
            }
        }
    }
}

