/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.util;

import com.twelvemonkeys.image.ImageUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.imageio.ImageIO;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.registration.Configs;
import net.minecraft.class_1011;
import org.apache.logging.log4j.util.TriConsumer;

public class ImageManipulations {
    public static void write(BufferedImage image, File file) {
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static BufferedImage decode(byte[] bytes) {
        try {
            return ImageIO.read(new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encode(BufferedImage image) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)image, "png", stream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stream.toByteArray();
    }

    public static void processByteArrayInChunks(byte[] input, TriConsumer<byte[], Integer, Integer> consumer) {
        int packetSize = Configs.COMMON.packetSize;
        int splits = (int)Math.ceil((double)input.length / (double)packetSize);
        int split = 0;
        for (int i = 0; i < input.length; i += packetSize) {
            byte[] b = Arrays.copyOfRange(input, i, Math.min(input.length, i + packetSize));
            consumer.accept((Object)b, (Object)split, (Object)splits);
            ++split;
        }
    }

    public static class_1011 bufferedToNative(BufferedImage image) {
        class_1011 nativeImage = new class_1011(image.getWidth(), image.getHeight(), false);
        ColorModel model = image.getColorModel();
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                Object elements = image.getRaster().getDataElements(x, y, null);
                int abgr = model.getAlpha(elements) << 24 | model.getBlue(elements) << 16 | model.getGreen(elements) << 8 | model.getRed(elements);
                nativeImage.method_4305(x, y, abgr);
            }
        }
        return nativeImage;
    }

    public static BufferedImage resizeImage(BufferedImage in, Painting.Size size) {
        int w = in.getWidth();
        int h = in.getHeight();
        switch (size) {
            case FULL: {
                return in;
            }
            case HALF: {
                w /= 2;
                h /= 2;
                break;
            }
            case QUARTER: {
                w /= 4;
                h /= 4;
                break;
            }
            case EIGHTH: {
                w /= 8;
                h /= 8;
                break;
            }
            case THUMBNAIL: {
                float z = Math.min((float)Configs.CLIENT.thumbnailSize / (float)w, (float)Configs.CLIENT.thumbnailSize / (float)h);
                if (z < 1.0f) {
                    w = (int)((float)w * z);
                    h = (int)((float)h * z);
                }
                if (w != in.getWidth()) break;
                return in;
            }
            case NSFW: {
                return ImageUtil.blur((BufferedImage)in, (float)((float)Configs.CLIENT.thumbnailSize / 8.0f));
            }
        }
        BufferedImage out = new BufferedImage(w, h, 2);
        ImageManipulations.resize(out, in, (float)in.getWidth() / (float)w, 0, 0);
        return out;
    }

    public static void resize(BufferedImage image, BufferedImage source, float zoom, int ox, int oy) {
        ColorModel sourceModel = source.getColorModel();
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                int red = 0;
                int green = 0;
                int blue = 0;
                int alpha = 0;
                int samples = 0;
                int px = Math.max(0, (int)((float)ox + zoom * (float)x));
                while ((float)px < Math.min((float)source.getWidth(), (float)ox + zoom * (float)(x + 1))) {
                    int py = Math.max(0, (int)((float)oy + zoom * (float)y));
                    while ((float)py < Math.min((float)source.getHeight(), (float)oy + zoom * (float)(y + 1))) {
                        Object elements = source.getRaster().getDataElements(px, py, null);
                        red += sourceModel.getRed(elements);
                        green += sourceModel.getGreen(elements);
                        blue += sourceModel.getBlue(elements);
                        alpha += sourceModel.getAlpha(elements);
                        ++samples;
                        ++py;
                    }
                    ++px;
                }
                if (samples > 0) {
                    red /= samples;
                    green /= samples;
                    blue /= samples;
                    alpha /= samples;
                }
                image.setRGB(x, y, alpha << 24 | red << 16 | green << 8 | blue);
            }
        }
    }

    public static void dither(BufferedImage image, double dither) {
        ColorModel model = image.getColorModel();
        float[] hsv = new float[3];
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                Object elements = image.getRaster().getDataElements(x, y, null);
                Color.RGBtoHSB(model.getRed(elements), model.getGreen(elements), model.getBlue(elements), hsv);
                for (int i = 1; i < 3; ++i) {
                    hsv[i] = x % 2 == y % 2 ? (float)Math.min(1.0, (double)hsv[i] + dither * 0.5) : (float)Math.max(0.0, (double)hsv[i] - dither * 0.5);
                }
                image.setRGB(x, y, Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]));
            }
        }
    }

    public static void reduceColors(BufferedImage image, int bins) {
        float[] hsv = new float[3];
        float[][] hist = new float[3][256];
        boolean EXCLUDE_HUE = true;
        ColorModel model = image.getColorModel();
        int base = image.getWidth() * image.getHeight();
        for (int channel = 1; channel < 3; ++channel) {
            for (int x = 0; x < 256; ++x) {
                hist[channel][x] = (float)base / 255.0f;
            }
        }
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                Object elements = image.getRaster().getDataElements(x, y, null);
                Color.RGBtoHSB(model.getRed(elements), model.getGreen(elements), model.getBlue(elements), hsv);
                for (int i = 0; i < 3; ++i) {
                    float[] fArray = hist[i];
                    int n = ImageManipulations.toByte(hsv[i]);
                    fArray[n] = fArray[n] + 1.0f;
                }
            }
        }
        int binSize = (image.getWidth() * image.getHeight() + base) / bins;
        float[][] lookup = new float[3][256];
        for (int channel = 1; channel < 3; ++channel) {
            int start = 0;
            for (int bin = 0; bin < bins; ++bin) {
                int end = start;
                int sum = 0;
                int pixels = 0;
                while (pixels <= binSize && end < 256) {
                    float v = hist[channel][end];
                    pixels += (int)v;
                    sum += (int)((float)end * v);
                    ++end;
                }
                for (int b = start; b < end; ++b) {
                    lookup[channel][b] = (float)sum / (float)pixels / 255.0f;
                }
                start = end;
            }
        }
        for (int x = 0; x < image.getWidth(); ++x) {
            for (int y = 0; y < image.getHeight(); ++y) {
                Object elements = image.getRaster().getDataElements(x, y, null);
                Color.RGBtoHSB(model.getRed(elements), model.getGreen(elements), model.getBlue(elements), hsv);
                for (int channel = 1; channel < 3; ++channel) {
                    hsv[channel] = lookup[channel][ImageManipulations.toByte(hsv[channel])];
                }
                image.setRGB(x, y, Color.HSBtoRGB(hsv[0], hsv[1], hsv[2]));
            }
        }
    }

    private static int toByte(float v) {
        return Math.min(255, Math.max(0, (int)(v * 255.0f)));
    }

    public static int scanForPixelArtMultiple(BufferedImage image) {
        int[] hist = new int[64];
        for (int y = 0; y < image.getHeight(); y += 7) {
            int l = 0;
            int lastColor = 0;
            for (int x = 0; x < image.getWidth(); ++x) {
                int color = image.getRGB(x, y);
                if (x == 0 || lastColor == color) {
                    ++l;
                } else {
                    if (l < hist.length) {
                        int n = l;
                        hist[n] = hist[n] + 1;
                    }
                    l = 1;
                }
                lastColor = color;
            }
        }
        int bestScore = 0;
        int best = 1;
        for (int i = 1; i < hist.length; ++i) {
            if (hist[i] <= bestScore) continue;
            bestScore = hist[i];
            best = i;
        }
        return best;
    }
}

