/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.conczin.immersive_paintings.util.ImageManipulations;

public class SegmentManager {
    private final Map<String, ByteArrayOutputStream> buffer = new HashMap<String, ByteArrayOutputStream>();

    public Optional<BufferedImage> handleSegmentedPayload(String key, SegmentedPayload payload) {
        ByteArrayOutputStream byteBuffer = this.buffer.computeIfAbsent(key, k -> new ByteArrayOutputStream());
        try {
            byteBuffer.write(payload.data());
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        if (payload.segment() + 1 == payload.totalSegments()) {
            this.buffer.remove(key);
            return Optional.ofNullable(ImageManipulations.decode(byteBuffer.toByteArray()));
        }
        return Optional.empty();
    }

    public static interface SegmentedPayload {
        public byte[] data();

        public int segment();

        public int totalSegments();
    }
}

