/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.luaj.vm2.Globals;
import org.luaj.vm2.LuaString;
import org.luaj.vm2.LuaTable;
import org.luaj.vm2.LuaValue;
import org.luaj.vm2.Print;
import org.luaj.vm2.Varargs;
import org.luaj.vm2.lib.jse.JsePlatform;
import org.luaj.vm2.luajc.LuaJC;

public class lua {
    private static final String version = "Luaj 0.0 Copyright (c) 2012 Luaj.org.org";
    private static final String usage = "usage: java -cp luaj-jse.jar lua [options] [script [args]].\nAvailable options are:\n  -e stat  execute string 'stat'\n  -l name  require library 'name'\n  -i       enter interactive mode after executing 'script'\n  -v       show version information\n  -b      \tuse luajc bytecode-to-bytecode compiler (requires bcel on class path)\n  -n      \tnodebug - do not load debug library by default\n  -p      \tprint the prototype\n  -c enc  \tuse the supplied encoding 'enc' for input files\n  --       stop handling options\n  -        execute stdin and stop handling options";
    private static Globals globals;
    private static boolean print;
    private static String encoding;

    private static void usageExit() {
        System.out.println(usage);
        System.exit(-1);
    }

    public static void main(String[] args) throws IOException {
        boolean interactive = args.length == 0;
        boolean versioninfo = false;
        boolean processing = true;
        boolean nodebug = false;
        boolean luajc2 = false;
        Vector libs = null;
        try {
            int n;
            int i;
            block18: for (i = 0; i < args.length && processing && args[i].startsWith("-") && args[i].length() > 1; ++i) {
                switch (args[i].charAt(1)) {
                    case 'e': {
                        if (++i < args.length) continue block18;
                        lua.usageExit();
                        continue block18;
                    }
                    case 'b': {
                        luajc2 = true;
                        continue block18;
                    }
                    case 'l': {
                        if (++i >= args.length) {
                            lua.usageExit();
                        }
                        libs = libs != null ? libs : new Vector();
                        libs.addElement(args[i]);
                        continue block18;
                    }
                    case 'i': {
                        interactive = true;
                        continue block18;
                    }
                    case 'v': {
                        versioninfo = true;
                        continue block18;
                    }
                    case 'n': {
                        nodebug = true;
                        continue block18;
                    }
                    case 'p': {
                        print = true;
                        continue block18;
                    }
                    case 'c': {
                        if (++i >= args.length) {
                            lua.usageExit();
                        }
                        encoding = args[i];
                        continue block18;
                    }
                    case '-': {
                        if (args[i].length() > 2) {
                            lua.usageExit();
                        }
                        processing = false;
                        continue block18;
                    }
                    default: {
                        lua.usageExit();
                    }
                }
            }
            if (versioninfo) {
                System.out.println(version);
            }
            Globals globals = lua.globals = nodebug ? JsePlatform.standardGlobals() : JsePlatform.debugGlobals();
            if (luajc2) {
                LuaJC.install(lua.globals);
            }
            int n2 = n = libs != null ? libs.size() : 0;
            for (i = 0; i < n; ++i) {
                lua.loadLibrary((String)libs.elementAt(i));
            }
            processing = true;
            block20: for (i = 0; i < args.length; ++i) {
                if (!processing || !args[i].startsWith("-")) {
                    lua.processScript(new FileInputStream(args[i]), args[i], args, i);
                    break;
                }
                if ("-".equals(args[i])) {
                    lua.processScript(System.in, "=stdin", args, i);
                    break;
                }
                switch (args[i].charAt(1)) {
                    case 'c': 
                    case 'l': {
                        ++i;
                        continue block20;
                    }
                    case 'e': {
                        lua.processScript(new ByteArrayInputStream(args[++i].getBytes()), "string", args, i);
                        continue block20;
                    }
                    case '-': {
                        processing = false;
                    }
                }
            }
            if (interactive) {
                lua.interactiveMode();
            }
        }
        catch (IOException ioe) {
            System.err.println(ioe.toString());
            System.exit(-2);
        }
    }

    private static void loadLibrary(String libname) throws IOException {
        LuaString slibname = LuaValue.valueOf(libname);
        try {
            globals.get("require").call(slibname);
        }
        catch (Exception e) {
            try {
                LuaValue v = (LuaValue)Class.forName(libname).newInstance();
                v.call(slibname, globals);
            }
            catch (Exception f) {
                throw new IOException("loadLibrary(" + libname + ") failed: " + e + "," + f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processScript(InputStream script, String chunkname, String[] args, int firstarg) throws IOException {
        try {
            LuaValue c;
            try {
                script = new BufferedInputStream(script);
                c = encoding != null ? globals.load(new InputStreamReader(script, encoding), chunkname) : globals.load(script, chunkname, "bt", globals);
            }
            finally {
                script.close();
            }
            if (print && c.isclosure()) {
                Print.print(c.checkclosure().p);
            }
            Varargs scriptargs = lua.setGlobalArg(chunkname, args, firstarg, globals);
            c.invoke(scriptargs);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
        }
    }

    private static Varargs setGlobalArg(String chunkname, String[] args, int i, LuaValue globals) {
        if (args == null) {
            return LuaValue.NONE;
        }
        LuaTable arg = LuaValue.tableOf();
        for (int j = 0; j < args.length; ++j) {
            arg.set(j - i, (LuaValue)LuaValue.valueOf(args[j]));
        }
        arg.set(0, (LuaValue)LuaValue.valueOf(chunkname));
        arg.set(-1, (LuaValue)LuaValue.valueOf("luaj"));
        globals.set("arg", (LuaValue)arg);
        return arg.unpack();
    }

    private static void interactiveMode() throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("> ");
            System.out.flush();
            String line = reader.readLine();
            if (line == null) {
                return;
            }
            lua.processScript(new ByteArrayInputStream(line.getBytes()), "=stdin", null, 0);
        }
    }

    static {
        print = false;
        encoding = null;
    }
}

