/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.tools.path;

import com.moulberry.axiom.collections.Position2FloatMap;
import com.moulberry.axiom.mask.MaskContext;
import com.moulberry.axiom.mask.MaskElement;
import com.moulberry.axiom.noise.WhiteNoise;
import com.moulberry.axiom.rasterization.Rasterization3D;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import it.unimi.dsi.fastutil.floats.FloatUnaryOperator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public interface PathRasterizer {
    public static int[] createOffsetArray(int radius) {
        IntArrayList offsetList = new IntArrayList();
        int radiusSq = radius * radius + radius;
        for (int xo = -radius; xo <= radius; ++xo) {
            for (int yo = -radius; yo <= radius; ++yo) {
                for (int zo = -radius; zo <= radius; ++zo) {
                    if (xo == 0 && yo == 0 && zo == 0 || xo * xo + yo * yo + zo * zo > radiusSq) continue;
                    offsetList.add(xo);
                    offsetList.add(yo);
                    offsetList.add(zo);
                }
            }
        }
        return offsetList.toIntArray();
    }

    public void rasterize(ChunkedBlockRegion var1, MaskElement var2, MaskContext var3, Vector3f var4, Vector3f var5, int var6, float var7, float var8);

    public record FlatDynamicRadiusDynamicBlock(FloatUnaryOperator[] easings, float[] nodeAngles, float[] lineAngles, int[] radii, int depth, class_2680[] blocks, WhiteNoise whiteNoise, Position2FloatMap closestMap) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3f from, Vector3f to, int index, float minPartial, float partialLength) {
            Vector3f leftBuffer = new Vector3f();
            Vector3f rightBuffer = new Vector3f();
            float divisions = (float)Math.ceil(from.distance((Vector3fc)to)) * 32.0f;
            class_2680 fromState = this.blocks[index];
            class_2680 toState = this.blocks[index + 1];
            for (int i = 0; i <= (int)divisions; ++i) {
                float newPartial;
                float angleRight;
                float angleLeft;
                float f = (float)i / divisions;
                float partial = this.easings[index].apply(minPartial + partialLength * f);
                float realRadius = (float)this.radii[index] * (1.0f - partial) + (float)this.radii[index + 1] * partial;
                if ((double)partial < 0.5) {
                    angleLeft = this.nodeAngles[index];
                    angleRight = this.lineAngles[index];
                    newPartial = partial * 2.0f;
                } else {
                    angleLeft = this.lineAngles[index];
                    angleRight = this.nodeAngles[index + 1];
                    newPartial = (partial - 0.5f) * 2.0f;
                }
                float delta = angleRight - angleLeft;
                delta = (float)((double)delta % (Math.PI * 2));
                if ((double)delta < -Math.PI) {
                    delta = (float)((double)delta + Math.PI * 2);
                }
                if ((double)delta > Math.PI) {
                    delta = (float)((double)delta - Math.PI * 2);
                }
                float realAngle = angleLeft + delta * newPartial + 1.5707964f;
                float targetX = from.x * (1.0f - f) + to.x * f;
                float targetY = from.y * (1.0f - f) + to.y * f;
                float targetZ = from.z * (1.0f - f) + to.z * f;
                float sideX = (float)Math.sin(realAngle) * realRadius;
                float sideZ = (float)Math.cos(realAngle) * realRadius;
                leftBuffer.set(targetX - sideX, targetY, targetZ - sideZ);
                rightBuffer.set(targetX + sideX, targetY, targetZ + sideZ);
                Rasterization3D.dda(leftBuffer, rightBuffer, (x1, y1, z1) -> {
                    for (int d = 0; d <= this.depth; ++d) {
                        float dz;
                        float dy;
                        float dx;
                        float realDistanceSq;
                        if (!destinationMask.test(maskContext.reset(), x1, y1 - d, z1) || !this.closestMap.min(x1, y1 - d, z1, realDistanceSq = (dx = (float)x1 + 0.5f - targetX) * dx + (dy = (float)(y1 - d) + 0.5f - targetY) * dy + (dz = (float)z1 + 0.5f - targetZ) * dz)) continue;
                        if (this.whiteNoise.evaluate(x1, y1 - d, z1) > partial) {
                            chunkedBlockRegion.addBlockWithoutDirty(x1, y1 - d, z1, fromState);
                            continue;
                        }
                        chunkedBlockRegion.addBlockWithoutDirty(x1, y1 - d, z1, toState);
                    }
                });
            }
        }
    }

    public record FlatConstantRadiusDynamicBlock(FloatUnaryOperator[] easings, float[] nodeAngles, float[] lineAngles, int distance, int depth, class_2680[] blocks, WhiteNoise whiteNoise, Position2FloatMap closestMap) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3f from, Vector3f to, int index, float minPartial, float partialLength) {
            Vector3f leftBuffer = new Vector3f();
            Vector3f rightBuffer = new Vector3f();
            float divisions = (float)Math.ceil(from.distance((Vector3fc)to)) * 32.0f;
            class_2680 fromState = this.blocks[index];
            class_2680 toState = this.blocks[index + 1];
            for (int i = 0; i <= (int)divisions; ++i) {
                float newPartial;
                float angleRight;
                float angleLeft;
                float f = (float)i / divisions;
                float partial = this.easings[index].apply(minPartial + partialLength * f);
                if ((double)partial < 0.5) {
                    angleLeft = this.nodeAngles[index];
                    angleRight = this.lineAngles[index];
                    newPartial = partial * 2.0f;
                } else {
                    angleLeft = this.lineAngles[index];
                    angleRight = this.nodeAngles[index + 1];
                    newPartial = (partial - 0.5f) * 2.0f;
                }
                float delta = angleRight - angleLeft;
                delta = (float)((double)delta % (Math.PI * 2));
                if ((double)delta < -Math.PI) {
                    delta = (float)((double)delta + Math.PI * 2);
                }
                if ((double)delta > Math.PI) {
                    delta = (float)((double)delta - Math.PI * 2);
                }
                float realAngle = angleLeft + delta * newPartial + 1.5707964f;
                float targetX = from.x * (1.0f - f) + to.x * f;
                float targetY = from.y * (1.0f - f) + to.y * f;
                float targetZ = from.z * (1.0f - f) + to.z * f;
                float sideX = (float)Math.sin(realAngle) * (float)this.distance;
                float sideZ = (float)Math.cos(realAngle) * (float)this.distance;
                leftBuffer.set(targetX - sideX, targetY, targetZ - sideZ);
                rightBuffer.set(targetX + sideX, targetY, targetZ + sideZ);
                Rasterization3D.dda(leftBuffer, rightBuffer, (x1, y1, z1) -> {
                    for (int d = 0; d <= this.depth; ++d) {
                        float dz;
                        float dy;
                        float dx;
                        float realDistanceSq;
                        if (!destinationMask.test(maskContext.reset(), x1, y1 - d, z1) || !this.closestMap.min(x1, y1 - d, z1, realDistanceSq = (dx = (float)x1 + 0.5f - targetX) * dx + (dy = (float)(y1 - d) + 0.5f - targetY) * dy + (dz = (float)z1 + 0.5f - targetZ) * dz)) continue;
                        if (this.whiteNoise.evaluate(x1, y1 - d, z1) > partial) {
                            chunkedBlockRegion.addBlockWithoutDirty(x1, y1 - d, z1, fromState);
                            continue;
                        }
                        chunkedBlockRegion.addBlockWithoutDirty(x1, y1 - d, z1, toState);
                    }
                });
            }
        }
    }

    public record FlatDynamicRadiusConstantBlock(FloatUnaryOperator[] easings, float[] nodeAngles, float[] lineAngles, int[] radii, int depth, class_2680 constantBlock) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3f from, Vector3f to, int index, float minPartial, float partialLength) {
            Vector3f leftBuffer = new Vector3f();
            Vector3f rightBuffer = new Vector3f();
            float divisions = (float)Math.ceil(from.distance((Vector3fc)to)) * 32.0f;
            for (int i = 0; i <= (int)divisions; ++i) {
                float angleRight;
                float angleLeft;
                float f = (float)i / divisions;
                float partial = minPartial + partialLength * f;
                partial = this.easings[index].apply(partial);
                float realRadius = (float)this.radii[index] * (1.0f - partial) + (float)this.radii[index + 1] * partial;
                if ((double)partial < 0.5) {
                    angleLeft = this.nodeAngles[index];
                    angleRight = this.lineAngles[index];
                    partial *= 2.0f;
                } else {
                    angleLeft = this.lineAngles[index];
                    angleRight = this.nodeAngles[index + 1];
                    partial = (partial - 0.5f) * 2.0f;
                }
                float delta = angleRight - angleLeft;
                delta = (float)((double)delta % (Math.PI * 2));
                if ((double)delta < -Math.PI) {
                    delta = (float)((double)delta + Math.PI * 2);
                }
                if ((double)delta > Math.PI) {
                    delta = (float)((double)delta - Math.PI * 2);
                }
                float realAngle = angleLeft + delta * partial + 1.5707964f;
                float targetX = from.x * (1.0f - f) + to.x * f;
                float targetY = from.y * (1.0f - f) + to.y * f;
                float targetZ = from.z * (1.0f - f) + to.z * f;
                float sideX = (float)Math.sin(realAngle) * realRadius;
                float sideZ = (float)Math.cos(realAngle) * realRadius;
                leftBuffer.set(targetX - sideX, targetY, targetZ - sideZ);
                rightBuffer.set(targetX + sideX, targetY, targetZ + sideZ);
                Rasterization3D.dda(leftBuffer, rightBuffer, (x1, y1, z1) -> {
                    for (int d = 0; d <= this.depth; ++d) {
                        if (!destinationMask.test(maskContext.reset(), x1, y1 - d, z1)) continue;
                        chunkedBlockRegion.addBlockWithoutDirty(x1, y1 - d, z1, this.constantBlock);
                    }
                });
            }
        }
    }

    public record FlatConstantRadiusConstantBlock(FloatUnaryOperator[] easings, float[] nodeAngles, float[] lineAngles, int distance, int depth, class_2680 constantBlock) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3f from, Vector3f to, int index, float minPartial, float partialLength) {
            Vector3f leftBuffer = new Vector3f();
            Vector3f rightBuffer = new Vector3f();
            float divisions = (float)Math.ceil(from.distance((Vector3fc)to)) * 32.0f;
            for (int i = 0; i <= (int)divisions; ++i) {
                float angleRight;
                float angleLeft;
                float f = (float)i / divisions;
                float partial = minPartial + partialLength * f;
                if ((double)(partial = this.easings[index].apply(partial)) < 0.5) {
                    angleLeft = this.nodeAngles[index];
                    angleRight = this.lineAngles[index];
                    partial *= 2.0f;
                } else {
                    angleLeft = this.lineAngles[index];
                    angleRight = this.nodeAngles[index + 1];
                    partial = (partial - 0.5f) * 2.0f;
                }
                float delta = angleRight - angleLeft;
                delta = (float)((double)delta % (Math.PI * 2));
                if ((double)delta < -Math.PI) {
                    delta = (float)((double)delta + Math.PI * 2);
                }
                if ((double)delta > Math.PI) {
                    delta = (float)((double)delta - Math.PI * 2);
                }
                float realAngle = angleLeft + delta * partial + 1.5707964f;
                float targetX = from.x * (1.0f - f) + to.x * f;
                float targetY = from.y * (1.0f - f) + to.y * f;
                float targetZ = from.z * (1.0f - f) + to.z * f;
                float sideX = (float)Math.sin(realAngle) * (float)this.distance;
                float sideZ = (float)Math.cos(realAngle) * (float)this.distance;
                leftBuffer.set(targetX - sideX, targetY, targetZ - sideZ);
                rightBuffer.set(targetX + sideX, targetY, targetZ + sideZ);
                Rasterization3D.dda(leftBuffer, rightBuffer, (x1, y1, z1) -> {
                    for (int d = 0; d <= this.depth; ++d) {
                        if (!destinationMask.test(maskContext.reset(), x1, y1 - d, z1)) continue;
                        chunkedBlockRegion.addBlockWithoutDirty(x1, y1 - d, z1, this.constantBlock);
                    }
                });
            }
        }
    }

    public record Custom(FloatUnaryOperator[] easings, float[] nodeAngles, float[] lineAngles, float[] accumulatedDistance, Position2FloatMap minDistance, ChunkedBlockRegion sourceRegion) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3f from, Vector3f to, int index, float minPartial, float partialLength) {
            Vector3f leftBuffer = new Vector3f();
            Vector3f rightBuffer = new Vector3f();
            float distance = from.distance((Vector3fc)to);
            float divisions = (float)Math.ceil(distance) * 32.0f;
            for (int i = 0; i <= (int)divisions; ++i) {
                float angleRight;
                float angleLeft;
                float f = (float)i / divisions;
                float partial = minPartial + partialLength * f;
                if ((double)(partial = this.easings[index].apply(partial)) < 0.5) {
                    angleLeft = this.nodeAngles[index];
                    angleRight = this.lineAngles[index];
                    partial *= 2.0f;
                } else {
                    angleLeft = this.lineAngles[index];
                    angleRight = this.nodeAngles[index + 1];
                    partial = (partial - 0.5f) * 2.0f;
                }
                float delta = angleRight - angleLeft;
                delta = (float)((double)delta % (Math.PI * 2));
                if ((double)delta < -Math.PI) {
                    delta = (float)((double)delta + Math.PI * 2);
                }
                if ((double)delta > Math.PI) {
                    delta = (float)((double)delta - Math.PI * 2);
                }
                float realAngle = angleLeft + delta * partial + 1.5707964f;
                float targetX = from.x * (1.0f - f) + to.x * f;
                float targetY = from.y * (1.0f - f) + to.y * f;
                float targetZ = from.z * (1.0f - f) + to.z * f;
                class_2338 min2 = this.sourceRegion.min();
                class_2338 max2 = this.sourceRegion.max();
                int sizeX = max2.method_10263() - min2.method_10263() + 1;
                int sizeY = max2.method_10264() - min2.method_10264() + 1;
                int sizeZ = max2.method_10260() - min2.method_10260() + 1;
                int currentDistance = Math.round(this.accumulatedDistance[0] + distance * f);
                float sideX = (float)Math.sin(realAngle) * (float)(sizeX - 1) / 2.0f;
                float sideZ = (float)Math.cos(realAngle) * (float)(sizeX - 1) / 2.0f;
                leftBuffer.set(targetX - sideX, targetY, targetZ - sideZ);
                rightBuffer.set(targetX + sideX, targetY, targetZ + sideZ);
                Rasterization3D.ddaPartial(leftBuffer, rightBuffer, (x1, y1, z1, amount) -> {
                    Vector3f actualPosition = leftBuffer.lerp((Vector3fc)rightBuffer, amount, new Vector3f());
                    float errorDistanceSq = actualPosition.distanceSquared((float)x1 + 0.5f, (float)y1 + 0.5f, (float)z1 + 0.5f);
                    for (int y = 0; y < sizeY; ++y) {
                        int blockZ;
                        int blockY;
                        int blockX;
                        class_2680 blockState;
                        if (!destinationMask.test(maskContext.reset(), x1, y1 + y, z1) || (blockState = this.sourceRegion.getBlockStateOrNull(blockX = min2.method_10263() + Math.min(Math.round((float)(sizeX - 1) * amount), sizeX - 1), blockY = min2.method_10264() + y, blockZ = min2.method_10260() + currentDistance % sizeZ)) == null || !this.minDistance.min(x1, y1 + y, z1, errorDistanceSq)) continue;
                        chunkedBlockRegion.addBlockWithoutDirty(x1, y1 + y, z1, blockState);
                    }
                });
            }
            this.accumulatedDistance[0] = this.accumulatedDistance[0] + distance;
        }
    }

    public record DynamicRadiusDynamicBlock(FloatUnaryOperator[] easings, int[] radii, class_2680[] blocks, WhiteNoise whiteNoise, Position2FloatMap closestMap) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3f from, Vector3f to, int index, float minPartial, float partialLength) {
            Rasterization3D.ddaPartial(from, to, (x, y, z, f) -> {
                float partial = minPartial + partialLength * f;
                partial = this.easings[index].apply(partial);
                class_2680 fromState = this.blocks[index];
                class_2680 toState = this.blocks[index + 1];
                float realRadius = (float)this.radii[index] * (1.0f - partial) + (float)this.radii[index + 1] * partial;
                float realRadiusSquared = realRadius * realRadius + realRadius;
                int bigRadius = (int)realRadius + 1;
                int bigRadiusSquared = bigRadius * bigRadius + bigRadius;
                float targetX = from.x * (1.0f - f) + to.x * f;
                float targetY = from.y * (1.0f - f) + to.y * f;
                float targetZ = from.z * (1.0f - f) + to.z * f;
                for (int xo = -bigRadius; xo <= bigRadius; ++xo) {
                    for (int yo = -bigRadius; yo <= bigRadius; ++yo) {
                        for (int zo = -bigRadius; zo <= bigRadius; ++zo) {
                            float dz;
                            float dy;
                            float dx;
                            float realDistanceSq;
                            if (xo == 0 && yo == 0 && zo == 0) {
                                if (!destinationMask.test(maskContext.reset(), x, y, z)) continue;
                                if (this.whiteNoise.evaluate(x, y, z) > partial) {
                                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, fromState);
                                    continue;
                                }
                                chunkedBlockRegion.addBlockWithoutDirty(x, y, z, toState);
                                continue;
                            }
                            if (xo * xo + yo * yo + zo * zo > bigRadiusSquared || !((realDistanceSq = (dx = (float)(x + xo) + 0.5f - targetX) * dx + (dy = (float)(y + yo) + 0.5f - targetY) * dy + (dz = (float)(z + zo) + 0.5f - targetZ) * dz) <= realRadiusSquared) || !destinationMask.test(maskContext.reset(), x + xo, y + yo, z + zo) || !this.closestMap.min(x + xo, y + yo, z + zo, realDistanceSq)) continue;
                            if (this.whiteNoise.evaluate(x + xo, y + yo, z + zo) > partial) {
                                chunkedBlockRegion.addBlockWithoutDirty(x + xo, y + yo, z + zo, fromState);
                                continue;
                            }
                            chunkedBlockRegion.addBlockWithoutDirty(x + xo, y + yo, z + zo, toState);
                        }
                    }
                }
            });
        }
    }

    public record DynamicRadiusConstantBlock(FloatUnaryOperator[] easings, int[] radii, class_2680 constantBlock) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3f from, Vector3f to, int index, float minPartial, float partialLength) {
            Rasterization3D.ddaPartial(from, to, (x, y, z, f) -> {
                float partial = minPartial + partialLength * f;
                partial = this.easings[index].apply(partial);
                float realRadius = (float)this.radii[index] * (1.0f - partial) + (float)this.radii[index + 1] * partial;
                float realRadiusSquared = realRadius * realRadius + realRadius;
                int bigRadius = (int)realRadius + 1;
                int bigRadiusSquared = bigRadius * bigRadius + bigRadius;
                float targetX = from.x * (1.0f - f) + to.x * f;
                float targetY = from.y * (1.0f - f) + to.y * f;
                float targetZ = from.z * (1.0f - f) + to.z * f;
                for (int xo = -bigRadius; xo <= bigRadius; ++xo) {
                    for (int yo = -bigRadius; yo <= bigRadius; ++yo) {
                        for (int zo = -bigRadius; zo <= bigRadius; ++zo) {
                            float dz;
                            float dy;
                            float dx;
                            float realDistanceSq;
                            if (xo == 0 && yo == 0 && zo == 0) {
                                if (!destinationMask.test(maskContext.reset(), x, y, z)) continue;
                                chunkedBlockRegion.addBlockWithoutDirty(x, y, z, this.constantBlock);
                                continue;
                            }
                            if (xo * xo + yo * yo + zo * zo > bigRadiusSquared || !((realDistanceSq = (dx = (float)(x + xo) + 0.5f - targetX) * dx + (dy = (float)(y + yo) + 0.5f - targetY) * dy + (dz = (float)(z + zo) + 0.5f - targetZ) * dz) <= realRadiusSquared) || !destinationMask.test(maskContext.reset(), x + xo, y + yo, z + zo)) continue;
                            chunkedBlockRegion.addBlockWithoutDirty(x + xo, y + yo, z + zo, this.constantBlock);
                        }
                    }
                }
            });
        }
    }

    public record ConstantRadiusDynamicBlock(FloatUnaryOperator[] easings, int[] offsetArray, int realRadiusSquared, class_2680[] blocks, WhiteNoise whiteNoise, Position2FloatMap closestMap) implements PathRasterizer
    {
        public ConstantRadiusDynamicBlock(FloatUnaryOperator[] easings, int radius, class_2680[] blocks, WhiteNoise whiteNoise, Position2FloatMap closestMap) {
            this(easings, PathRasterizer.createOffsetArray(radius + 1), radius * radius + radius, blocks, whiteNoise, closestMap);
        }

        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3f from, Vector3f to, int index, float minPartial, float partialLength) {
            Rasterization3D.ddaPartial(from, to, (x, y, z, f) -> {
                float partial = minPartial + partialLength * f;
                partial = this.easings[index].apply(partial);
                class_2680 fromState = this.blocks[index];
                class_2680 toState = this.blocks[index + 1];
                if (destinationMask.test(maskContext.reset(), x, y, z)) {
                    if (this.whiteNoise.evaluate(x, y, z) > partial) {
                        chunkedBlockRegion.addBlockWithoutDirty(x, y, z, fromState);
                    } else {
                        chunkedBlockRegion.addBlockWithoutDirty(x, y, z, toState);
                    }
                }
                float targetX = from.x * (1.0f - f) + to.x * f;
                float targetY = from.y * (1.0f - f) + to.y * f;
                float targetZ = from.z * (1.0f - f) + to.z * f;
                for (int i1 = 0; i1 < this.offsetArray.length; i1 += 3) {
                    int xo = this.offsetArray[i1];
                    float dx = (float)(x + xo) + 0.5f - targetX;
                    int yo = this.offsetArray[i1 + 1];
                    float dy = (float)(y + yo) + 0.5f - targetY;
                    int zo = this.offsetArray[i1 + 2];
                    float dz = (float)(z + zo) + 0.5f - targetZ;
                    float realDistanceSq = dx * dx + dy * dy + dz * dz;
                    if (!(realDistanceSq <= (float)this.realRadiusSquared) || !destinationMask.test(maskContext.reset(), x + xo, y + yo, z + zo) || !this.closestMap.min(x + xo, y + yo, z + zo, realDistanceSq)) continue;
                    if (this.whiteNoise.evaluate(x + xo, y + yo, z + zo) > partial) {
                        chunkedBlockRegion.addBlockWithoutDirty(x + xo, y + yo, z + zo, fromState);
                        continue;
                    }
                    chunkedBlockRegion.addBlockWithoutDirty(x + xo, y + yo, z + zo, toState);
                }
            });
        }
    }

    public record ConstantRadiusConstantBlock(int[] offsetArray, int realRadiusSquared, class_2680 constantBlock) implements PathRasterizer
    {
        public ConstantRadiusConstantBlock(int radius, class_2680 constantBlock) {
            this(PathRasterizer.createOffsetArray(radius + 1), radius * radius + radius, constantBlock);
        }

        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3f from, Vector3f to, int index, float minPartial, float partialLength) {
            Rasterization3D.ddaPartial(from, to, (x, y, z, f) -> {
                float targetX = from.x * (1.0f - f) + to.x * f;
                float targetY = from.y * (1.0f - f) + to.y * f;
                float targetZ = from.z * (1.0f - f) + to.z * f;
                if (destinationMask.test(maskContext.reset(), x, y, z)) {
                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, this.constantBlock);
                }
                for (int i1 = 0; i1 < this.offsetArray.length; i1 += 3) {
                    int xo = this.offsetArray[i1];
                    float dx = (float)(x + xo) + 0.5f - targetX;
                    int yo = this.offsetArray[i1 + 1];
                    float dy = (float)(y + yo) + 0.5f - targetY;
                    int zo = this.offsetArray[i1 + 2];
                    float dz = (float)(z + zo) + 0.5f - targetZ;
                    float realDistanceSq = dx * dx + dy * dy + dz * dz;
                    if (!(realDistanceSq <= (float)this.realRadiusSquared) || !destinationMask.test(maskContext.reset(), x + xo, y + yo, z + zo)) continue;
                    chunkedBlockRegion.addBlockWithoutDirty(x + xo, y + yo, z + zo, this.constantBlock);
                }
            });
        }
    }

    public record ZeroRadiusDynamicBlock(FloatUnaryOperator[] easings, class_2680[] blocks, WhiteNoise whiteNoise) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3f from, Vector3f to, int index, float minPartial, float partialLength) {
            Rasterization3D.ddaPartial(from, to, (x, y, z, f) -> {
                if (!destinationMask.test(maskContext.reset(), x, y, z)) {
                    return;
                }
                float partial = minPartial + partialLength * f;
                partial = this.easings[index].apply(partial);
                if (this.whiteNoise.evaluate(x, y, z) > partial) {
                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, this.blocks[index]);
                } else {
                    chunkedBlockRegion.addBlockWithoutDirty(x, y, z, this.blocks[index + 1]);
                }
            });
        }
    }

    public record ZeroRadiusConstantBlock(class_2680 constantBlock) implements PathRasterizer
    {
        @Override
        public void rasterize(ChunkedBlockRegion chunkedBlockRegion, MaskElement destinationMask, MaskContext maskContext, Vector3f from, Vector3f to, int index, float minPartial, float partialLength) {
            Rasterization3D.dda(from, to, (x, y, z) -> {
                if (!destinationMask.test(maskContext.reset(), x, y, z)) {
                    return;
                }
                chunkedBlockRegion.addBlockWithoutDirty(x, y, z, this.constantBlock);
            });
        }
    }
}

