/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.render;

import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.configuration.Configuration;
import com.moulberry.axiom.core_rendering.AxiomBufferUsage;
import com.moulberry.axiom.core_rendering.AxiomDrawBuffer;
import com.moulberry.axiom.render.BlockTessellator;
import com.moulberry.axiom.render.MeshDataHelper;
import com.moulberry.axiom.render.SortStateWrapper;
import com.moulberry.axiom.render.VertexConsumerProvider;
import com.moulberry.axiom.utils.NvidiumApiWrapper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.fabricmc.fabric.api.blockview.v2.FabricBlockView;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2841;
import net.minecraft.class_287;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6539;
import net.minecraft.class_750;
import net.minecraft.class_776;
import net.minecraft.class_778;
import net.minecraft.class_8251;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public final class ChunkRenderOverrider
extends Enum<ChunkRenderOverrider> {
    public static final /* enum */ ChunkRenderOverrider INSTANCE = new ChunkRenderOverrider();
    private final Position2ObjectMap<class_2680> blocksOverride = new Position2ObjectMap(k -> new class_2680[4096]);
    private final AtomicBoolean stopBuilding = new AtomicBoolean(false);
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Lock lock = new ReentrantLock();
    private String lockedBy = null;
    private BooleanCutoutMode pendingBooleanCutoutMode = null;
    private final class_750 chunkBufferBuilderPack = new class_750();
    private final Long2ObjectMap<RenderedChunkData> chunkData = new Long2ObjectOpenHashMap();
    private LongSet dirtyChunks = new LongOpenHashSet();
    private Future<CompileData> compileFuture = null;
    private final EnumSet<AxiomChunkOverrideLayer> globalHasBlocks = EnumSet.noneOf(AxiomChunkOverrideLayer.class);
    private long lastSortMillis;
    private float lastSortX;
    private float lastSortY;
    private float lastSortZ;
    private int lastSortChunkX;
    private int lastSortChunkY;
    private int lastSortChunkZ;
    private boolean disabled = false;
    private final List<RenderedChunkData> sortedChunkData = new ArrayList<RenderedChunkData>();
    private static final /* synthetic */ ChunkRenderOverrider[] $VALUES;

    public static ChunkRenderOverrider[] values() {
        return (ChunkRenderOverrider[])$VALUES.clone();
    }

    public static ChunkRenderOverrider valueOf(String name) {
        return Enum.valueOf(ChunkRenderOverrider.class, name);
    }

    private static class_2680[] loadBlocks(long k) {
        class_2338 pos;
        class_2791 chunk;
        Object[] array = new class_2680[4096];
        if (class_310.method_1551().field_1687 != null && (chunk = class_310.method_1551().field_1687.method_8402((pos = class_2338.method_10092((long)k)).method_10263(), pos.method_10260(), class_2806.field_12803, false)) != null) {
            int sectionIndex = chunk.method_31603(pos.method_10264());
            class_2841 states = chunk.method_38259(sectionIndex).method_12265();
            int index = 0;
            for (int z = 0; z < 16; ++z) {
                for (int y = 0; y < 16; ++y) {
                    for (int x = 0; x < 16; ++x) {
                        array[index++] = (class_2680)states.method_12321(x, y, z);
                    }
                }
            }
            return array;
        }
        Arrays.fill(array, class_2246.field_10124.method_9564());
        return array;
    }

    public void acquire(String identifier) {
        if (this.lockedBy != null || !this.lock.tryLock()) {
            throw new Error("ChunkRenderOverrider: '" + identifier + "' tried to acquire() when it shouldn't have OR '" + this.lockedBy + "' forgot to call release()... naughty naughty");
        }
        this.lockedBy = identifier;
    }

    public void release(String identifier) {
        if (!identifier.equals(this.lockedBy)) {
            throw new Error("ChunkRenderOverrider: '" + identifier + "' tried to release() even though '" + this.lockedBy + "' owns it");
        }
        this.lockedBy = null;
        this.clear();
        this.lock.unlock();
    }

    public void invalidateChunkSection(int x, int y, int z) {
        if (this.chunkData.isEmpty()) {
            return;
        }
        long key = class_2338.method_10064((int)x, (int)y, (int)z);
        if (this.chunkData.containsKey(key)) {
            this.dirtyChunks.add(key);
        }
    }

    public void clear() {
        if (this.compileFuture != null) {
            this.stopBuilding.set(true);
        }
        this.blocksOverride.clear();
        this.dirtyChunks.clear();
        this.sortedChunkData.forEach(data -> data.buffers.forEach((type2, buffer) -> buffer.close()));
        this.pendingBooleanCutoutMode = null;
        this.globalHasBlocks.clear();
        this.sortedChunkData.clear();
        if (NvidiumApiWrapper.isNvidiumAvailable()) {
            this.unhideAllNvidium();
        }
        this.chunkData.clear();
    }

    private void unhideAllNvidium() {
        LongIterator longIterator = this.chunkData.keySet().longIterator();
        while (longIterator.hasNext()) {
            long pos = longIterator.nextLong();
            NvidiumApiWrapper.showSection(class_2338.method_10061((long)pos), class_2338.method_10071((long)pos), class_2338.method_10083((long)pos));
        }
    }

    public boolean isOverridingSection(int sx, int sy, int sz) {
        return !this.disabled && this.chunkData.containsKey(class_2338.method_10064((int)sx, (int)sy, (int)sz));
    }

    /*
     * Exception decompiling
     */
    public void render(AxiomChunkOverrideLayer layer, class_276 target, Matrix4f modelViewMatrix, double cameraX, double cameraY, double cameraZ) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.ClassCastException: class org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement cannot be cast to class org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement (org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement and org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement are in unnamed module of loader 'app')
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter$LValueSingleUsageCheckingRewriter.rewriteExpression(SwitchExpressionRewriter.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.LValueExpression.applyExpressionRewriter(LValueExpression.java:84)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ArithmeticOperation.applyExpressionRewriter(ArithmeticOperation.java:171)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.AssignmentSimple.rewriteExpressions(AssignmentSimple.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredFor.rewriteExpressions(StructuredFor.java:194)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:24)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredIf.transformStructuredChildren(StructuredIf.java:96)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.transformStructuredChildren(Block.java:421)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.transformers.ExpressionRewriterTransformer.transform(ExpressionRewriterTransformer.java:25)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.transform(Op04StructuredStatement.java:680)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.rewriteBlockSwitches(SwitchExpressionRewriter.java:140)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.SwitchExpressionRewriter.transform(SwitchExpressionRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.switchExpression(Op04StructuredStatement.java:101)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:909)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void revertBlock(int x, int y, int z) {
        int mz;
        int pz;
        int my;
        int py;
        int mx;
        if (Configuration.rendering.disableChunkRenderOverrider) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null || y < level.method_31607() || y > level.method_31600() - 1) {
            return;
        }
        int cx = x >> 4;
        int cy = y >> 4;
        int cz = z >> 4;
        this.blocksOverride.put(x, y, z, null);
        this.dirtyChunks.add(class_2338.method_10064((int)cx, (int)cy, (int)cz));
        int px = x + 1 >> 4;
        if (px != cx) {
            long pos = class_2338.method_10064((int)px, (int)cy, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((mx = x - 1 >> 4) != cx) {
            long pos = class_2338.method_10064((int)mx, (int)cy, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((py = y + 1 >> 4) != cy && py <= level.method_31597() - 1) {
            long pos = class_2338.method_10064((int)cx, (int)py, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((my = y - 1 >> 4) != cy && my >= level.method_32891()) {
            long pos = class_2338.method_10064((int)cx, (int)my, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((pz = z + 1 >> 4) != cz) {
            long pos = class_2338.method_10064((int)cx, (int)cy, (int)pz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((mz = z - 1 >> 4) != cz) {
            long pos = class_2338.method_10064((int)cx, (int)cy, (int)mz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
    }

    public void setBlock(int x, int y, int z, class_2680 block) {
        int mz;
        int pz;
        int my;
        int py;
        int mx;
        if (Configuration.rendering.disableChunkRenderOverrider) {
            return;
        }
        class_638 level = class_310.method_1551().field_1687;
        if (level == null || y < level.method_31607() || y > level.method_31600() - 1) {
            return;
        }
        int cx = x >> 4;
        int cy = y >> 4;
        int cz = z >> 4;
        this.blocksOverride.put(x, y, z, block);
        this.dirtyChunks.add(class_2338.method_10064((int)cx, (int)cy, (int)cz));
        int px = x + 1 >> 4;
        if (px != cx) {
            long pos = class_2338.method_10064((int)px, (int)cy, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((mx = x - 1 >> 4) != cx) {
            long pos = class_2338.method_10064((int)mx, (int)cy, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((py = y + 1 >> 4) != cy && py <= level.method_31597() - 1) {
            long pos = class_2338.method_10064((int)cx, (int)py, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((my = y - 1 >> 4) != cy && my >= level.method_32891()) {
            long pos = class_2338.method_10064((int)cx, (int)my, (int)cz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((pz = z + 1 >> 4) != cz) {
            long pos = class_2338.method_10064((int)cx, (int)cy, (int)pz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
        if ((mz = z - 1 >> 4) != cz) {
            long pos = class_2338.method_10064((int)cx, (int)cy, (int)mz);
            this.blocksOverride.getOrCreateChunk(pos);
            this.dirtyChunks.add(pos);
        }
    }

    public void uploadDirty(double sortX, double sortY, double sortZ) {
        if (Configuration.rendering.disableChunkRenderOverrider) {
            this.dirtyChunks.clear();
            return;
        }
        if (this.compileFuture != null && this.compileFuture.isDone()) {
            CompileData asyncCompileChunkData;
            try {
                asyncCompileChunkData = this.compileFuture.get();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (asyncCompileChunkData == null || this.stopBuilding.get()) {
                this.chunkBufferBuilderPack.method_23501();
            } else {
                boolean hasNvidium = NvidiumApiWrapper.isNvidiumAvailable();
                if (asyncCompileChunkData.clear()) {
                    if (hasNvidium) {
                        this.unhideAllNvidium();
                    }
                    this.sortedChunkData.forEach(data -> data.buffers.forEach((type2, buffer) -> buffer.close()));
                    this.sortedChunkData.clear();
                    this.chunkData.clear();
                }
                for (CompiledChunkData compiled : asyncCompileChunkData.compiledChunks()) {
                    long pos = class_2338.method_10064((int)(compiled.offsetX >> 4), (int)(compiled.offsetY >> 4), (int)(compiled.offsetZ >> 4));
                    RenderedChunkData chunkDatum = (RenderedChunkData)this.chunkData.get(pos);
                    if (chunkDatum == null) {
                        chunkDatum = new RenderedChunkData(compiled.offsetX, compiled.offsetY, compiled.offsetZ);
                        this.chunkData.put(pos, (Object)chunkDatum);
                        if (hasNvidium) {
                            NvidiumApiWrapper.hideSection(compiled.offsetX >> 4, compiled.offsetY >> 4, compiled.offsetZ >> 4);
                        }
                        float dx = this.lastSortChunkX * 16 - chunkDatum.offsetX;
                        float dy = this.lastSortChunkY * 16 - chunkDatum.offsetY;
                        float dz = this.lastSortChunkZ * 16 - chunkDatum.offsetZ;
                        chunkDatum.distanceSqToCamera = dx * dx + dy * dy + dz * dz;
                        int min2 = 0;
                        int max2 = this.sortedChunkData.size();
                        int pivot = (min2 + max2) / 2;
                        while (min2 != max2) {
                            RenderedChunkData pivotElement = this.sortedChunkData.get(pivot);
                            if (chunkDatum.distanceSqToCamera < pivotElement.distanceSqToCamera) {
                                max2 = pivot;
                            } else {
                                min2 = pivot + 1;
                            }
                            pivot = (min2 + max2) / 2;
                        }
                        this.sortedChunkData.add(pivot, chunkDatum);
                    }
                    assert (chunkDatum.offsetX == compiled.offsetX);
                    assert (chunkDatum.offsetY == compiled.offsetY);
                    assert (chunkDatum.offsetZ == compiled.offsetZ);
                    chunkDatum.hasBlocks.clear();
                    chunkDatum.hasBlocks.addAll(compiled.buffers.keySet());
                    chunkDatum.sortState = compiled.sortState;
                    for (Map.Entry<AxiomChunkOverrideLayer, class_9801> entry : compiled.buffers.entrySet()) {
                        AxiomDrawBuffer buffer = chunkDatum.buffers.computeIfAbsent(entry.getKey(), k -> new AxiomDrawBuffer(AxiomBufferUsage.STATIC_WRITE));
                        buffer.upload(entry.getValue());
                    }
                    this.globalHasBlocks.addAll(chunkDatum.hasBlocks);
                }
                this.chunkBufferBuilderPack.method_22705();
            }
            this.compileFuture = null;
            this.stopBuilding.set(false);
        }
        if (this.compileFuture == null) {
            if (!this.dirtyChunks.isEmpty()) {
                this.pendingBooleanCutoutMode = null;
            } else if (this.pendingBooleanCutoutMode != null) {
                this.blocksOverride.clear();
                class_2338 offset = this.pendingBooleanCutoutMode.offset();
                int offsetX = offset.method_10263();
                int offsetY = offset.method_10264();
                int offsetZ = offset.method_10260();
                this.pendingBooleanCutoutMode.positionSet().forEach((x, y, z) -> this.setBlock(x + offsetX, y + offsetY, z + offsetZ, class_2246.field_10124.method_9564()));
            }
            if (!this.dirtyChunks.isEmpty()) {
                class_638 level = class_310.method_1551().field_1687;
                if (level == null) {
                    throw new IllegalStateException();
                }
                LongSet chunksToUpload = this.dirtyChunks;
                this.dirtyChunks = new LongOpenHashSet();
                boolean clear = this.pendingBooleanCutoutMode != null;
                Position2ObjectMap<class_2680> copied = new Position2ObjectMap<class_2680>(ChunkRenderOverrider::loadBlocks);
                LongOpenHashSet chunksToUploadAndNeighbors = new LongOpenHashSet();
                LongIterator iter = chunksToUpload.iterator();
                while (iter.hasNext()) {
                    long l = iter.nextLong();
                    int cx = class_2338.method_10061((long)l);
                    int cy = class_2338.method_10071((long)l);
                    int cz = class_2338.method_10083((long)l);
                    chunksToUploadAndNeighbors.add(l);
                    int minY = cy > level.method_32891() ? -1 : 0;
                    int maxY = cy < level.method_31597() - 1 ? 1 : 0;
                    for (int oy = minY; oy <= maxY; ++oy) {
                        for (int ox = -1; ox <= 1; ++ox) {
                            for (int oz = -1; oz <= 1; ++oz) {
                                chunksToUploadAndNeighbors.add(class_2338.method_10064((int)(cx + ox), (int)(cy + oy), (int)(cz + oz)));
                            }
                        }
                    }
                }
                copied.mergeAllFrom(this.blocksOverride, (LongSet)chunksToUploadAndNeighbors);
                MappedBlockAndTintGetter blockAndTintGetter = new MappedBlockAndTintGetter(copied, (class_1937)class_310.method_1551().field_1687);
                this.compileFuture = this.executor.submit(() -> {
                    ArrayList<CompiledChunkData> list = new ArrayList<CompiledChunkData>(chunksToUpload.size());
                    class_776 blockRenderDispatcher = class_310.method_1551().method_1541();
                    class_4587 poseStack = new class_4587();
                    class_2338.class_2339 blockPos = new class_2338.class_2339();
                    BlockTessellator blockTessellator = new BlockTessellator(class_310.method_1588(), false);
                    LongIterator longIterator = chunksToUpload.iterator();
                    while (longIterator.hasNext()) {
                        long pos = (Long)longIterator.next();
                        if (this.stopBuilding.compareAndSet(true, false)) {
                            return null;
                        }
                        int offsetX = class_2338.method_10061((long)pos) * 16;
                        int offsetY = class_2338.method_10071((long)pos) * 16;
                        int offsetZ = class_2338.method_10083((long)pos) * 16;
                        CompiledChunkData compiled = new CompiledChunkData(offsetX, offsetY, offsetZ);
                        EnumMap<AxiomChunkOverrideLayer, class_287> bufferBuilderMap = new EnumMap<AxiomChunkOverrideLayer, class_287>(AxiomChunkOverrideLayer.class);
                        class_2680[] blocks = (class_2680[])copied.getChunk(pos);
                        if (blocks == null) continue;
                        class_5819 rand = class_5819.method_43047();
                        class_778.method_20544();
                        int index = 0;
                        for (int z = 0; z < 16; ++z) {
                            for (int y = 0; y < 16; ++y) {
                                for (int x = 0; x < 16; ++x) {
                                    class_9799 byteBufferBuilder;
                                    class_287 bufferBuilder;
                                    AxiomChunkOverrideLayer layer;
                                    class_1921 renderType;
                                    class_2680 blockState = blocks[index++];
                                    blockPos.method_10103(offsetX + x, offsetY + y, offsetZ + z);
                                    class_3610 fluidState = blockState.method_26227();
                                    if (!fluidState.method_15769()) {
                                        renderType = class_4696.method_23680((class_3610)fluidState);
                                        layer = AxiomChunkOverrideLayer.fromVanilla(renderType);
                                        if (bufferBuilderMap.containsKey((Object)layer)) {
                                            bufferBuilder = (class_287)bufferBuilderMap.get((Object)layer);
                                        } else {
                                            byteBufferBuilder = this.chunkBufferBuilderPack.method_3154(renderType);
                                            bufferBuilder = new class_287(byteBufferBuilder, class_293.class_5596.field_27382, class_290.field_1590);
                                            bufferBuilderMap.put(layer, bufferBuilder);
                                        }
                                        blockRenderDispatcher.method_3352((class_2338)blockPos, blockAndTintGetter, (class_4588)bufferBuilder, blockState, fluidState);
                                    }
                                    if (blockState.method_26217() != class_2464.field_11458) continue;
                                    renderType = class_4696.method_23679((class_2680)blockState);
                                    layer = AxiomChunkOverrideLayer.fromVanilla(renderType);
                                    if (bufferBuilderMap.containsKey((Object)layer)) {
                                        bufferBuilder = (class_287)bufferBuilderMap.get((Object)layer);
                                    } else {
                                        byteBufferBuilder = this.chunkBufferBuilderPack.method_3154(renderType);
                                        bufferBuilder = new class_287(byteBufferBuilder, class_293.class_5596.field_27382, class_290.field_1590);
                                        bufferBuilderMap.put(layer, bufferBuilder);
                                    }
                                    poseStack.method_22903();
                                    poseStack.method_46416((float)x, (float)y, (float)z);
                                    blockTessellator.tessellateBlock(blockRenderDispatcher, blockState, blockAndTintGetter, (class_2338)blockPos, bufferBuilder, rand, poseStack);
                                    poseStack.method_22909();
                                }
                            }
                        }
                        for (Map.Entry entry : bufferBuilderMap.entrySet()) {
                            AxiomChunkOverrideLayer layer = entry.getKey();
                            class_287 builder = (class_287)entry.getValue();
                            if (layer.needsSorting) {
                                MeshDataHelper.MeshDataAndSortState meshDataAndSortState = MeshDataHelper.buildAndSort(builder, class_8251.method_49906((float)((float)(sortX - (double)compiled.offsetX)), (float)((float)(sortY - (double)compiled.offsetY)), (float)((float)(sortZ - (double)compiled.offsetZ))));
                                if (meshDataAndSortState == null) continue;
                                compiled.buffers.put(layer, meshDataAndSortState.meshData());
                                compiled.sortState = meshDataAndSortState.sortStateWrapper();
                                continue;
                            }
                            class_9801 meshData = builder.method_60794();
                            if (meshData == null) continue;
                            compiled.buffers.put(layer, meshData);
                        }
                        list.add(compiled);
                        class_778.method_20545();
                    }
                    return new CompileData(list, clear);
                });
            }
            this.pendingBooleanCutoutMode = null;
        }
        boolean hasLayerWithSorting = false;
        for (AxiomChunkOverrideLayer layer : this.globalHasBlocks) {
            if (!layer.needsSorting) continue;
            hasLayerWithSorting = true;
            break;
        }
        if (!hasLayerWithSorting) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastSortMillis < 200L) {
            return;
        }
        this.lastSortMillis = currentTime;
        double dX = sortX - (double)this.lastSortX;
        double dY = sortY - (double)this.lastSortY;
        double dZ = sortZ - (double)this.lastSortZ;
        if (dX * dX + dY * dY + dZ * dZ > 1.0) {
            this.lastSortX = (float)sortX;
            this.lastSortY = (float)sortY;
            this.lastSortZ = (float)sortZ;
            int chunkX = class_4076.method_32204((double)sortX);
            int chunkY = class_4076.method_32204((double)sortY);
            int chunkZ = class_4076.method_32204((double)sortZ);
            boolean resortChunkList = chunkX != this.lastSortChunkX || chunkY != this.lastSortChunkY || chunkZ != this.lastSortChunkZ;
            VertexConsumerProvider provider = VertexConsumerProvider.shared();
            for (RenderedChunkData chunkDatum : this.sortedChunkData) {
                for (Map.Entry<AxiomChunkOverrideLayer, AxiomDrawBuffer> entry : chunkDatum.buffers.entrySet()) {
                    if (!entry.getKey().needsSorting) continue;
                    float relSortX = (float)(sortX - (double)chunkDatum.offsetX);
                    float relSortY = (float)(sortY - (double)chunkDatum.offsetY);
                    float relSortZ = (float)(sortZ - (double)chunkDatum.offsetZ);
                    class_287 bufferBuilder = provider.begin(class_293.class_5596.field_27382, class_290.field_1590);
                    AxiomDrawBuffer vertexBuffer = entry.getValue();
                    if (vertexBuffer == null || chunkDatum.sortState == null) continue;
                    chunkDatum.sortState = MeshDataHelper.resort(bufferBuilder, chunkDatum.sortState, vertexBuffer, class_8251.method_49906((float)relSortX, (float)relSortY, (float)relSortZ));
                }
                if (!resortChunkList) continue;
                float dx = chunkX * 16 - chunkDatum.offsetX;
                float dy = chunkY * 16 - chunkDatum.offsetY;
                float dz = chunkZ * 16 - chunkDatum.offsetZ;
                chunkDatum.distanceSqToCamera = dx * dx + dy * dy + dz * dz;
            }
            if (resortChunkList) {
                this.lastSortChunkX = chunkX;
                this.lastSortChunkY = chunkY;
                this.lastSortChunkZ = chunkZ;
                this.sortedChunkData.sort(Comparator.comparingDouble(c -> -c.distanceSqToCamera));
            }
        }
    }

    public void cutoutBoolean(PositionSet set, class_2338 offset) {
        if (Configuration.rendering.disableChunkRenderOverrider) {
            return;
        }
        if (set.isEmpty()) {
            return;
        }
        this.pendingBooleanCutoutMode = new BooleanCutoutMode(set, offset);
    }

    private static /* synthetic */ ChunkRenderOverrider[] $values() {
        return new ChunkRenderOverrider[]{INSTANCE};
    }

    static {
        $VALUES = ChunkRenderOverrider.$values();
    }

    private record BooleanCutoutMode(PositionSet positionSet, class_2338 offset) {
    }

    public static enum AxiomChunkOverrideLayer {
        SOLID(false, false),
        CUTOUT_MIPPED(false, false),
        CUTOUT(false, false),
        TRANSLUCENT(true, true),
        TRIPWIRE(false, false);

        public final boolean needsSorting;
        public final boolean isTranslucent;

        private AxiomChunkOverrideLayer(boolean needsSorting, boolean isTranslucent) {
            this.needsSorting = needsSorting;
            this.isTranslucent = isTranslucent;
        }

        public static AxiomChunkOverrideLayer fromVanilla(class_1921 layer) {
            if (layer == class_1921.method_23577()) {
                return SOLID;
            }
            if (layer == class_1921.method_23579()) {
                return CUTOUT_MIPPED;
            }
            if (layer == class_1921.method_23581()) {
                return CUTOUT;
            }
            if (layer == class_1921.method_29997()) {
                return TRIPWIRE;
            }
            return TRANSLUCENT;
        }
    }

    private static final class RenderedChunkData {
        EnumMap<AxiomChunkOverrideLayer, AxiomDrawBuffer> buffers = new EnumMap(AxiomChunkOverrideLayer.class);
        EnumSet<AxiomChunkOverrideLayer> hasBlocks = EnumSet.noneOf(AxiomChunkOverrideLayer.class);
        SortStateWrapper sortState = null;
        int offsetX;
        int offsetY;
        int offsetZ;
        float distanceSqToCamera;

        public RenderedChunkData(int offsetX, int offsetY, int offsetZ) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
        }
    }

    private record CompileData(List<CompiledChunkData> compiledChunks, boolean clear) {
    }

    private static final class CompiledChunkData {
        EnumMap<AxiomChunkOverrideLayer, class_9801> buffers = new EnumMap(AxiomChunkOverrideLayer.class);
        SortStateWrapper sortState = null;
        int offsetX;
        int offsetY;
        int offsetZ;

        public CompiledChunkData(int offsetX, int offsetY, int offsetZ) {
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
        }
    }

    private static final class MappedBlockAndTintGetter
    implements FabricBlockView,
    class_1920,
    RenderAttachedBlockView {
        private final Position2ObjectMap<class_2680> map;
        private final class_1937 level;

        private MappedBlockAndTintGetter(Position2ObjectMap<class_2680> map, class_1937 level) {
            this.map = map;
            this.level = level;
        }

        public float method_24852(class_2350 direction, boolean hasShade) {
            return this.level.method_24852(direction, hasShade);
        }

        @NotNull
        public class_3568 method_22336() {
            throw new UnsupportedOperationException();
        }

        public int method_8314(@NotNull class_1944 lightLayer, @NotNull class_2338 blockPos) {
            return lightLayer == class_1944.field_9282 ? 0 : 15;
        }

        public int method_22335(@NotNull class_2338 blockPos, int i) {
            return 15;
        }

        public int method_23752(@NotNull class_2338 blockPos, @NotNull class_6539 colorResolver) {
            return this.level.method_23752(blockPos, colorResolver);
        }

        @Nullable
        public class_2586 method_8321(@NotNull class_2338 blockPos) {
            return null;
        }

        @NotNull
        public class_2680 method_8320(class_2338 blockPos) {
            class_2680 mapped = this.map.get(blockPos.method_10263(), blockPos.method_10264(), blockPos.method_10260());
            return Objects.requireNonNullElse(mapped, class_2246.field_10124.method_9564());
        }

        @NotNull
        public class_3610 method_8316(@NotNull class_2338 blockPos) {
            return this.method_8320(blockPos).method_26227();
        }

        public int method_31605() {
            return this.level.method_31605();
        }

        public int method_31607() {
            return this.level.method_31607();
        }
    }
}

