/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.editor.windows;

import com.moulberry.axiom.custom_blocks.CustomBlockState;
import com.moulberry.axiom.editor.BlockList;
import com.moulberry.axiom.editor.EditorWindowType;
import com.moulberry.axiom.editor.ImGuiHelper;
import com.moulberry.axiom.editor.palette.ActiveBlockHistory;
import com.moulberry.axiom.editor.tutorial.TutorialManager;
import com.moulberry.axiom.editor.tutorial.TutorialStage;
import com.moulberry.axiom.editor.widgets.BlockStateWidget;
import com.moulberry.axiom.i18n.AxiomI18n;
import imgui.ImGui;
import net.minecraft.class_2246;

public class CurrentBlockWindow {
    private static final BlockStateWidget blockStateWidget = new BlockStateWidget(class_2246.field_10340);

    public static void render(ActiveBlockHistory activeBlockHistory, BlockList blockList) {
        boolean showTutorial;
        boolean bl = showTutorial = TutorialManager.getCurrentStage() == TutorialStage.ACTIVE_BLOCK;
        if (!EditorWindowType.ACTIVE_BLOCK.isOpen() && !showTutorial) {
            return;
        }
        if (EditorWindowType.ACTIVE_BLOCK.begin("###ActiveBlock", true)) {
            CustomBlockState blockState = activeBlockHistory.getActive();
            blockStateWidget.setBlockState(blockState);
            blockStateWidget.renderBlockSwitcher(blockList, "Block");
            ImGui.sameLine();
            ImGui.beginGroup();
            ImGuiHelper.pushStyleVar(14, ImGui.getStyle().getItemSpacingX(), 1.0f);
            ImGui.text(AxiomI18n.get(blockState.getCustomBlock().axiom$translationKey()));
            ImGui.text(blockState.getCustomBlock().axiom$getResourceLocation().toString());
            if (blockStateWidget.hasEditableProperties()) {
                ImGui.textDisabled(AxiomI18n.get("axiom.editorui.window.active_block.edit_properties_below"));
            }
            ImGuiHelper.popStyleVar();
            ImGui.endGroup();
            blockStateWidget.renderPropertySettings("Block", ImGui.isWindowDocked());
            activeBlockHistory.setActive(blockStateWidget.getBlockState());
            if (showTutorial) {
                TutorialStage.ACTIVE_BLOCK.render(ImGui.getWindowPos(), ImGui.getWindowSize());
            }
        } else if (showTutorial) {
            TutorialManager.nextTutorialStage();
        }
        EditorWindowType.ACTIVE_BLOCK.end();
    }
}

